/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.spi.net4j;

import java.util.LinkedHashSet;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.SelfAttachingContainerListener;
import org.eclipse.net4j.util.container.SetContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;

public class ChannelContainer
extends SetContainer<IChannel> {
    private final IContainer<?> delegate;
    private final IListener delegateListener = new SelfAttachingContainerListener(){

        public void attach(Object element) {
            if (element instanceof IChannel) {
                ChannelContainer.this.addChannel((IChannel)element);
            }
            super.attach(element);
        }

        public void detach(Object element) {
            if (element instanceof IChannel) {
                IChannel channel = (IChannel)element;
                ChannelContainer.this.removeChannel(channel);
            }
            super.detach(element);
        }

        protected boolean shouldDescend(Object element) {
            return element instanceof IManagedContainer || element instanceof IAcceptor || element instanceof IConnector;
        }

        protected void notifyOtherEvent(IEvent event) {
            INotifier source = event.getSource();
            if (source instanceof IChannel) {
                ChannelContainer.this.notifyChannelEvent(event);
            } else if (source instanceof IProtocol) {
                ChannelContainer.this.notifyProtocolEvent(event);
            }
        }
    };

    public ChannelContainer(IContainer<?> delegate) {
        super(IChannel.class, new LinkedHashSet());
        this.delegate = delegate;
    }

    protected void notifyChannelEvent(IEvent event) {
    }

    protected void notifyProtocolEvent(IEvent event) {
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.delegate.addListener(this.delegateListener);
    }

    protected void doDeactivate() throws Exception {
        this.delegate.removeListener(this.delegateListener);
        super.doDeactivate();
    }

    protected void addChannel(IChannel channel) {
        this.addElement(channel);
        IBufferHandler receiveHandler = channel.getReceiveHandler();
        if (receiveHandler instanceof IProtocol) {
            EventUtil.addUniqueListener((Object)receiveHandler, (IListener)this.delegateListener);
        }
    }

    protected void removeChannel(IChannel channel) {
        this.removeElement(channel);
        IBufferHandler receiveHandler = channel.getReceiveHandler();
        if (receiveHandler instanceof IProtocol) {
            EventUtil.removeListener((Object)receiveHandler, (IListener)this.delegateListener);
        }
    }
}

