/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.actions;

import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;

public interface IOutlineContribution
extends IPreferenceStoreInitializer {
    public void register(OutlinePage var1);

    public void deregister(OutlinePage var1);

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface All {
    }

    public static class Composite
    implements IOutlineContribution {
        private List<IOutlineContribution> contributions;

        @Inject
        protected void initialize(Injector injector) {
            this.contributions = Lists.newArrayList();
            List bindings = injector.findBindingsByType(TypeLiteral.get(IOutlineContribution.class));
            for (Binding binding : bindings) {
                this.contributions.add((IOutlineContribution)injector.getInstance(binding.getKey()));
            }
        }

        @Override
        public void register(OutlinePage outlinePage) {
            for (IOutlineContribution contribution : this.contributions) {
                contribution.register(outlinePage);
            }
            TreeViewer treeViewer = outlinePage.getTreeViewer();
            if (!treeViewer.getTree().isDisposed()) {
                treeViewer.refresh();
            }
        }

        @Override
        public void deregister(OutlinePage outlinePage) {
            for (IOutlineContribution contribution : this.contributions) {
                contribution.deregister(outlinePage);
            }
        }

        @Override
        public void initialize(IPreferenceStoreAccess access) {
            for (IOutlineContribution contribution : this.contributions) {
                contribution.initialize(access);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface LinkWithEditor {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface Sort {
    }
}

