/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class PapyrusSelectionService
implements ISelectionChangedListener,
ISelectionProvider {
    private static PapyrusSelectionService instance;
    private ISelection selection;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

    public static PapyrusSelectionService getInstance() {
        if (instance == null) {
            instance = new PapyrusSelectionService();
        }
        return instance;
    }

    private PapyrusSelectionService() {
    }

    public void setSelectionProvider(ISelectionProvider selection) {
        selection.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void unsetSelectionProvider(ISelectionProvider selection) {
        selection.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

