/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import org.eclipse.emf.cdo.transaction.CDOUserSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOUserSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOUserTransaction;

public abstract class CDOUserSavepointImpl
implements InternalCDOUserSavepoint {
    private InternalCDOUserTransaction transaction;
    private InternalCDOUserSavepoint previousSavepoint;
    private InternalCDOUserSavepoint nextSavepoint;

    public CDOUserSavepointImpl(InternalCDOUserTransaction transaction, InternalCDOUserSavepoint lastSavepoint) {
        this.transaction = transaction;
        this.previousSavepoint = lastSavepoint;
        if (this.previousSavepoint != null) {
            this.previousSavepoint.setNextSavepoint(this);
        }
    }

    @Override
    public InternalCDOUserTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public InternalCDOUserSavepoint getPreviousSavepoint() {
        return this.previousSavepoint;
    }

    @Override
    public void setPreviousSavepoint(InternalCDOUserSavepoint previousSavepoint) {
        this.previousSavepoint = previousSavepoint;
    }

    @Override
    public InternalCDOUserSavepoint getNextSavepoint() {
        return this.nextSavepoint;
    }

    @Override
    public void setNextSavepoint(InternalCDOUserSavepoint nextSavepoint) {
        this.nextSavepoint = nextSavepoint;
    }

    @Override
    public InternalCDOUserSavepoint getFirstSavePoint() {
        return this.previousSavepoint != null ? this.previousSavepoint.getFirstSavePoint() : this;
    }

    @Override
    public boolean isValid() {
        InternalCDOUserSavepoint lastSavepoint;
        InternalCDOUserSavepoint savepoint = lastSavepoint = this.getTransaction().getLastSavepoint();
        while (savepoint != null) {
            if (savepoint == this) {
                return true;
            }
            savepoint = savepoint.getPreviousSavepoint();
        }
        return false;
    }

    @Override
    public int getNumber() {
        int number = 1;
        CDOUserSavepoint savepoint = this;
        while ((savepoint = savepoint.getPreviousSavepoint()) != null) {
            ++number;
        }
        return number;
    }

    public String toString() {
        return "Savepoint #" + this.getNumber();
    }
}

