/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitecturePlugin;
import org.eclipse.papyrus.infra.core.architecture.util.MergeTraceAdapter;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.tools.util.ClasspathHelper;
import org.eclipse.papyrus.infra.tools.util.Try;

public class ArchitectureCommandUtils {
    private static final String REQUIRED_BUNDLES = "requiredBundles";
    private static final String CLASS_CONSTRAINT = "classConstraint";
    private static final Map<EStructuralFeature, Class<?>> commandClassConstraints = new ConcurrentHashMap();

    public static Optional<Class<?>> getCommandType(EStructuralFeature commandClassFeature) {
        return Optional.ofNullable(commandClassConstraints.computeIfAbsent(commandClassFeature, ArchitectureCommandUtils::loadClassAnnotation));
    }

    private static Class<?> loadClassAnnotation(EStructuralFeature feature) {
        Class result = null;
        String classURI = EcoreUtil.getAnnotation((EModelElement)feature, (String)"http://www.eclipse.org/papyrus/infra/core/architecture", (String)CLASS_CONSTRAINT);
        if (classURI != null) {
            URI uri = URI.createURI((String)classURI);
            result = (Class)ClassLoaderHelper.loadClass((URI)uri).orElseApply(ArchitectureCommandUtils::fail);
        }
        return result;
    }

    private static String getBundleFromClassAnnotation(EObject owner, EStructuralFeature feature) {
        String result = null;
        if (owner.eIsSet(feature)) {
            String classURI = EcoreUtil.getAnnotation((EModelElement)feature, (String)"http://www.eclipse.org/papyrus/infra/core/architecture", (String)CLASS_CONSTRAINT);
            URI uri = classURI == null ? null : URI.createURI((String)classURI);
            Try bundleName = ClassLoaderHelper.getBundleName((URI)uri);
            result = (String)bundleName.orElse(null);
        }
        return result;
    }

    private static String getRequiredBundlesAnnotation(EObject owner, EStructuralFeature feature) {
        String result = null;
        if (owner.eIsSet(feature)) {
            result = EcoreUtil.getAnnotation((EModelElement)feature, (String)"http://www.eclipse.org/papyrus/infra/core/architecture", (String)REQUIRED_BUNDLES);
        }
        return result;
    }

    private static Class<?> fail(String message) {
        return ArchitectureCommandUtils.fail(new IllegalArgumentException(message));
    }

    private static Class<?> fail(Throwable exception) {
        ArchitecturePlugin.INSTANCE.log(exception);
        return Void.class;
    }

    public static Object getCommandClass(EObject modelObject, EStructuralFeature commandClassFeature) {
        return ArchitectureCommandUtils.getCommandClass(modelObject, commandClassFeature, ArchitectureCommandUtils.getCommandType(commandClassFeature));
    }

    private static Object getCommandClass(EObject modelObject, EStructuralFeature commandClassFeature, Optional<Class<?>> registeredType) {
        if (commandClassFeature.getEType().getInstanceClass() == Class.class) {
            Class result = (Class)modelObject.eGet(commandClassFeature);
            if (result != null && registeredType.isPresent() && !registeredType.get().isAssignableFrom(result)) {
                result = null;
            }
            return result;
        }
        String className = Optional.ofNullable(modelObject.eGet(commandClassFeature)).map(String::valueOf).orElse(null);
        if (className == null) {
            return null;
        }
        URI context = ArchitectureCommandUtils.getSourceURI(modelObject, commandClassFeature).trimFragment();
        return ClasspathHelper.INSTANCE.findClass(className, context, (Class)registeredType.orElse(null));
    }

    private static URI getSourceURI(EObject object, EStructuralFeature commandClassFeature) {
        URI result;
        if (!(object instanceof ADElement)) {
            result = EcoreUtil.getURI((EObject)object);
        } else {
            ADElement element = (ADElement)object;
            MergeTraceAdapter traces = MergeTraceAdapter.getMergeTraces(element);
            ADElement source = traces == null ? element : traces.trace(element, commandClassFeature);
            result = source == null ? EcoreUtil.getURI((EObject)element) : EcoreUtil.getURI((EObject)source);
        }
        return result;
    }

    public static Object getCommandClassUnconstrained(EObject modelObject, EStructuralFeature commandClassFeature) {
        return ArchitectureCommandUtils.getCommandClass(modelObject, commandClassFeature, Optional.empty());
    }

    public static Set<String> getRequiredCommandBundleDependencies(EObject modelObject) {
        HashSet<String> result = new HashSet<String>();
        HashMap<EClass, List<EStructuralFeature>> commandClassFeatures = new HashMap<EClass, List<EStructuralFeature>>();
        TreeIterator iter = EcoreUtil.getAllContents(Set.of(modelObject));
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            for (EStructuralFeature feature : ArchitectureCommandUtils.getCommandClassFeatures(next.eClass(), commandClassFeatures)) {
                String otherDependencies;
                String bundleDependencyByClass = ArchitectureCommandUtils.getBundleFromClassAnnotation(next, feature);
                if (bundleDependencyByClass != null) {
                    result.add(bundleDependencyByClass);
                }
                if ((otherDependencies = ArchitectureCommandUtils.getRequiredBundlesAnnotation(next, feature)) == null || otherDependencies.isBlank()) continue;
                Stream.of(otherDependencies.split("\\s*,\\s*")).forEach(result::add);
            }
        }
        return result;
    }

    private static Iterable<EStructuralFeature> getCommandClassFeatures(EClass eClass, Map<EClass, List<EStructuralFeature>> commandClassFeatures) {
        List<Object> result = commandClassFeatures.get(eClass);
        if (result == null) {
            result = eClass.getEAllStructuralFeatures().stream().filter(f -> EcoreUtil.getAnnotation((EModelElement)f, (String)"http://www.eclipse.org/papyrus/infra/core/architecture", (String)CLASS_CONSTRAINT) != null).collect(Collectors.toList());
            commandClassFeatures.put(eClass, result);
        }
        return result;
    }
}

