/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.strategy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategyManager;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.StrategyLabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class StrategyEditor
extends MultipleReferenceEditor {
    private static final String STRATEGIES = "Strategies";
    public static final int ACTIVATION_COLUMN = 0;
    public static final int LABEL_COLUMN = 1;
    protected Map<IStrategy, Button> checkboxes;
    protected IStrategyManager instance;

    public StrategyEditor(Composite parent, int style, IStrategyManager instance2) {
        this(parent, style, instance2, STRATEGIES);
    }

    public StrategyEditor(Composite parent, int style, IStrategyManager instance2, String label) {
        super(parent, style, true, true, label);
        this.instance = instance2;
        List<IStrategy> values = this.getStrategyManager().getAllStrategies();
        StaticContentProvider provider = new StaticContentProvider(values.toArray());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        this.setProviders((IStaticContentProvider)provider, (ILabelProvider)new StrategyLabelProvider(this.getStrategyManager()));
        this.setModelObservable((IObservableList)new StrategyObservableList(values));
        TableLayout layout = new TableLayout();
        new TreeColumn(this.tree, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 25, false));
        new TreeColumn(this.tree, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 250, true));
        this.tree.setLayout((Layout)layout);
        this.tree.setHeaderVisible(false);
        this.setToolTipText(STRATEGIES);
        this.treeViewer.refresh();
        this.checkboxes = new HashMap<IStrategy, Button>();
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof IStrategy) {
                TreeEditor editor = new TreeEditor(this.tree);
                final Button button = new Button((Composite)this.tree, 32);
                TreeItem currentItem = item;
                final IStrategy strategy = (IStrategy)currentItem.getData();
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        StrategyEditor.this.updateStrategy(strategy, button);
                        StrategyEditor.this.treeViewer.refresh();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.checkboxes.put(strategy, button);
                button.setSelection(this.getStrategyManager().isActive(strategy));
                editor.setEditor((Control)button, item, 0);
                editor.horizontalAlignment = 0x1000000;
                editor.grabHorizontal = true;
            }
            ++n2;
        }
        this.tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ISelection selection;
                if (e.keyCode == 32 && (selection = StrategyEditor.this.treeViewer.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Boolean isActive = StrategyEditor.this.findIsActive(structuredSelection);
                    for (Object element : structuredSelection) {
                        if (!(element instanceof IStrategy)) continue;
                        IStrategy strategy = (IStrategy)element;
                        Button button = StrategyEditor.this.checkboxes.get(strategy);
                        StrategyEditor.this.updateStrategy(strategy, button, isActive);
                    }
                    StrategyEditor.this.treeViewer.refresh();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public IStrategyManager getStrategyManager() {
        return this.instance;
    }

    private Boolean findIsActive(IStructuredSelection selection) {
        Boolean result = null;
        Iterator iterator = selection.iterator();
        while (result == null && iterator.hasNext()) {
            Object element = iterator.next();
            if (!(element instanceof IStrategy)) continue;
            boolean isActive = this.getStrategyManager().isActive((IStrategy)element);
            result = !isActive;
        }
        return result;
    }

    protected void updateStrategy(IStrategy strategy, Button button, boolean isActive) {
        this.getStrategyManager().setActive(strategy, isActive);
        button.setSelection(isActive);
    }

    protected void updateStrategy(IStrategy strategy, Button button) {
        boolean isActive = this.getStrategyManager().isActive(strategy);
        this.updateStrategy(strategy, button, !isActive);
    }

    public void createListControls() {
        super.createListControls();
        this.edit.dispose();
        this.remove.dispose();
        this.add.dispose();
        this.up.dispose();
        this.down.dispose();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StrategyEditor.this.updateControls();
            }
        });
    }

    protected Object[] getSelectedElements() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        return selection.toArray();
    }

    public void widgetSelected(SelectionEvent event) {
        super.widgetSelected(event);
    }

    protected void toggleAction(boolean activate) {
        Object[] selectedElements;
        Object[] objectArray = selectedElements = this.getSelectedElements();
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            if (selected instanceof IStrategy) {
                this.getStrategyManager().setActive((IStrategy)selected, activate);
            }
            ++n2;
        }
        this.treeViewer.refresh();
    }

    protected void updateControls() {
    }

    public void refresh() {
        for (Map.Entry<IStrategy, Button> entry : this.checkboxes.entrySet()) {
            boolean isActive = this.getStrategyManager().isActive(entry.getKey());
            this.updateStrategy(entry.getKey(), entry.getValue(), isActive);
        }
        this.treeViewer.refresh();
    }

    private class StrategyObservableList
    extends WritableList {
        public StrategyObservableList(List<IStrategy> values) {
            this.addAll(values);
        }

        public Object move(int oldIndex, int newIndex) {
            Object objectToMove = this.get(oldIndex);
            Object other = this.get(newIndex);
            if (objectToMove instanceof IStrategy && other instanceof IStrategy) {
                IStrategy strategyToMove = (IStrategy)objectToMove;
                IStrategy otherStrategy = (IStrategy)other;
                int priority = StrategyEditor.this.getStrategyManager().findPriority(otherStrategy);
                int newPriority = newIndex > oldIndex ? priority + 1 : priority - 1;
                StrategyEditor.this.getStrategyManager().setPriority(strategyToMove, newPriority);
            }
            return super.move(oldIndex, newIndex);
        }
    }
}

