/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.workingsets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.net4j.util.collection.CollectionUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class OthersWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String WORKING_SET_ID = "org.eclipse.emf.cdo.explorer.ui.OthersWorkingSet";
    public static final String WORKING_SET_NAME = "Other CDO Checkouts";
    private final IListener checkoutManagerListener = new ContainerEventAdapter<CDOCheckout>(){

        protected void notifyContainerEvent(IContainerEvent<CDOCheckout> event) {
            OthersWorkingSetUpdater.this.updateElements();
        }
    };
    private final IPropertyChangeListener workingSetManagerListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            IWorkingSet changedWorkingSet;
            if ("workingSetContentChange".equals(event.getProperty()) && (changedWorkingSet = (IWorkingSet)event.getNewValue()) != OthersWorkingSetUpdater.this.workingSet) {
                OthersWorkingSetUpdater.this.updateElements();
            }
        }
    };
    private IWorkingSet workingSet;

    public OthersWorkingSetUpdater() {
        CDOExplorerUtil.getCheckoutManager().addListener(this.checkoutManagerListener);
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.workingSetManagerListener);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.workingSetManagerListener);
        CDOExplorerUtil.getCheckoutManager().addListener(this.checkoutManagerListener);
    }

    public void add(IWorkingSet workingSet) {
        Assert.isTrue((this.workingSet == null ? 1 : 0) != 0);
        this.workingSet = workingSet;
    }

    public boolean remove(IWorkingSet workingSet) {
        Assert.isTrue((workingSet == this.workingSet ? 1 : 0) != 0);
        this.workingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet workingSet) {
        return workingSet == this.workingSet;
    }

    public void updateElements() {
        Object[] oldElements;
        Assert.isTrue((this.workingSet != null ? 1 : 0) != 0);
        HashSet allocatedCheckouts = new HashSet();
        IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getAllWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if ("org.eclipse.emf.cdo.explorer.ui.CheckoutWorkingSet".equals(workingSet.getId())) {
                IAdaptable[] iAdaptableArray = workingSet.getElements();
                int n3 = iAdaptableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable adaptable = iAdaptableArray[n4];
                    CollectionUtil.addNotNull(allocatedCheckouts, (Object)CDOExplorerUtil.getCheckout((Object)adaptable));
                    ++n4;
                }
            }
            ++n2;
        }
        LinkedHashSet<CDOCheckout> result = new LinkedHashSet<CDOCheckout>();
        CDOCheckout[] cDOCheckoutArray = CDOExplorerUtil.getCheckoutManager().getCheckouts();
        int n5 = cDOCheckoutArray.length;
        n = 0;
        while (n < n5) {
            CDOCheckout checkout = cDOCheckoutArray[n];
            if (!allocatedCheckouts.contains(checkout)) {
                result.add(checkout);
            }
            ++n;
        }
        Object[] newElements = result.toArray(new CDOCheckout[result.size()]);
        if (!Arrays.equals(newElements, oldElements = this.workingSet.getElements())) {
            UIUtil.asyncExec(() -> this.lambda$0((CDOCheckout[])newElements));
        }
    }

    private /* synthetic */ void lambda$0(CDOCheckout[] cDOCheckoutArray) {
        this.workingSet.setElements((IAdaptable[])cDOCheckoutArray);
    }
}

