/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.query.CompositePapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.query.IPapyrusQueryProvider;
import org.eclipse.papyrus.uml.search.ui.query.QueryInfo;

public class CompositePapyrusQueryProvider
implements IPapyrusQueryProvider {
    private static final CompositePapyrusQueryProvider INSTANCE = new CompositePapyrusQueryProvider();
    private final Iterable<? extends IPapyrusQueryProvider> queryProviders = this.loadQueryProviders();

    private CompositePapyrusQueryProvider() {
    }

    public static IPapyrusQueryProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canProvideFor(URI scope) {
        return true;
    }

    @Override
    public AbstractPapyrusQuery createSimpleSearchQuery(QueryInfo queryInfo) {
        Map<IPapyrusQueryProvider, Collection<URI>> partitions = this.partitionSearchScope(queryInfo.getScope());
        ArrayList<AbstractPapyrusQuery> result = new ArrayList<AbstractPapyrusQuery>(partitions.size());
        for (Map.Entry<IPapyrusQueryProvider, Collection<URI>> next : partitions.entrySet()) {
            AbstractPapyrusQuery query = next.getKey().createSimpleSearchQuery(queryInfo.partition(next.getValue()));
            if (query == null) continue;
            result.add(query);
        }
        return this.composite(result);
    }

    @Override
    public AbstractPapyrusQuery createAdvancedSearchQuery(QueryInfo queryInfo) {
        Map<IPapyrusQueryProvider, Collection<URI>> partitions = this.partitionSearchScope(queryInfo.getScope());
        ArrayList<AbstractPapyrusQuery> result = new ArrayList<AbstractPapyrusQuery>(partitions.size());
        for (Map.Entry<IPapyrusQueryProvider, Collection<URI>> next : partitions.entrySet()) {
            AbstractPapyrusQuery query = next.getKey().createAdvancedSearchQuery(queryInfo.partition(next.getValue()));
            if (query == null) continue;
            result.add(query);
        }
        return this.composite(result);
    }

    private AbstractPapyrusQuery composite(List<? extends AbstractPapyrusQuery> queries) {
        AbstractPapyrusQuery result = queries.isEmpty() ? AbstractPapyrusQuery.Empty.INSTANCE : (queries.size() == 1 ? queries.get(0) : new CompositePapyrusQuery(queries));
        return result;
    }

    Map<IPapyrusQueryProvider, Collection<URI>> partitionSearchScope(Collection<URI> scope) {
        HashMap<IPapyrusQueryProvider, Collection<URI>> result = new HashMap<IPapyrusQueryProvider, Collection<URI>>();
        Iterable<? extends IPapyrusQueryProvider> providers = this.getQueryProviders();
        block0: for (URI next : scope) {
            for (IPapyrusQueryProvider iPapyrusQueryProvider : providers) {
                if (!iPapyrusQueryProvider.canProvideFor(next)) continue;
                LinkedHashSet<URI> myScope = (LinkedHashSet<URI>)result.get(iPapyrusQueryProvider);
                if (myScope == null) {
                    myScope = new LinkedHashSet<URI>();
                    result.put(iPapyrusQueryProvider, myScope);
                }
                myScope.add(next);
                continue block0;
            }
        }
        return result;
    }

    private Iterable<? extends IPapyrusQueryProvider> loadQueryProviders() {
        return new ProvidersReader().load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Iterable<? extends IPapyrusQueryProvider> getQueryProviders() {
        ArrayList<IPapyrusQueryProvider> result = new ArrayList<IPapyrusQueryProvider>();
        Iterable<? extends IPapyrusQueryProvider> iterable = this.queryProviders;
        synchronized (iterable) {
            for (IPapyrusQueryProvider iPapyrusQueryProvider : this.queryProviders) {
                result.add(iPapyrusQueryProvider);
            }
        }
        return result;
    }

    private static class PriorityQueryProvider
    implements IPapyrusQueryProvider,
    Comparable<PriorityQueryProvider> {
        private final IPapyrusQueryProvider delegate;
        private final int priority;

        public PriorityQueryProvider(IPapyrusQueryProvider delegate, int priority) {
            this.delegate = delegate;
            this.priority = priority;
        }

        @Override
        public int compareTo(PriorityQueryProvider o) {
            return o.priority - this.priority;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PriorityQueryProvider && ((PriorityQueryProvider)obj).delegate.equals(this.delegate);
        }

        @Override
        public boolean canProvideFor(URI scope) {
            return this.delegate.canProvideFor(scope);
        }

        @Override
        public AbstractPapyrusQuery createSimpleSearchQuery(QueryInfo queryInfo) {
            return this.delegate.createSimpleSearchQuery(queryInfo);
        }

        @Override
        public AbstractPapyrusQuery createAdvancedSearchQuery(QueryInfo queryInfo) {
            return this.delegate.createAdvancedSearchQuery(queryInfo);
        }
    }

    private class ProvidersReader
    extends RegistryReader {
        private static final String EXT_PT = "queryProviders";
        private static final String TAG_PROVIDER = "queryProvider";
        private static final String ATTR_CLASS = "class";
        private static final String ATTR_PRIORITY = "priority";
        private final SortedSet<PriorityQueryProvider> providers;

        ProvidersReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.uml.search.ui", EXT_PT);
            this.providers = new TreeSet<PriorityQueryProvider>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterable<? extends IPapyrusQueryProvider> load() {
            SortedSet<PriorityQueryProvider> sortedSet = this.providers;
            synchronized (sortedSet) {
                this.providers.clear();
                this.readRegistry();
            }
            return this.providers;
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            boolean result = false;
            if (TAG_PROVIDER.equals(element.getName())) {
                result = true;
                String className = element.getAttribute(ATTR_CLASS);
                if (className == null || className.length() == 0) {
                    this.logMissingAttribute(element, ATTR_CLASS);
                } else if (add) {
                    this.addProvider(element, className);
                } else {
                    this.removeProvider(element, className);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addProvider(IConfigurationElement element, String className) {
            block9: {
                try {
                    Object provider = element.createExecutableExtension(ATTR_CLASS);
                    if (!(provider instanceof IPapyrusQueryProvider)) {
                        Activator.log.error("Query provider extension does not implement IPapyrusQueryProvider interface: " + className, null);
                        break block9;
                    }
                    String priorityString = element.getAttribute(ATTR_PRIORITY);
                    int priority = 0;
                    try {
                        if (priorityString != null && priorityString.length() > 0 && (priority = Integer.parseInt(priorityString)) < 0) {
                            Activator.log.warn("Negative priority in query provider " + className);
                            priority = 0;
                        }
                    }
                    catch (NumberFormatException e) {
                        Activator.log.warn("Not an integer priority in query provider " + className);
                    }
                    SortedSet<PriorityQueryProvider> sortedSet = this.providers;
                    synchronized (sortedSet) {
                        this.providers.add(new PriorityQueryProvider((IPapyrusQueryProvider)provider, priority));
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeProvider(IConfigurationElement element, String className) {
            SortedSet<PriorityQueryProvider> sortedSet = this.providers;
            synchronized (sortedSet) {
                Iterator iter = this.providers.iterator();
                while (iter.hasNext()) {
                    if (!((PriorityQueryProvider)iter.next()).delegate.getClass().getName().equals(className)) continue;
                    iter.remove();
                }
            }
        }
    }
}

