/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.swt.widgets.Display;

public final class Utils {
    private Utils() {
    }

    public static boolean safeEquals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static Set<EObject> getReferencingElementsToRemove(EObject element, EReference[] references, boolean viewsOnly, View expectedParentView, Class<?>[] expectedClasses) {
        HashSet<EObject> referencingElements = new HashSet<EObject>();
        Collection referencers = EMFCoreUtil.getReferencers((EObject)element, (EReference[])references);
        for (Object object : referencers) {
            if (!(object instanceof EObject) || !Utils.isExpectedClass(object, expectedClasses)) continue;
            EObject eObject = (EObject)object;
            if (!viewsOnly) {
                referencingElements.add(eObject);
            }
            Set crossReferencingViews = CrossReferencerUtil.getCrossReferencingViews((EObject)eObject, (String)"PapyrusUMLTimingDiagram");
            for (View view : crossReferencingViews) {
                if (expectedParentView != null && !ViewUtils.isContained(view, expectedParentView)) continue;
                referencingElements.add((EObject)view);
            }
        }
        return referencingElements;
    }

    private static boolean isExpectedClass(Object object, Class<?>[] expectedClasses) {
        Class<?>[] classArray = expectedClasses;
        int n = expectedClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> expectedClass = classArray[n2];
            if (expectedClass.isInstance(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void executeLaterUnprotected(final Command command, final TransactionalEditingDomain domain) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Map<String, Boolean> options = Collections.singletonMap("unprotected", Boolean.TRUE);
                    AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

                        protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            command.execute();
                            return Status.OK_STATUS;
                        }
                    };
                    operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
        });
    }

    public static Set<EObject> findReferencingElements(EObject element, EReference[] references, Class<?>[] expectedClasses) {
        HashSet<EObject> referencingElements = new HashSet<EObject>();
        Collection referencers = EMFCoreUtil.getReferencers((EObject)element, (EReference[])references);
        for (Object object : referencers) {
            if (!(object instanceof EObject) || !Utils.isExpectedClass(object, expectedClasses)) continue;
            EObject eObject = (EObject)object;
            referencingElements.add(eObject);
        }
        return referencingElements;
    }
}

