/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ContentTypeFirstResourceFactoryRegistry
extends ResourceFactoryRegistryImpl {
    private final @NonNull ResourceSet asResourceSet;

    public static Resource createResource(@NonNull ResourceSet asResourceSet, @NonNull URI uri, @NonNull String contentType) {
        Resource.Factory resourceFactory = null;
        Map contentTypeToFactoryMap = asResourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap();
        if (contentTypeToFactoryMap != null) {
            resourceFactory = ContentTypeFirstResourceFactoryRegistry.getContentTypeResourceFactory(contentTypeToFactoryMap, contentType);
        }
        if (resourceFactory != null) {
            Resource resource = resourceFactory.createResource(uri);
            assert (resource != null);
            asResourceSet.getResources().add((Object)resource);
            return resource;
        }
        return asResourceSet.createResource(uri, contentType);
    }

    protected static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Resource.Factory getContentTypeResourceFactory(@NonNull Map<String, Object> contentTypeIdentifierToFactoryMap, @NonNull String contentTypeIdentifier) {
        Object factory = contentTypeIdentifierToFactoryMap.get(contentTypeIdentifier);
        if (factory == null) {
            factory = Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().get(contentTypeIdentifier);
        }
        return ResourceFactoryRegistryImpl.convert((Object)factory);
    }

    public ContentTypeFirstResourceFactoryRegistry(@NonNull ResourceSet asResourceSet) {
        this.asResourceSet = asResourceSet;
    }

    protected Resource.Factory delegatedGetFactory(URI uri, String contentTypeIdentifier) {
        return ContentTypeFirstResourceFactoryRegistry.convert((Object)this.getFactory(uri, Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap(), Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap(), Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap(), contentTypeIdentifier, false));
    }

    protected Map<?, ?> getContentDescriptionOptions() {
        HashMap<String, Set> contentDescriptionOptions = new HashMap<String, Set>(this.asResourceSet.getLoadOptions());
        contentDescriptionOptions.put("REQUESTED_PROPERTIES", CONTENT_TYPE_REQUESTED_PROPERTIES);
        return contentDescriptionOptions;
    }

    protected Object getFactory(URI uri, Map<String, Object> protocolToFactoryMap, Map<String, Object> extensionToFactoryMap, Map<String, Object> contentTypeIdentifierToFactoryMap, String contentTypeIdentifier, boolean delegate) {
        if (contentTypeIdentifier != null) {
            assert (contentTypeIdentifierToFactoryMap != null);
            Resource.Factory resourceFactory = ContentTypeFirstResourceFactoryRegistry.getContentTypeResourceFactory(contentTypeIdentifierToFactoryMap, contentTypeIdentifier);
            if (resourceFactory != null) {
                return resourceFactory;
            }
        }
        return super.getFactory(uri, protocolToFactoryMap, extensionToFactoryMap, contentTypeIdentifierToFactoryMap, contentTypeIdentifier, delegate);
    }

    protected URIConverter getURIConverter() {
        return this.asResourceSet.getURIConverter();
    }
}

