/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model.annotations;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.generator.XtextGenerator;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.annotations.IClassAnnotation;

public class GeneratedClassAnnotation
implements IClassAnnotation {
    private boolean includeDate = false;
    private String comment;

    @Override
    public CharSequence generate() {
        StringBuilder stringBuilder = new StringBuilder("@Generated(");
        if (this.includeDate || !Strings.isEmpty((String)this.comment)) {
            stringBuilder.append("value = ");
        }
        stringBuilder.append("\"");
        stringBuilder.append(this.getGeneratorName());
        stringBuilder.append("\"");
        if (this.includeDate) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
            String date = dateFormat.format(new Date());
            stringBuilder.append(", date = \"");
            stringBuilder.append(date);
            stringBuilder.append("\"");
        }
        if (!Strings.isEmpty((String)this.comment)) {
            stringBuilder.append(", comments = \"");
            stringBuilder.append(Strings.convertToJavaString((String)this.comment));
            stringBuilder.append("\"");
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    protected String getGeneratorName() {
        return XtextGenerator.class.getName();
    }

    @Override
    public boolean appliesTo(JavaFileAccess javaFile) {
        return javaFile.isMarkedAsGenerated();
    }

    @Override
    public TypeReference getAnnotationImport() {
        return new TypeReference("javax.annotation.Generated");
    }

    public String toString() {
        return this.generate().toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof GeneratedClassAnnotation;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean isIncludeDate() {
        return this.includeDate;
    }

    public void setIncludeDate(boolean includeDate) {
        this.includeDate = includeDate;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

