/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.antlr;

import java.util.Stack;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.xtext.parser.antlr.AbstractSplittingTokenSource;
import org.eclipse.xtext.parser.antlr.ITokenAcceptor;

public abstract class AbstractIndentationTokenSource
extends AbstractSplittingTokenSource {
    protected Stack<Integer> indentationStack = new Stack();
    protected int currentOffset;
    protected int currentIndentation;
    protected int currentEnd;
    protected int nextOffset;

    protected AbstractIndentationTokenSource(TokenSource delegate) {
        this.indentationStack.push(0);
        this.currentOffset = 0;
        this.currentIndentation = 0;
        this.currentEnd = 0;
        this.nextOffset = 0;
        this.setDelegate(delegate);
    }

    @Override
    protected boolean shouldSplitToken(Token token) {
        return token.getType() == -1 || this.shouldSplitTokenImpl(token);
    }

    protected abstract boolean shouldSplitTokenImpl(Token var1);

    protected void doSplitEofToken(Token token, ITokenAcceptor result) {
        if (this.shouldEmitPendingEndTokens()) {
            while (this.indentationStack.size() > 1) {
                this.indentationStack.pop();
                result.accept(this.createEndToken(this.nextOffset));
            }
        }
        result.accept(token);
    }

    @Override
    protected void doSplitToken(Token token, ITokenAcceptor result) {
        if (token.getType() == -1) {
            this.doSplitEofToken(token, result);
        } else {
            this.doSplitTokenImpl(token, result);
        }
    }

    protected boolean shouldEmitPendingEndTokens() {
        return true;
    }

    @Override
    public Token nextToken() {
        Token result = super.nextToken();
        if (!(result instanceof CommonToken)) {
            throw new IllegalArgumentException(String.valueOf(result));
        }
        this.nextOffset = ((CommonToken)result).getStopIndex() + 1;
        return result;
    }

    protected void doSplitTokenImpl(Token token, ITokenAcceptor result) {
        String text = token.getText();
        int indentation = this.computeIndentation(text);
        if (indentation == -1 || indentation == this.currentIndentation) {
            result.accept(token);
        } else if (indentation > this.currentIndentation) {
            this.splitIntoBeginToken(token, indentation, result);
        } else if (indentation < this.currentIndentation) {
            int charCount = this.computeIndentationRelevantCharCount(text);
            if (charCount > 0) {
                this.splitWithText(token, text.substring(0, charCount), result);
            }
            this.decreaseIndentation(indentation, result);
            if (charCount != text.length()) {
                this.handleRemainingText(token, text.substring(charCount), indentation, result);
            }
        } else {
            throw new IllegalStateException(String.valueOf(indentation));
        }
    }

    protected void handleRemainingText(Token token, String text, int indentation, ITokenAcceptor result) {
        CommonToken trailingToken = this.createToken((CommonToken)token, text, null, null, this.nextOffset, null, null);
        if (indentation > this.currentIndentation) {
            this.splitIntoBeginToken((Token)trailingToken, indentation, result);
        } else {
            result.accept((Token)trailingToken);
        }
    }

    protected void decreaseIndentation(int indentation, ITokenAcceptor result) {
        while (indentation < this.currentIndentation) {
            this.indentationStack.pop();
            this.currentIndentation = this.indentationStack.peek();
            result.accept(this.createEndToken(this.nextOffset));
        }
    }

    protected void splitWithText(Token token, String text, ITokenAcceptor result) {
        CommonToken leadingToken = this.createToken((CommonToken)token, text, null, null, this.nextOffset, this.nextOffset + text.length() - 1, null);
        result.accept((Token)leadingToken);
        this.nextOffset += text.length();
    }

    private void splitIntoBeginToken(Token token, int indentation, ITokenAcceptor result) {
        result.accept(token);
        if (this.shouldEmitPendingEndTokens()) {
            Token nextToken = this.getDelegate().nextToken();
            if (this.shouldSplitToken(nextToken)) {
                this.nextOffset = ((CommonToken)token).getStopIndex() + 1;
                this.doSplitToken(nextToken, result);
            } else {
                this.indentationStack.push(indentation);
                this.currentIndentation = indentation;
                result.accept(this.createBeginToken(((CommonToken)token).getStopIndex() + 1));
                result.accept(nextToken);
            }
        } else {
            this.indentationStack.push(indentation);
            this.currentIndentation = indentation;
            result.accept(this.createBeginToken(((CommonToken)token).getStopIndex() + 1));
        }
    }

    protected Token createEndToken(int offset) {
        CommonToken result = new CommonToken(this.getEndTokenType());
        result.setText("");
        result.setChannel(0);
        result.setStartIndex(offset);
        result.setStopIndex(offset - 1);
        return result;
    }

    protected abstract int getEndTokenType();

    protected abstract int getBeginTokenType();

    protected Token createBeginToken(int offset) {
        CommonToken result = new CommonToken(this.getBeginTokenType());
        result.setText("");
        result.setChannel(0);
        result.setStartIndex(offset);
        result.setStopIndex(offset - 1);
        return result;
    }

    protected int computeIndentationRelevantCharCount(String text) {
        for (int result = 0; result < text.length(); ++result) {
            char c = text.charAt(result);
            if (c != '\n') continue;
            if (++result < text.length() && (c = text.charAt(result)) == '\r') {
                ++result;
            }
            return result;
        }
        return -1;
    }

    protected int computeIndentation(String text) {
        int result = 0;
        for (int i = text.length() - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                return result;
            }
            if (c == '\t') {
                result += this.getTabWidth();
                continue;
            }
            ++result;
        }
        return -1;
    }

    protected char getTabWidth() {
        return '\b';
    }
}

