/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ProfileTreeSelectionDialog
extends ElementImportTreeSelectionDialog<Profile> {
    List<String> subProfilesList;

    public ProfileTreeSelectionDialog(Shell parent, Package model) {
        this(parent, Collections.singletonList(model));
    }

    public ProfileTreeSelectionDialog(Shell parent, Collection<Package> model) {
        this(parent, model, new ArrayList<String>());
        this.subSelection = true;
    }

    public ProfileTreeSelectionDialog(Shell parent, Collection<Package> model, List<String> subprofiles) {
        super(parent, ElementImportTreeSelectionDialog.ImportAction.APPLY, Profile.class, model);
        this.subSelection = true;
        this.subProfilesList = subprofiles;
    }

    @Override
    public Collection<ElementImportTreeSelectionDialog.ImportSpec<Profile>> getResult() {
        ArrayList<ElementImportTreeSelectionDialog.ImportSpec<Profile>> result = new ArrayList<ElementImportTreeSelectionDialog.ImportSpec<Profile>>();
        for (ElementImportTreeSelectionDialog.ImportSpec currentElement : this.elementsToImport) {
            if (!(currentElement.getElement() instanceof Profile)) continue;
            result.add(currentElement);
        }
        return result;
    }

    @Override
    protected Collection<? extends Element> getChildren(Package package_) {
        ArrayList<Package> result = new ArrayList<Package>();
        for (Element elem : package_.getPackagedElements()) {
            if (!(elem instanceof Package)) continue;
            result.add((Package)elem);
        }
        return result;
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Choose profile(s) to apply");
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        Composite buttons = new Composite(result, 0);
        buttons.setLayout((Layout)new RowLayout());
        Button selectAll = new Button(buttons, 8);
        selectAll.setText("Select All");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileTreeSelectionDialog.this.selectAll(ElementImportTreeSelectionDialog.ImportAction.APPLY);
            }
        });
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText("Deselect All");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileTreeSelectionDialog.this.selectAll(ElementImportTreeSelectionDialog.ImportAction.NONE);
            }
        });
        TreeIterator iter = EcoreUtil.getAllContents((Collection)this.packages);
        while (iter.hasNext()) {
            Profile profile;
            String name;
            Object next = iter.next();
            if (!(next instanceof Profile) || (name = (profile = (Profile)next).getQualifiedName()) == null || !this.subProfilesList.contains(name)) continue;
            this.setInitialSelection(profile);
        }
        return result;
    }
}

