/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.policies;

import java.util.ArrayList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ViewComponentEditPolicy;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.AssociationClassEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.AssociationClassLinkEditPart;

public class DeleteLinkedAssociationClassViewEditPolicy
extends ViewComponentEditPolicy {
    public static final String HIDE_ROLE = String.valueOf(DeleteLinkedAssociationClassViewEditPolicy.class.getName()) + ":HideRole";

    public boolean understandsRequest(Request req) {
        return "delete".equals(req.getType());
    }

    public Command getCommand(Request request) {
        if (!"delete".equals(request.getType())) {
            return null;
        }
        if (!(request instanceof GroupRequest)) {
            return null;
        }
        GraphicalEditPart host = (GraphicalEditPart)this.getHost();
        if (host instanceof AssociationClassLinkEditPart) {
            return this.getAssociationClassLinkHideCommand(host);
        }
        if (host instanceof AssociationClassEditPart) {
            return this.getAssociationClassHideCommand(host);
        }
        return null;
    }

    private Command getAssociationClassLinkHideCommand(GraphicalEditPart host) {
        if (host.getSourceConnections() == null || host.getSourceConnections().isEmpty()) {
            return null;
        }
        EditPart dashedLink = (EditPart)host.getSourceConnections().get(0);
        if (!(dashedLink instanceof ConnectionEditPart)) {
            return null;
        }
        EditPart source = ((ConnectionEditPart)dashedLink).getTarget();
        if (source == null) {
            return null;
        }
        return this.getHideCommand(source, dashedLink);
    }

    private Command getAssociationClassHideCommand(GraphicalEditPart host) {
        if (host.getTargetConnections() == null || host.getTargetConnections().isEmpty()) {
            return null;
        }
        EditPart dashedLink = (EditPart)host.getTargetConnections().get(0);
        if (!(dashedLink instanceof ConnectionEditPart)) {
            return null;
        }
        EditPart source = ((ConnectionEditPart)dashedLink).getSource();
        if (source == null) {
            return null;
        }
        return this.getHideCommand(source, dashedLink);
    }

    private Command getHideCommand(EditPart source, EditPart dashedLink) {
        GroupRequest hideRequest = new GroupRequest((Object)"delete");
        ArrayList<EditPart> parts = new ArrayList<EditPart>();
        parts.add(dashedLink);
        parts.add(source);
        hideRequest.setEditParts(parts);
        return this.getDeleteCommand(hideRequest);
    }
}

