/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.emf.types.constraints.ElementTypeFilter;
import org.eclipse.papyrus.infra.emf.types.constraints.ElementTypeRelationshipKind;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;

public class ElementTypeFilterOperations {
    private static final ThreadLocal<List<IClientContext>> CLIENT_CONTEXT_STACK = ThreadLocal.withInitial(() -> new ArrayList(2));

    protected ElementTypeFilterOperations() {
    }

    static void inClientContext(IClientContext context, Runnable operation) {
        List<IClientContext> stack = null;
        if (context != null) {
            stack = CLIENT_CONTEXT_STACK.get();
            stack.add(context);
        }
        try {
            operation.run();
        }
        finally {
            if (stack != null) {
                stack.remove(stack.size() - 1);
            }
        }
    }

    static <T> T inClientContext(IClientContext context, Supplier<T> computation) {
        Object[] result = new Object[1];
        Runnable operation = () -> {
            Object t = computation.get();
        };
        ElementTypeFilterOperations.inClientContext(context, operation);
        return (T)result[0];
    }

    static IClientContext getClientContext() {
        List<IClientContext> stack = CLIENT_CONTEXT_STACK.get();
        return stack.isEmpty() ? null : stack.get(stack.size() - 1);
    }

    public static boolean matches(ElementTypeFilter elementTypeFilter, Object input) {
        IElementType type = ElementTypeFilterOperations.getElementType(elementTypeFilter.getElementType());
        List<IElementType> inputTypes = ElementTypeFilterOperations.getElementTypes(input);
        return type != null && !inputTypes.isEmpty() && ElementTypeFilterOperations.anyMatches(inputTypes, elementTypeFilter.getRelationship(), type);
    }

    private static IElementType getElementType(Object object) {
        List<IElementType> result = ElementTypeFilterOperations.getElementTypes(object);
        return result.isEmpty() ? null : result.get(0);
    }

    private static List<IElementType> getElementTypes(Object object) {
        List<Object> result;
        if (object instanceof IElementType) {
            result = List.of((IElementType)object);
        } else if (object instanceof ElementTypeConfiguration) {
            result = ElementTypeFilterOperations.getElementTypes(ElementTypeRegistry.getInstance().getType(((ElementTypeConfiguration)object).getIdentifier()));
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            IClientContext context = ElementTypeFilterOperations.getClientContext();
            result = context == null ? Arrays.asList(ElementTypeRegistry.getInstance().getAllTypesMatching(eObject)) : Arrays.asList(ElementTypeRegistry.getInstance().getAllTypesMatching(eObject, context));
        } else {
            result = List.of();
        }
        return result;
    }

    private static boolean anyMatches(Collection<IElementType> actual, ElementTypeRelationshipKind relationship, IElementType expected) {
        boolean result = actual.contains(expected);
        if (!result) {
            switch (relationship) {
                case SPECIALIZATION_TYPE: {
                    Set<ISpecializationType> specializations = Set.of(ElementTypeRegistry.getInstance().getSpecializationsOf(expected.getId()));
                    result = actual.stream().anyMatch(specializations::contains);
                    break;
                }
                case SUBTYPE: {
                    result = actual.stream().anyMatch(type -> Arrays.asList(type.getAllSuperTypes()).contains(expected));
                    break;
                }
                case SUPERTYPE: {
                    Set<IElementType> superTypes = Set.of(expected.getAllSuperTypes());
                    result = actual.stream().anyMatch(superTypes::contains);
                }
            }
        }
        return result;
    }
}

