/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.SchemaElementNotFoundException;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBSchemaElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBTable;

public final class DelegatingDBTable
extends DelegatingDBSchemaElement
implements InternalDBTable {
    DelegatingDBTable(InternalDBTable delegate) {
        super(delegate);
    }

    @Override
    public InternalDBTable getDelegate() {
        return (InternalDBTable)super.getDelegate();
    }

    @Override
    public void setDelegate(IDBSchemaElement delegate) {
        IDBField[] wrapperFields = this.getFields();
        IDBIndex[] wrapperIndices = this.getIndices();
        IDBTable delegateTable = (IDBTable)delegate;
        super.setDelegate(delegateTable);
        IDBSchemaElement[] iDBSchemaElementArray = wrapperFields;
        int n = wrapperFields.length;
        int n2 = 0;
        while (n2 < n) {
            IDBField wrapperField = iDBSchemaElementArray[n2];
            IDBField delegateField = delegateTable.getField(wrapperField.getName());
            ((DelegatingDBSchemaElement)((Object)wrapperField)).setDelegate(delegateField);
            ++n2;
        }
        iDBSchemaElementArray = wrapperIndices;
        n = wrapperIndices.length;
        n2 = 0;
        while (n2 < n) {
            IDBSchemaElement wrapperIndex = iDBSchemaElementArray[n2];
            IDBIndex delegateIndex = delegateTable.getIndex(wrapperIndex.getName());
            ((DelegatingDBSchemaElement)wrapperIndex).setDelegate(delegateIndex);
            ++n2;
        }
    }

    @Override
    public IDBTable getWrapper() {
        return this;
    }

    @Override
    public IDBSchema getParent() {
        return DelegatingDBTable.wrap(this.getDelegate().getParent());
    }

    @Override
    public IDBField addField(String name, DBType type) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type));
    }

    @Override
    public IDBField addField(String name, DBType type, boolean notNull) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, notNull));
    }

    @Override
    public void removeField(IDBField fieldToRemove) {
        this.getDelegate().removeField(DelegatingDBTable.unwrap(fieldToRemove));
    }

    @Override
    public IDBField addField(String name, DBType type, int precision) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, precision));
    }

    @Override
    public void removeIndex(IDBIndex indexToRemove) {
        this.getDelegate().removeIndex(DelegatingDBTable.unwrap(indexToRemove));
    }

    @Override
    public IDBField addField(String name, DBType type, int precision, boolean notNull) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, precision, notNull));
    }

    @Override
    public IDBField addField(String name, DBType type, int precision, int scale) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, precision, scale));
    }

    @Override
    public IDBField addField(String name, DBType type, int precision, int scale, boolean notNull) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, precision, scale, notNull));
    }

    @Override
    public IDBField getFieldSafe(String name) throws SchemaElementNotFoundException {
        return DelegatingDBTable.wrap(this.getDelegate().getFieldSafe(name));
    }

    @Override
    public IDBField getField(String name) {
        return DelegatingDBTable.wrap(this.getDelegate().getField(name));
    }

    @Override
    public IDBField getField(int position) {
        return DelegatingDBTable.wrap(this.getDelegate().getField(position));
    }

    @Override
    public int getFieldCount() {
        return this.getDelegate().getFieldCount();
    }

    @Override
    public IDBField[] getFields() {
        return (IDBField[])DelegatingDBTable.wrap((IDBSchemaElement[])this.getDelegate().getFields(), IDBField.class);
    }

    @Override
    public IDBField[] getFields(String ... fieldNames) throws SchemaElementNotFoundException {
        return (IDBField[])DelegatingDBTable.wrap((IDBSchemaElement[])this.getDelegate().getFields(fieldNames), IDBField.class);
    }

    @Override
    public boolean hasIndexFor(IDBField ... fields) {
        return this.getDelegate().hasIndexFor((IDBField[])DelegatingDBTable.unwrap((IDBSchemaElement[])fields, IDBField.class));
    }

    @Override
    public IDBIndex addIndex(String name, IDBIndex.Type type, IDBField ... fields) {
        return DelegatingDBTable.wrap(this.getDelegate().addIndex(name, type, (IDBField[])DelegatingDBTable.unwrap((IDBSchemaElement[])fields, IDBField.class)));
    }

    @Override
    public IDBIndex addIndex(String name, IDBIndex.Type type, String ... fieldNames) throws SchemaElementNotFoundException {
        return DelegatingDBTable.wrap(this.getDelegate().addIndex(name, type, fieldNames));
    }

    @Override
    public IDBIndex addIndexEmpty(String name, IDBIndex.Type type) {
        return DelegatingDBTable.wrap(this.getDelegate().addIndexEmpty(name, type));
    }

    @Override
    public IDBIndex addIndex(IDBIndex.Type type, IDBField ... fields) {
        return DelegatingDBTable.wrap(this.getDelegate().addIndex(type, (IDBField[])DelegatingDBTable.unwrap((IDBSchemaElement[])fields, IDBField.class)));
    }

    @Override
    public IDBIndex addIndex(IDBIndex.Type type, String ... fieldNames) throws SchemaElementNotFoundException {
        return DelegatingDBTable.wrap(this.getDelegate().addIndex(type, fieldNames));
    }

    @Override
    public IDBIndex addIndexEmpty(IDBIndex.Type type) {
        return DelegatingDBTable.wrap(this.getDelegate().addIndexEmpty(type));
    }

    @Override
    public IDBIndex getIndexSafe(String name) throws SchemaElementNotFoundException {
        return DelegatingDBTable.wrap(this.getDelegate().getIndexSafe(name));
    }

    @Override
    public IDBIndex getIndex(String name) {
        return DelegatingDBTable.wrap(this.getDelegate().getIndex(name));
    }

    @Override
    public IDBIndex getIndex(int position) {
        return DelegatingDBTable.wrap(this.getDelegate().getIndex(position));
    }

    @Override
    public int getIndexCount() {
        return this.getDelegate().getIndexCount();
    }

    @Override
    public IDBIndex[] getIndices() {
        return (IDBIndex[])DelegatingDBTable.wrap((IDBSchemaElement[])this.getDelegate().getIndices(), IDBIndex.class);
    }

    @Override
    public IDBIndex getPrimaryKeyIndex() {
        return DelegatingDBTable.wrap(this.getDelegate().getPrimaryKeyIndex());
    }

    @Override
    public String sqlInsert() {
        return this.getDelegate().sqlInsert();
    }
}

