/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.time.Instant;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.attributes.Filtering;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.WorkingTreeFileRevision;
import org.eclipse.egit.core.internal.storage.WorkspaceFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.util.RevCommitUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.synchronize.DefaultGitSynchronizer;
import org.eclipse.egit.ui.internal.synchronize.GitSynchronizer;
import org.eclipse.egit.ui.internal.synchronize.ModelAwareGitSynchronizer;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CompareUtils {
    private static final String REUSE_COMPARE_EDITOR_PREFID = "org.eclipse.team.ui.reuse_open_compare_editors";
    private static final String TEAM_UI_PLUGIN = "org.eclipse.team.ui";

    public static ITypedElement getFileRevisionTypedElement(String gitPath, RevCommit commit, Repository db) {
        return CompareUtils.getFileRevisionTypedElement(gitPath, commit, db, null);
    }

    public static ITypedElement getFileRevisionTypedElement(String gitPath, RevCommit commit, Repository db, ObjectId blobId) {
        Object right = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.GitHistoryPage_FileNotInCommit, (Object)CompareUtils.getName(gitPath), (Object)CompareUtils.truncatedRevision(commit.name())));
        try {
            IFileRevision nextFile = CompareUtils.getFileRevision(gitPath, commit, db, blobId);
            if (nextFile != null) {
                String encoding = CompareCoreUtils.getResourceEncoding((Repository)db, (String)gitPath);
                right = new FileRevisionTypedElement(nextFile, encoding);
            }
        }
        catch (IOException e) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)gitPath, (Object)commit.getId()), e);
        }
        return right;
    }

    private static String getName(String gitPath) {
        int last = gitPath.lastIndexOf(47);
        return last >= 0 ? gitPath.substring(last + 1) : gitPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IFileRevision getFileRevision(String gitPath, RevCommit commit, Repository db, ObjectId blobId) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TreeWalk w = TreeWalk.forPath((Repository)db, (String)gitPath, (RevTree)commit.getTree());){
            if (w == null) {
                return null;
            }
            DirCacheCheckout.CheckoutMetadata metadata = new DirCacheCheckout.CheckoutMetadata(w.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP), w.getFilterCommand("smudge"));
            if (blobId != null) return GitFileRevision.inCommit((Repository)db, (RevCommit)commit, (String)gitPath, (ObjectId)blobId, (DirCacheCheckout.CheckoutMetadata)metadata);
            blobId = w.getObjectId(0);
            return GitFileRevision.inCommit((Repository)db, (RevCommit)commit, (String)gitPath, (ObjectId)blobId, (DirCacheCheckout.CheckoutMetadata)metadata);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public static ITypedElement getFileRevisionTypedElementForCommonAncestor(String gitPath, ObjectId commit1, ObjectId commit2, Repository db) {
        ITypedElement ancestor = null;
        RevCommit commonAncestor = null;
        try {
            commonAncestor = RevCommitUtils.getCommonAncestor((Repository)db, (AnyObjectId)commit1, (AnyObjectId)commit2);
        }
        catch (IOException e) {
            Activator.logError(NLS.bind((String)UIText.CompareUtils_errorCommonAncestor, (Object)commit1.getName(), (Object)commit2.getName()), e);
        }
        if (commonAncestor != null) {
            if (commit1.equals((AnyObjectId)commonAncestor.getId()) || commit2.equals((AnyObjectId)commonAncestor.getId())) {
                return null;
            }
            ITypedElement ancestorCandidate = CompareUtils.getFileRevisionTypedElement(gitPath, commonAncestor, db);
            if (!(ancestorCandidate instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement)) {
                ancestor = ancestorCandidate;
            }
        }
        return ancestor;
    }

    public static String truncatedRevision(String ci) {
        if (ObjectId.isId((String)ci)) {
            return ci.substring(0, 7);
        }
        return ci;
    }

    public static void openInCompare(RevCommit commit1, RevCommit commit2, String commit1Path, String commit2Path, Repository repository, IWorkbenchPage workbenchPage) {
        ITypedElement base = CompareUtils.getFileRevisionTypedElement(commit1Path, commit1, repository);
        ITypedElement next = CompareUtils.getFileRevisionTypedElement(commit2Path, commit2, repository);
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
        CompareUtils.openInCompare(workbenchPage, (CompareEditorInput)in);
    }

    public static void openInCompare(IWorkbenchPage workbenchPage, CompareEditorInput input) {
        IEditorPart editor = CompareUtils.findReusableCompareEditor(input, workbenchPage);
        if (editor != null) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals(input)) {
                if (OpenStrategy.activateOnOpen()) {
                    workbenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workbenchPage.bringToTop((IWorkbenchPart)editor);
                }
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                if (OpenStrategy.activateOnOpen()) {
                    workbenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workbenchPage.bringToTop((IWorkbenchPart)editor);
                }
            }
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)input);
        }
    }

    private static IEditorPart findReusableCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorPart part;
        IEditorReference editorRef;
        IEditorReference[] editorRefs;
        IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            editorRef = iEditorReferenceArray[n2];
            part = editorRef.getEditor(false);
            if (part != null && (part.getEditorInput() instanceof GitCompareFileRevisionEditorInput || part.getEditorInput() instanceof GitCompareEditorInput) && part instanceof IReusableEditor && part.getEditorInput().equals(input)) {
                return part;
            }
            ++n2;
        }
        if (CompareUtils.isReuseOpenEditor()) {
            iEditorReferenceArray = editorRefs;
            n = editorRefs.length;
            n2 = 0;
            while (n2 < n) {
                editorRef = iEditorReferenceArray[n2];
                part = editorRef.getEditor(false);
                if (part != null && part.getEditorInput() instanceof SaveableCompareEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                    return part;
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean isReuseOpenEditor() {
        boolean defaultReuse = DefaultScope.INSTANCE.getNode(TEAM_UI_PLUGIN).getBoolean(REUSE_COMPARE_EDITOR_PREFID, false);
        return InstanceScope.INSTANCE.getNode(TEAM_UI_PLUGIN).getBoolean(REUSE_COMPARE_EDITOR_PREFID, defaultReuse);
    }

    private static void setReuseOpenEditor(boolean value) {
        InstanceScope.INSTANCE.getNode(TEAM_UI_PLUGIN).putBoolean(REUSE_COMPARE_EDITOR_PREFID, value);
    }

    public static void compareHeadWithWorkspace(Repository repository, @NonNull IFile file) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
        if (mapping == null) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)file.getLocation(), (Object)repository), null);
            return;
        }
        String path = mapping.getRepoRelativePath((IResource)file);
        ITypedElement base = CompareUtils.getHeadTypedElement(repository, path);
        if (base == null) {
            return;
        }
        WorkspaceFileRevision nextFile = new WorkspaceFileRevision(repository, path, (IResource)file);
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException e) {
            Activator.handleError(UIText.CompareUtils_errorGettingEncoding, e, true);
        }
        FileRevisionTypedElement next = new FileRevisionTypedElement((IFileRevision)nextFile, encoding);
        GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput(next, base, null);
        CompareUI.openCompareDialog((CompareEditorInput)input);
    }

    public static void compareWorkspaceWithRef(final @NonNull Repository repository, final IResource file, final String refName, final IWorkbenchPage page) {
        if (file == null) {
            return;
        }
        final IPath location = file.getLocation();
        if (location == null) {
            return;
        }
        Job job = new Job(UIText.CompareUtils_jobName){

            public IStatus run(IProgressMonitor monitor) {
                CompareEditorInput in;
                LocalNonWorkspaceTypedElement base;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
                if (mapping == null) {
                    return Activator.createErrorStatus(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)location, (Object)repository));
                }
                if (Files.isSymbolicLink(location.toFile().toPath())) {
                    base = new LocalNonWorkspaceTypedElement(repository, location);
                } else if (file instanceof IFile) {
                    base = SaveableCompareEditorInput.createFileElement((IFile)((IFile)file));
                } else {
                    return Activator.createErrorStatus(NLS.bind((String)UIText.CompareUtils_wrongResourceArgument, (Object)location, (Object)file));
                }
                String gitPath = mapping.getRepoRelativePath(file);
                try {
                    in = CompareUtils.prepareCompareInput(repository, gitPath, (ITypedElement)base, refName);
                }
                catch (IOException e) {
                    return Activator.createErrorStatus(UIText.CompareWithRefAction_errorOnSynchronize, e);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                CompareUtils.openCompareEditorRunnable(page, in);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static void openCompareEditorRunnable(final IWorkbenchPage page, final CompareEditorInput in) {
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CompareUtils.openCompareEditorRunnable(page, in);
                }
            });
            return;
        }
        if (page != null) {
            CompareUtils.openInCompare(page, in);
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)in);
        }
    }

    private static void compareLocalWithRef(final @NonNull Repository repository, final @NonNull IPath location, final String refName, final IWorkbenchPage page) {
        Job job = new Job(UIText.CompareUtils_jobName){

            public IStatus run(IProgressMonitor monitor) {
                CompareEditorInput in;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                String gitPath = CompareUtils.getRepoRelativePath(location, repository);
                LocalNonWorkspaceTypedElement base = new LocalNonWorkspaceTypedElement(repository, location);
                try {
                    in = CompareUtils.prepareCompareInput(repository, gitPath, (ITypedElement)base, refName);
                }
                catch (IOException e) {
                    return Activator.createErrorStatus(UIText.CompareWithRefAction_errorOnSynchronize, e);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                CompareUtils.openCompareEditorRunnable(page, in);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static CompareEditorInput prepareCompareInput(Repository repository, String gitPath, ITypedElement base, String refName) throws IOException {
        ITypedElement destCommit;
        ITypedElement commonAncestor = null;
        if ("Index".equals(refName)) {
            destCommit = CompareUtils.getIndexTypedElement(repository, gitPath);
        } else if ("HEAD".equals(refName)) {
            destCommit = CompareUtils.getHeadTypedElement(repository, gitPath);
        } else {
            ObjectId destCommitId = repository.resolve(refName);
            Throwable throwable = null;
            Object var8_9 = null;
            try (RevWalk rw = new RevWalk(repository);){
                RevCommit commit = rw.parseCommit((AnyObjectId)destCommitId);
                destCommit = CompareUtils.getFileRevisionTypedElement(gitPath, commit, repository);
                if (base != null) {
                    ObjectId headCommitId = repository.resolve("HEAD");
                    commonAncestor = CompareUtils.getFileRevisionTypedElementForCommonAncestor(gitPath, headCommitId, destCommitId, repository);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, destCommit, commonAncestor, null);
        in.getCompareConfiguration().setRightLabel(refName);
        return in;
    }

    public static void compare(@NonNull IResource[] resources, @NonNull Repository repository, String leftRev, String rightRev, boolean includeLocal, IWorkbenchPage page) throws IOException {
        CompareUtils.getSynchronizer().compare(resources, repository, leftRev, rightRev, includeLocal, page);
    }

    public static void compare(@NonNull IFile file, @NonNull Repository repository, String leftPath, String rightPath, String leftRev, String rightRev, boolean includeLocal, IWorkbenchPage page) throws IOException {
        CompareUtils.getSynchronizer().compare(file, repository, leftPath, rightPath, leftRev, rightRev, includeLocal, page);
    }

    private static GitSynchronizer getSynchronizer() {
        if (Activator.getDefault().getPreferenceStore().getBoolean("enable_logical_model")) {
            return new ModelAwareGitSynchronizer();
        }
        return new DefaultGitSynchronizer();
    }

    public static void compare(@NonNull IPath location, @NonNull Repository repository, String leftRev, String rightRev, boolean includeLocal, IWorkbenchPage page) {
        if (includeLocal) {
            CompareUtils.compareLocalWithRef(repository, location, rightRev, page);
        } else {
            String gitPath = CompareUtils.getRepoRelativePath(location, repository);
            CompareUtils.compareBetween(repository, gitPath, leftRev, rightRev, page);
        }
    }

    public static void compareBetween(Repository repository, String gitPath, String leftRev, String rightRev, IWorkbenchPage page) {
        CompareUtils.compareBetween(repository, gitPath, gitPath, leftRev, rightRev, page);
    }

    public static void compareBetween(final Repository repository, final String leftGitPath, final String rightGitPath, final String leftRev, final String rightRev, final IWorkbenchPage page) {
        Job job = new Job(UIText.CompareUtils_jobName){

            public IStatus run(IProgressMonitor monitor) {
                ITypedElement right;
                ITypedElement left;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    left = CompareUtils.getTypedElementFor(repository, leftGitPath, leftRev);
                    right = CompareUtils.getTypedElementFor(repository, rightGitPath, rightRev);
                }
                catch (IOException e) {
                    return Activator.createErrorStatus(UIText.CompareWithRefAction_errorOnSynchronize, e);
                }
                ITypedElement commonAncestor = left != null && right != null && !"Index".equals(leftRev) && !"Index".equals(rightRev) ? CompareUtils.getTypedElementForCommonAncestor(repository, rightGitPath, leftRev, rightRev) : null;
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(left, right, commonAncestor, null);
                in.getCompareConfiguration().setLeftLabel(leftRev);
                in.getCompareConfiguration().setRightLabel(rightRev);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                CompareUtils.openCompareEditorRunnable(page, (CompareEditorInput)in);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static String getRepoRelativePath(@NonNull IPath location, @NonNull Repository repository) {
        Path repoRoot = new Path(repository.getWorkTree().getPath());
        String gitPath = location.makeRelativeTo((IPath)repoRoot).toString();
        return gitPath;
    }

    private static ITypedElement getTypedElementFor(Repository repository, String gitPath, String rev) throws IOException {
        ITypedElement typedElement;
        if ("Index".equals(rev)) {
            typedElement = CompareUtils.getIndexTypedElement(repository, gitPath);
        } else if ("HEAD".equals(rev)) {
            typedElement = CompareUtils.getHeadTypedElement(repository, gitPath);
        } else {
            ObjectId id = repository.resolve(rev);
            Throwable throwable = null;
            Object var6_7 = null;
            try (RevWalk rw = new RevWalk(repository);){
                RevCommit revCommit = rw.parseCommit((AnyObjectId)id);
                typedElement = CompareUtils.getFileRevisionTypedElement(gitPath, revCommit, repository);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return typedElement;
    }

    private static ITypedElement getTypedElementForCommonAncestor(Repository repository, String gitPath, String srcRev, String dstRev) {
        ITypedElement ancestor = null;
        try {
            ObjectId srcID = repository.resolve(srcRev);
            ObjectId dstID = repository.resolve(dstRev);
            if (srcID != null && dstID != null) {
                ancestor = CompareUtils.getFileRevisionTypedElementForCommonAncestor(gitPath, srcID, dstID, repository);
            }
        }
        catch (IOException e) {
            Activator.logError(NLS.bind((String)UIText.CompareUtils_errorCommonAncestor, (Object)srcRev, (Object)dstRev), e);
        }
        return ancestor;
    }

    public static void compareHeadWithWorkingTree(Repository repository, String path) {
        ITypedElement base = CompareUtils.getHeadTypedElement(repository, path);
        if (base == null) {
            return;
        }
        WorkingTreeFileRevision nextFile = new WorkingTreeFileRevision(repository, path);
        String encoding = ResourcesPlugin.getEncoding();
        FileRevisionTypedElement next = new FileRevisionTypedElement((IFileRevision)nextFile, encoding);
        GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput(next, base, null);
        CompareUI.openCompareDialog((CompareEditorInput)input);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ITypedElement getHeadTypedElement(Repository repository, String repoRelativePath) {
        try {
            Ref head = repository.exactRef("HEAD");
            if (head == null) return new GitCompareFileRevisionEditorInput.EmptyTypedElement("");
            if (head.getObjectId() == null) {
                return new GitCompareFileRevisionEditorInput.EmptyTypedElement("");
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (RevWalk rw = new RevWalk(repository);){
                RevCommit headCommit = rw.parseCommit((AnyObjectId)head.getObjectId());
                Throwable throwable2 = null;
                Object var9_12 = null;
                try {
                    TreeWalk tw;
                    block18: {
                        GitCompareFileRevisionEditorInput.EmptyTypedElement emptyTypedElement;
                        tw = TreeWalk.forPath((Repository)repository, (String)repoRelativePath, (RevTree)headCommit.getTree());
                        try {
                            if (tw != null) break block18;
                            emptyTypedElement = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.GitHistoryPage_FileNotInCommit, (Object)CompareUtils.getName(repoRelativePath), (Object)"HEAD"));
                            if (tw == null) return emptyTypedElement;
                        }
                        catch (Throwable throwable3) {
                            if (tw == null) throw throwable3;
                            tw.close();
                            throw throwable3;
                        }
                        tw.close();
                        return emptyTypedElement;
                    }
                    if (tw != null) {
                        tw.close();
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
                rw.markStart(headCommit);
                rw.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings((String[])new String[]{repoRelativePath}), (TreeFilter)TreeFilter.ANY_DIFF));
                rw.setRewriteParents(false);
                RevCommit latestFileCommit = rw.next();
                if (latestFileCommit != null) return CompareUtils.getFileRevisionTypedElement(repoRelativePath, latestFileCommit, repository);
                latestFileCommit = headCommit;
                return CompareUtils.getFileRevisionTypedElement(repoRelativePath, latestFileCommit, repository);
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareUtils_errorGettingHeadCommit, e, true);
            return null;
        }
    }

    public static ITypedElement getIndexTypedElement(@NonNull IFile baseFile) throws IOException {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)baseFile);
        if (mapping == null) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)baseFile.getLocation(), null), null);
            return null;
        }
        Repository repository = mapping.getRepository();
        String gitPath = mapping.getRepoRelativePath((IResource)baseFile);
        String encoding = CompareCoreUtils.getResourceEncoding((IResource)baseFile);
        return CompareUtils.getIndexTypedElement(repository, gitPath, encoding);
    }

    public static ITypedElement getIndexTypedElement(Repository repository, String repoRelativePath) throws IOException {
        String encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)repoRelativePath);
        return CompareUtils.getIndexTypedElement(repository, repoRelativePath, encoding);
    }

    private static ITypedElement getIndexTypedElement(final Repository repository, final String gitPath, String encoding) {
        GitFileRevision nextFile = GitFileRevision.inIndex((Repository)repository, (String)gitPath);
        final EditableRevision next = new EditableRevision((IFileRevision)nextFile, encoding);
        IContentChangeListener listener = new IContentChangeListener(){

            public void contentChanged(IContentChangeNotifier source) {
                byte[] newContent = next.getModifiedContent();
                CompareUtils.setIndexEntryContents(repository, gitPath, newContent);
            }
        };
        next.addContentChangeListener(listener);
        return next;
    }

    private static void setIndexEntryContents(Repository repository, String gitPath, byte[] newContent) {
        DirCache cache = null;
        try {
            try {
                cache = repository.lockDirCache();
                DirCacheEditor editor = cache.editor();
                if (newContent.length == 0) {
                    editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(gitPath));
                } else {
                    CoreConfig.EolStreamType streamType = null;
                    String command = null;
                    Throwable throwable = null;
                    Object var8_11 = null;
                    try (TreeWalk walk = new TreeWalk(repository);){
                        walk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
                        walk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
                        FileTreeIterator files = new FileTreeIterator(repository);
                        files.setDirCacheIterator(walk, 0);
                        walk.addTree((AbstractTreeIterator)files);
                        walk.setFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings((String[])new String[]{gitPath}), (TreeFilter)new NotIgnoredFilter(1)));
                        walk.setRecursive(true);
                        if (walk.next()) {
                            streamType = walk.getEolStreamType(TreeWalk.OperationType.CHECKIN_OP);
                            command = walk.getFilterCommand("clean");
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    InputStream filtered = Filtering.filter((Repository)repository, (String)gitPath, (InputStream)new ByteArrayInputStream(newContent), (String)command);
                    if (streamType == null) {
                        WorkingTreeOptions workingTreeOptions = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
                        streamType = workingTreeOptions.getAutoCRLF() == CoreConfig.AutoCRLF.FALSE ? CoreConfig.EolStreamType.DIRECT : CoreConfig.EolStreamType.AUTO_LF;
                    }
                    ByteBuffer content = IO.readWholeStream((InputStream)EolStreamTypeUtil.wrapInputStream((InputStream)filtered, (CoreConfig.EolStreamType)streamType), (int)newContent.length);
                    editor.add((DirCacheEditor.PathEdit)new DirCacheEntryEditor(gitPath, repository, content));
                }
                try {
                    editor.commit();
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                Activator.handleError(UIText.CompareWithIndexAction_errorOnAddToIndex, e, true);
                if (cache != null) {
                    cache.unlock();
                }
            }
        }
        finally {
            if (cache != null) {
                cache.unlock();
            }
        }
    }

    private static class DirCacheEntryEditor
    extends DirCacheEditor.PathEdit {
        private final Repository repo;
        private final ByteBuffer content;

        public DirCacheEntryEditor(String path, Repository repo, ByteBuffer content) {
            super(path);
            this.repo = repo;
            this.content = content;
        }

        public void apply(DirCacheEntry ent) {
            ObjectInserter inserter = this.repo.newObjectInserter();
            if ((ent.getRawMode() & 0xF000) != 32768) {
                ent.setFileMode(FileMode.REGULAR_FILE);
            }
            ent.setLength(this.content.limit());
            ent.setLastModified(Instant.now());
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(this.content.array(), 0, this.content.limit());
                ent.setObjectId((AnyObjectId)inserter.insert(3, (long)this.content.limit(), (InputStream)in));
                inserter.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class ReuseCompareEditorAction
    extends Action
    implements IEclipsePreferences.IPreferenceChangeListener,
    ActionFactory.IWorkbenchAction {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.team.ui");

        public ReuseCompareEditorAction() {
            this.node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.setText(UIText.GitHistoryPage_ReuseCompareEditorMenuLabel);
            this.setChecked(CompareUtils.isReuseOpenEditor());
        }

        public void run() {
            CompareUtils.setReuseOpenEditor(this.isChecked());
        }

        public void dispose() {
            this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.setChecked(CompareUtils.isReuseOpenEditor());
        }
    }
}

