/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.IProblemDecoratable;

class CommitItem
implements IProblemDecoratable {
    Status status;
    String path;
    boolean submodule;
    int problemSeverity;

    CommitItem() {
    }

    @Override
    public int getProblemSeverity() {
        return this.problemSeverity;
    }

    public static enum Order implements Comparator<CommitItem>
    {
        ByStatus{

            @Override
            public int compare(CommitItem o1, CommitItem o2) {
                return o1.status.compareTo(o2.status);
            }
        }
        ,
        ByFile{

            @Override
            public int compare(CommitItem o1, CommitItem o2) {
                return o1.path.compareToIgnoreCase(o2.path);
            }
        };


        public Comparator<CommitItem> ascending() {
            return this;
        }

        public Comparator<CommitItem> descending() {
            return Collections.reverseOrder(this);
        }
    }

    public static enum Status {
        ADDED(UIText.CommitDialog_StatusAdded),
        MODIFIED(UIText.CommitDialog_StatusModified),
        REMOVED(UIText.CommitDialog_StatusRemoved),
        ADDED_INDEX_DIFF(UIText.CommitDialog_StatusAddedIndexDiff),
        MODIFIED_INDEX_DIFF(UIText.CommitDialog_StatusModifiedIndexDiff),
        MODIFIED_NOT_STAGED(UIText.CommitDialog_StatusModifiedNotStaged),
        REMOVED_NOT_STAGED(UIText.CommitDialog_StatusRemovedNotStaged),
        UNTRACKED(UIText.CommitDialog_StatusUntracked),
        REMOVED_UNTRACKED(UIText.CommitDialog_StatusRemovedUntracked),
        ASSUME_UNCHANGED(UIText.CommitDialog_StatusAssumeUnchaged),
        UNKNOWN(UIText.CommitDialog_StatusUnknown);

        private final String myText;

        public String getText() {
            return this.myText;
        }

        private Status(String text) {
            this.myText = text;
        }
    }
}

