/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.info.GitItemState;
import org.eclipse.egit.core.internal.info.GitItemStateFactory;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IEvaluationService;

public abstract class CompareWithCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<IPath> paths = new ArrayList<IPath>();
        Repository repository = null;
        boolean allPaths = false;
        for (RepositoryTreeNode node : nodes) {
            Repository nodeRepository = node.getRepository();
            if (repository == null) {
                repository = nodeRepository;
            } else if (repository != nodeRepository) {
                return null;
            }
            switch (node.getType()) {
                case WORKINGDIR: {
                    allPaths = true;
                    paths.clear();
                    break;
                }
                case FOLDER: 
                case FILE: {
                    if (allPaths) break;
                    paths.add(node.getPath());
                    break;
                }
            }
        }
        if (repository != null && (allPaths || !paths.isEmpty())) {
            String ref = this.getRef(event, repository, paths);
            if (ref == null) {
                return null;
            }
            IWorkbenchPage workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
            GitCompareEditorInput compareInput = allPaths ? new GitCompareEditorInput(null, ref, repository, new IPath[0]) : new GitCompareEditorInput(null, ref, repository, paths.toArray(new IPath[0]));
            CompareUtils.openInCompare(workbenchPage, compareInput);
        }
        return null;
    }

    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        IStructuredSelection selection = SelectionUtils.getSelection(((IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class)).getCurrentState());
        Repository repository = SelectionUtils.getRepository(selection);
        if (repository == null || repository.isBare()) {
            return false;
        }
        return this.isEnabled(selection, repository);
    }

    protected abstract String getRef(ExecutionEvent var1, @NonNull Repository var2, Collection<IPath> var3);

    protected boolean isEnabled(IStructuredSelection selection, @NonNull Repository repository) {
        if (SelectionRepositoryStateCache.INSTANCE.getHead(repository) == null) {
            return false;
        }
        block4: for (Object o : selection.toList()) {
            if (!(o instanceof RepositoryTreeNode)) continue;
            RepositoryTreeNode node = (RepositoryTreeNode)o;
            switch (node.getType()) {
                case WORKINGDIR: {
                    return true;
                }
                case FOLDER: 
                case FILE: {
                    IPath path = node.getPath();
                    GitItemState state = GitItemStateFactory.getInstance().get(path.toFile());
                    if (state.isIgnored()) continue block4;
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }
}

