/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.AnimationTimeline;
import org.eclipse.xwt.animation.IEasingFunction;
import org.eclipse.xwt.animation.internal.ITimeline;
import org.eclipse.xwt.animation.internal.TridentTimeline;
import org.eclipse.xwt.animation.interpolator.RectanglePropertyInterpolator;
import org.pushingpixels.trident.TridentConfig;
import org.pushingpixels.trident.interpolator.PropertyInterpolator;

public class RectangleAnimation
extends AnimationTimeline {
    private Rectangle from;
    private Rectangle to;
    private Rectangle by;
    private IEasingFunction easingFunction;

    static {
        TridentConfig.getInstance().addPropertyInterpolator((PropertyInterpolator)new RectanglePropertyInterpolator());
    }

    public Rectangle getFrom() {
        return this.from;
    }

    public void setFrom(Rectangle from) {
        this.from = from;
    }

    public Rectangle getTo() {
        return this.to;
    }

    public void setTo(Rectangle to) {
        this.to = to;
    }

    public IEasingFunction getEasingFunction() {
        return this.easingFunction;
    }

    public void setEasingFunction(IEasingFunction easingFunction) {
        this.easingFunction = easingFunction;
    }

    @Override
    protected void updateTimeline(ITimeline timeline, Object target) {
        super.updateTimeline(timeline, target);
        if (timeline instanceof TridentTimeline) {
            TridentTimeline tridentTimeline = (TridentTimeline)timeline;
            Rectangle from = this.getFrom();
            Rectangle to = this.getTo();
            if (from == null && to == null) {
                from = (Rectangle)this.getCacheValue();
                to = (Rectangle)this.getCurrentValue(target);
                if (from == null || from.width == 0 && from.height == 0) {
                    this.setCacheValue(to);
                    throw new XWTException("action ignored");
                }
                if (from != null && from.equals((Object)to)) {
                    throw new XWTException("action ignored");
                }
            }
            tridentTimeline.addPropertyToInterpolate(this.getTargetProperty(), from, to);
            tridentTimeline.setEasingFunction(this.getEasingFunction());
        }
    }
}

