/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.OutParameter;

class StringParser {
    public static final long TicksPerDay = Long.valueOf("c92a69c000", 16);
    public static final long TicksPerHour = Long.valueOf("861c46800", 16);
    public static final long TicksPerMinute = 600000000L;
    public static final long TicksPerSecond = 10000000L;
    String str;
    char ch;
    int pos;
    int len;
    private ParseError error;

    StringParser() {
    }

    private void nextChar() {
        if (this.pos < this.len) {
            ++this.pos;
        }
        this.ch = this.pos < this.len ? this.str.charAt(this.pos) : (char)'\u0000';
    }

    private char nextNonDigit() {
        int i = this.pos;
        while (i < this.len) {
            char ch = this.str.charAt(i);
            if (ch < '0' || ch > '9') {
                return ch;
            }
            ++i;
        }
        return '\u0000';
    }

    public long parse(String s) {
        long num = 0L;
        OutParameter out = new OutParameter(num);
        if (this.tryParse(s, out)) {
            return out.value;
        }
        switch (this.error) {
            case Format: {
                throw new XWTException("Format_InvalidString");
            }
            case Overflow: {
                throw new XWTException("Overflow_TimeSpanTooLong");
            }
            case OverflowHoursMinutesSeconds: {
                throw new XWTException("Overflow_TimeSpanElementTooLarge");
            }
            case ArgumentNull: {
                throw new XWTException("s");
            }
        }
        return 0L;
    }

    public boolean tryParse(String s, OutParameter out) {
        long time = 0L;
        out.value = 0L;
        OutParameter timeOut = new OutParameter(time);
        if (s == null) {
            this.error = ParseError.ArgumentNull;
            return false;
        }
        this.str = s;
        this.len = s.length();
        this.pos = -1;
        this.nextChar();
        this.skipBlanks();
        boolean flag = false;
        if (this.ch == '-') {
            flag = true;
            this.nextChar();
        }
        if (this.nextNonDigit() == ':') {
            if (!this.parseTime(timeOut)) {
                return false;
            }
        } else {
            int i = 0;
            OutParameter iOut = new OutParameter(i);
            if (!this.parseInt(10675199, iOut)) {
                return false;
            }
            timeOut.value = iOut.value * 864000000000L;
            if (this.ch == '.') {
                long num3 = 0L;
                OutParameter num3Out = new OutParameter(num3);
                this.nextChar();
                if (!this.parseTime(num3Out)) {
                    return false;
                }
                timeOut.value += num3Out.value;
            }
        }
        if (flag) {
            timeOut.value = -timeOut.value;
            if (timeOut.value > 0L) {
                this.error = ParseError.Overflow;
                return false;
            }
        } else if (timeOut.value < 0L) {
            this.error = ParseError.Overflow;
            return false;
        }
        this.skipBlanks();
        if (this.pos < this.len) {
            this.error = ParseError.Format;
            return false;
        }
        out.value = timeOut.value;
        return true;
    }

    private boolean parseInt(int max, OutParameter out) {
        out.value = 0L;
        int pos = this.pos;
        while (this.ch >= '0' && this.ch <= '9') {
            if ((out.value & 0xF0000000L) != 0L) {
                this.error = ParseError.Overflow;
                return false;
            }
            out.value = out.value * 10L + (long)this.ch - 48L;
            if (out.value < 0L) {
                this.error = ParseError.Overflow;
                return false;
            }
            this.nextChar();
        }
        if (pos == this.pos) {
            this.error = ParseError.Format;
            return false;
        }
        if (out.value > (long)max) {
            this.error = ParseError.Overflow;
            return false;
        }
        return true;
    }

    private boolean parseTime(OutParameter out) {
        int i = 0;
        out.value = 0L;
        OutParameter iOut = new OutParameter(i);
        if (!this.parseInt(23, iOut)) {
            if (this.error == ParseError.Overflow) {
                this.error = ParseError.OverflowHoursMinutesSeconds;
            }
            return false;
        }
        out.value = iOut.value * 36000000000L;
        if (this.ch != ':') {
            this.error = ParseError.Format;
            return false;
        }
        this.nextChar();
        if (!this.parseInt(59, iOut)) {
            if (this.error == ParseError.Overflow) {
                this.error = ParseError.OverflowHoursMinutesSeconds;
            }
            return false;
        }
        out.value += iOut.value * 600000000L;
        if (this.ch == ':') {
            this.nextChar();
            if (this.ch != '.') {
                if (!this.parseInt(59, iOut)) {
                    if (this.error == ParseError.Overflow) {
                        this.error = ParseError.OverflowHoursMinutesSeconds;
                    }
                    return false;
                }
                out.value += iOut.value * 10000000L;
            }
            if (this.ch == '.') {
                this.nextChar();
                int num2 = 10000000;
                while (num2 > 1 && this.ch >= '0' && this.ch <= '9') {
                    out.value += (long)((this.ch - 48) * (num2 /= 10));
                    this.nextChar();
                }
            }
        }
        return true;
    }

    private void skipBlanks() {
        while (this.ch == ' ' || this.ch == '\t') {
            this.nextChar();
        }
    }

    private static enum ParseError {
        Format,
        Overflow,
        OverflowHoursMinutesSeconds,
        ArgumentNull;

    }
}

