/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.resourceloader;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.archive.ArchiveURLConnection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.resourceloader.AbstractResourceLoader;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

public class ParallelResourceLoader
extends AbstractResourceLoader {
    private static final long MAX_WAIT_TIME = TimeUnit.SECONDS.toMillis(60L);
    private final int nThreads;
    private final int queueSize;
    private long timeout;

    public ParallelResourceLoader(IResourceSetProvider resourceSetProvider, IResourceLoader.Sorter sorter, int nThreads, int queueSize) {
        super(resourceSetProvider, sorter);
        this.nThreads = nThreads;
        this.queueSize = queueSize;
        this.timeout = MAX_WAIT_TIME;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long time, TimeUnit unit) {
        this.timeout = unit.toMillis(time);
    }

    @Override
    public IResourceLoader.LoadOperation create(ResourceSet parent, IProject project) {
        return new AbstractResourceLoader.CheckedLoadOperation(new ParallelLoadOperation(parent, project));
    }

    @Override
    protected Resource loadResource(URI uri, ResourceSet localResourceSet, ResourceSet parentResourceSet) {
        IWorkspaceRoot root;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null && (root = workspace.getRoot()) != null) {
            String authority;
            if (uri.isPlatformResource()) {
                IFile file = root.getFile((IPath)new Path(uri.toPlatformString(true)));
                if (!file.isSynchronized(0)) {
                    return null;
                }
            } else if (uri.isArchive() && (authority = uri.authority()) != null && authority.startsWith("platform:/resource/")) {
                IFile file;
                class MyArchiveURLConnection
                extends ArchiveURLConnection {
                    public MyArchiveURLConnection(String url) {
                        super(url);
                    }

                    public String getNestedURI() {
                        try {
                            return this.getNestedURL();
                        }
                        catch (IOException exception) {
                            return "";
                        }
                    }
                }
                MyArchiveURLConnection archiveURLConnection = new MyArchiveURLConnection(uri.toString());
                String nestedURIString = archiveURLConnection.getNestedURI();
                if (Strings.isNullOrEmpty((String)nestedURIString)) {
                    return null;
                }
                URI nestedURI = URI.createURI((String)nestedURIString);
                if (nestedURI.isPlatformResource() && !(file = root.getFile((IPath)new Path(nestedURI.toPlatformString(true)))).isSynchronized(0)) {
                    return null;
                }
            }
        }
        return super.loadResource(uri, localResourceSet, parentResourceSet);
    }

    @Beta
    public class ParallelLoadOperation
    implements IResourceLoader.LoadOperation {
        private final BlockingQueue<Triple<URI, Resource, Throwable>> resourceQueue;
        private final ThreadLocal<ResourceSet> resourceSetProvider;
        private final ExecutorService executor;
        private final ResourceSet parent;
        private final long waitTime;
        private int toProcess;

        public ParallelLoadOperation(final ResourceSet parent, final IProject project) {
            this.parent = parent;
            this.resourceQueue = ParallelResourceLoader.this.queueSize == 0 ? new SynchronousQueue<Triple<URI, Resource, Throwable>>(true) : new ArrayBlockingQueue<Triple<URI, Resource, Throwable>>(ParallelResourceLoader.this.queueSize);
            this.resourceSetProvider = new ThreadLocal<ResourceSet>(){

                @Override
                protected ResourceSet initialValue() {
                    ResourceSet resourceSet = ParallelResourceLoader.this.getResourceSetProvider().get(project);
                    resourceSet.getLoadOptions().putAll(parent.getLoadOptions());
                    resourceSet.setURIConverter(parent.getURIConverter());
                    return resourceSet;
                }
            };
            this.executor = Executors.newFixedThreadPool(ParallelResourceLoader.this.nThreads, new ThreadFactoryBuilder().setNameFormat("ParallelLoad-%d").build());
            this.waitTime = ParallelResourceLoader.this.getTimeout();
        }

        protected int getToProcess() {
            return this.toProcess;
        }

        protected void setToProcess(int toProcess) {
            this.toProcess = toProcess;
        }

        protected BlockingQueue<Triple<URI, Resource, Throwable>> getResourceQueue() {
            return this.resourceQueue;
        }

        protected ExecutorService getExecutor() {
            return this.executor;
        }

        @Override
        public IResourceLoader.LoadResult next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("The resource queue is empty or the execution was cancelled.");
            }
            Triple<URI, Resource, Throwable> result = null;
            try {
                result = this.resourceQueue.poll(this.waitTime, TimeUnit.MILLISECONDS);
                --this.toProcess;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (result == null) {
                throw new NullPointerException("Resource load job didn't return a result");
            }
            URI uri = (URI)result.getFirst();
            Resource resource = (Resource)result.getSecond();
            Throwable throwable = (Throwable)result.getThird();
            if (throwable != null) {
                if (throwable instanceof WrappedException) {
                    throw new IResourceLoader.LoadOperationException(uri, (Exception)throwable.getCause());
                }
                if (throwable instanceof Exception) {
                    throw new IResourceLoader.LoadOperationException(uri, (Exception)throwable);
                }
                throw (Error)throwable;
            }
            if (resource == null && uri != null) {
                resource = this.parent.getResource(uri, true);
            }
            return new IResourceLoader.LoadResult(resource, uri);
        }

        @Override
        public boolean hasNext() {
            return this.toProcess > 0;
        }

        @Override
        public void load(Collection<URI> uris) {
            this.synchronizeResources(uris);
            this.toProcess += uris.size();
            Collection<URI> workload = ParallelResourceLoader.this.getSorter().sort(uris);
            for (URI uri : workload) {
                this.executor.execute(new ResourceLoadJob(uri));
            }
            this.executor.shutdown();
        }

        private void synchronizeResources(Collection<URI> toLoad) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            for (URI uri : toLoad) {
                if (!uri.isPlatformResource()) continue;
                Path path = new Path(uri.toPlatformString(true));
                IFile file = root.getFile((IPath)path);
                try {
                    file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public Collection<URI> cancel() {
            this.toProcess = 0;
            List<Runnable> jobs = this.executor.shutdownNow();
            ArrayList ret = Lists.newArrayList();
            for (Runnable job : jobs) {
                if (!(job instanceof ResourceLoadJob)) continue;
                ret.add(((ResourceLoadJob)job).uri);
            }
            return ret;
        }

        private class ResourceLoadJob
        implements Runnable {
            private final URI uri;

            public ResourceLoadJob(URI uri) {
                this.uri = uri;
            }

            @Override
            public void run() {
                Throwable exception = null;
                Resource resource = null;
                try {
                    ResourceSet localResourceSet = (ResourceSet)ParallelLoadOperation.this.resourceSetProvider.get();
                    resource = ParallelResourceLoader.this.loadResource(this.uri, localResourceSet, ParallelLoadOperation.this.parent);
                    localResourceSet.getResources().clear();
                }
                catch (Throwable t) {
                    exception = t;
                }
                try {
                    ParallelLoadOperation.this.resourceQueue.put(Tuples.create((Object)this.uri, resource, (Object)exception));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

