/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.common.core.command.IModificationValidator;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.gmf.runtime.common.ui.resources.FileModificationValidator;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UIModificationValidator
implements IModificationValidator {
    private WindowListener listener;
    private static final Status ERROR_STATUS = new Status(4, "org.eclipse.core.runtime", 1, "", null);

    public UIModificationValidator() {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (PlatformUI.isWorkbenchRunning()) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        Shell shell = window == null ? null : window.getShell();
                        UIModificationValidator.this.listener = new WindowListener(shell);
                        PlatformUI.getWorkbench().addWindowListener((IWindowListener)UIModificationValidator.this.listener);
                    }
                }
            });
        }
    }

    protected IStatus doValidateEdit(IFile[] files, Shell shell) {
        boolean ok = FileModificationValidator.getInstance().okToEdit(files, CommonUIMessages.UIModificationValidator_ModificationMessage, shell);
        return ok ? Status.OK_STATUS : ERROR_STATUS;
    }

    public IStatus validateEdit(IFile[] files) {
        Shell shell = this.listener == null ? null : this.listener.getShell();
        RunnableWithStatus r = new RunnableWithStatus(files, shell);
        Display display = DisplayUtils.getDisplay();
        FileModificationValidator.ISyncExecHelper syncExecHelper = FileModificationValidator.SyncExecHelper.getInstance();
        if (ModalContext.isModalContextThread((Thread)Thread.currentThread())) {
            Runnable safeRunnable = syncExecHelper.safeRunnable((Runnable)r);
            if (safeRunnable != null) {
                display.syncExec(safeRunnable);
            } else {
                r.run();
            }
        } else {
            if (display == null) {
                r.setShell(null);
            }
            r.run();
        }
        return r.getResult();
    }

    public void dispose() {
        if (this.listener != null && !this.listener.getShell().isDisposed()) {
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().removeWindowListener((IWindowListener)UIModificationValidator.this.listener);
                }
            });
        }
    }

    class RunnableWithStatus
    implements Runnable {
        private final IFile[] files;
        private IStatus status;
        private Shell shell;

        RunnableWithStatus(IFile[] files, Shell shell) {
            this.files = files;
            this.shell = shell;
        }

        @Override
        public void run() {
            this.status = UIModificationValidator.this.doValidateEdit(this.files, this.shell);
        }

        public IStatus getResult() {
            return this.status;
        }

        public void setShell(Shell shell) {
            this.shell = shell;
        }
    }

    private class WindowListener
    implements IWindowListener {
        protected Shell shell;

        public void windowActivated(IWorkbenchWindow window) {
            this.shell = window.getShell();
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public WindowListener(Shell theShell) {
            this.shell = theShell;
        }

        public Shell getShell() {
            return this.shell;
        }
    }
}

