/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.swt.widgets.Shell;

public class CompositeHyperlinkHelper
extends AbstractHyperLinkHelper {
    private final AbstractHyperLinkHelper[] helpers;
    private final Map<HyperLinkObject, AbstractHyperLinkHelper> hyperlinks = new HashMap<HyperLinkObject, AbstractHyperLinkHelper>();
    private AbstractHyperLinkHelper activeHelper;

    public CompositeHyperlinkHelper(Collection<? extends AbstractHyperLinkHelper> helpers) {
        this.helpers = helpers.toArray(new AbstractHyperLinkHelper[helpers.size()]);
        if (this.helpers.length > 0) {
            this.activeHelper = this.helpers[0];
        }
    }

    @Override
    public String getNameofManagedHyperLink() {
        return "Various";
    }

    public List<? extends AbstractHyperLinkHelper> getHelpers() {
        return Collections.unmodifiableList(Arrays.asList(this.helpers));
    }

    public void setActiveHelper(AbstractHyperLinkHelper helper) {
        if (!Arrays.asList(this.helpers).contains(helper)) {
            throw new IllegalArgumentException("not a composed helper");
        }
        this.activeHelper = helper;
    }

    @Override
    public void executeNewMousePressed(Shell parentShell, List<HyperLinkObject> list, EObject aModel) {
        if (this.activeHelper != null) {
            int originalSize = list.size();
            this.activeHelper.executeNewMousePressed(parentShell, list, aModel);
            int i = originalSize;
            while (i < list.size()) {
                this.hyperlinks.put(list.get(i), this.activeHelper);
                ++i;
            }
        }
    }

    @Override
    public List<HyperLinkObject> getFilteredObject(List<HyperLinkObject> hyperLinkObjects) {
        LinkedHashSet<HyperLinkObject> result = new LinkedHashSet<HyperLinkObject>();
        int i = 0;
        while (i < this.helpers.length) {
            result.addAll(this.helpers[i].getFilteredObject(hyperLinkObjects));
            ++i;
        }
        return new ArrayList<HyperLinkObject>(result);
    }

    @Override
    public HyperLinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        HyperLinkObject result = null;
        int i = 0;
        while (result == null && i < this.helpers.length) {
            result = this.helpers[i].getHyperLinkObject(eAnnotation);
            if (result != null) {
                this.hyperlinks.put(result, this.helpers[i]);
            }
            ++i;
        }
        return result;
    }

    @Override
    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperLinkObject hyperLinkObject) {
        RecordingCommand result = null;
        AbstractHyperLinkHelper helper = this.hyperlinks.get(hyperLinkObject);
        if (helper != null) {
            result = helper.getAddHyperLinkCommand(domain, object, hyperLinkObject);
        }
        return result;
    }
}

