/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.dependencies.util;

import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.ecore.dependencies.DependenciesFactory;
import org.eclipse.emf.cdo.ecore.dependencies.Element;
import org.eclipse.emf.cdo.ecore.dependencies.Link;
import org.eclipse.emf.cdo.ecore.dependencies.Model;
import org.eclipse.emf.cdo.ecore.dependencies.ModelContainer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

public final class WorkspaceScanner {
    private WorkspaceScanner() {
    }

    public static ModelContainer scanWorkspace() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceProxyVisitor((ResourceSet)resourceSet){
                private final /* synthetic */ ResourceSet val$resourceSet;
                {
                    this.val$resourceSet = resourceSet;
                }

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1 && proxy.getName().endsWith(".ecore")) {
                        String fullPath = proxy.requestFullPath().toString();
                        this.val$resourceSet.getResource(URI.createPlatformResourceURI((String)fullPath, (boolean)true), true);
                        return false;
                    }
                    return true;
                }
            }, 16);
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
        return WorkspaceScanner.resolveAll((ResourceSet)resourceSet);
    }

    private static ModelContainer resolveAll(ResourceSet resourceSet) {
        ModelContainer container = DependenciesFactory.eINSTANCE.createModelContainer();
        EList resources = resourceSet.getResources();
        int start = 0;
        int lastStart = -1;
        while (start != lastStart) {
            int size = resources.size();
            int i = start;
            while (i < size) {
                WorkspaceScanner.resolveAll(container, (Resource)resources.get(i));
                ++i;
            }
            lastStart = start;
            start = size;
        }
        return container;
    }

    private static void resolveAll(ModelContainer container, Resource source) {
        for (EObject eObject : source.getContents()) {
            WorkspaceScanner.resolveAll(container, source, eObject);
        }
    }

    private static void resolveAll(ModelContainer container, Resource source, EObject eObject) {
        eObject.eContainer();
        WorkspaceScanner.resolveCrossReferences(container, source, eObject);
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            EObject childEObject = (EObject)i.next();
            WorkspaceScanner.resolveCrossReferences(container, source, childEObject);
        }
    }

    private static void resolveCrossReferences(ModelContainer container, Resource source, EObject eObject) {
        URI sourceURI = EcoreUtil.getURI((EObject)eObject);
        Model sourceModel = WorkspaceScanner.getModel(container, null, source);
        Element sourceElement = WorkspaceScanner.getElement(sourceModel, sourceURI);
        EContentsEList.FeatureIterator it = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
        while (it.hasNext()) {
            EObject targetObject = (EObject)it.next();
            EReference reference = (EReference)it.feature();
            if (reference.isDerived()) continue;
            Model targetModel = null;
            boolean proxy = false;
            URI targetURI = ((InternalEObject)targetObject).eProxyURI();
            if (targetURI != null) {
                targetModel = WorkspaceScanner.getModel(container, targetURI, null);
                proxy = true;
            } else {
                Resource target = targetObject.eResource();
                if (target != null && target != source) {
                    targetURI = EcoreUtil.getURI((EObject)targetObject);
                    targetModel = WorkspaceScanner.getModel(container, targetURI, target);
                }
            }
            if (targetURI == null) continue;
            Element targetElement = WorkspaceScanner.getElement(targetModel, targetURI);
            if (proxy) {
                targetElement.setExists(false);
            }
            Link link = DependenciesFactory.eINSTANCE.createLink();
            link.setUri(sourceURI);
            link.setSource(sourceElement);
            link.setTarget(targetElement);
            link.setReference(reference);
        }
    }

    private static Model getModel(ModelContainer container, URI uri, Resource resource) {
        Model model;
        if (uri == null) {
            uri = resource.getURI();
        }
        if ((model = container.getModel(uri = uri.trimFragment())) == null) {
            model = DependenciesFactory.eINSTANCE.createModel();
            model.setUri(uri);
            model.setContainer(container);
        }
        if (resource != null) {
            EPackage ePackage = (EPackage)resource.getContents().get(0);
            model.setNsURI(ePackage.getNsURI());
            model.setName(ePackage.getName());
            model.setExists(true);
        }
        return model;
    }

    private static Element getElement(Model model, URI uri) {
        Element element = model.getElement(uri);
        if (element == null) {
            element = DependenciesFactory.eINSTANCE.createElement();
            element.setUri(uri);
            element.setModel(model);
            element.setExists(true);
        }
        return element;
    }
}

