/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.ui;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;

public class EmptyProjectWizard
extends Wizard
implements INewWizard {
    protected IWorkbench workbench;
    protected IPath genModelProjectLocation;
    protected IPath genModelContainerPath;
    protected IProject project;
    protected String initialProjectName;
    protected IStructuredSelection selection;
    protected WizardNewProjectCreationPage newProjectCreationPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(GenModelEditPlugin.INSTANCE.getImage("full/wizban/NewEmptyEMFProject")));
        this.setWindowTitle(GenModelEditPlugin.INSTANCE.getString("_UI_NewEmptyProject_title"));
    }

    public void addPages() {
        this.newProjectCreationPage = new WizardNewProjectCreationPage("NewProjectCreationPage"){

            protected boolean validatePage() {
                if (super.validatePage()) {
                    IPath locationPath = this.getLocationPath();
                    EmptyProjectWizard.this.genModelProjectLocation = Platform.getLocation().equals((Object)locationPath) ? null : locationPath;
                    IPath projectPath = this.getProjectHandle().getFullPath();
                    EmptyProjectWizard.this.genModelContainerPath = projectPath.append("src");
                    return true;
                }
                return false;
            }

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.createWorkingSetGroup((Composite)this.getControl(), EmptyProjectWizard.this.selection, new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.pde.ui.pluginWorkingSet", "org.eclipse.ui.resourceWorkingSetPage"});
            }
        };
        this.newProjectCreationPage.setInitialProjectName(this.initialProjectName);
        this.newProjectCreationPage.setTitle(GenModelEditPlugin.INSTANCE.getString("_UI_EmptyProject_title"));
        this.newProjectCreationPage.setDescription(GenModelEditPlugin.INSTANCE.getString("_UI_EmptyProject_description"));
        this.addPage((IWizardPage)this.newProjectCreationPage);
    }

    public boolean performFinish() {
        IWorkbenchPage page;
        IWorkbenchPart activePart;
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        EmptyProjectWizard.this.modifyWorkspace(progressMonitor);
                    }
                    catch (Exception exception) {
                        GenModelEditPlugin.INSTANCE.log(exception);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception exception) {
            GenModelEditPlugin.INSTANCE.log(exception);
            return false;
        }
        if (this.project != null && (activePart = (page = this.workbench.getActiveWorkbenchWindow().getActivePage()).getActivePart()) instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)this.project);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        return true;
    }

    public void modifyWorkspace(IProgressMonitor progressMonitor) throws CoreException, UnsupportedEncodingException, IOException {
        this.project = Generator.createEMFProject((IPath)new Path(this.genModelContainerPath.toString()), (IPath)this.genModelProjectLocation, Collections.emptyList(), (IProgressMonitor)progressMonitor, (int)(Generator.EMF_MODEL_PROJECT_STYLE | Generator.EMF_PLUGIN_PROJECT_STYLE));
        IWorkingSet[] workingSets = this.newProjectCreationPage.getSelectedWorkingSets();
        if (workingSets != null) {
            this.workbench.getWorkingSetManager().addToWorkingSets((IAdaptable)this.project, workingSets);
        }
        CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)new Path("/" + this.genModelContainerPath.segment(0) + "/model"), (boolean)true, (IPath)this.genModelProjectLocation, (IProgressMonitor)progressMonitor);
        PrintStream manifest = new PrintStream(URIConverter.INSTANCE.createOutputStream(URI.createPlatformResourceURI((String)("/" + this.genModelContainerPath.segment(0) + "/META-INF/MANIFEST.MF"), (boolean)true), null), false, "UTF-8");
        manifest.println("Manifest-Version: 1.0");
        manifest.println("Bundle-ManifestVersion: 2");
        manifest.print("Bundle-Name: ");
        manifest.println(this.genModelContainerPath.segment(0));
        manifest.print("Bundle-SymbolicName: ");
        manifest.print(CodeGenUtil.validPluginID((String)this.genModelContainerPath.segment(0)));
        manifest.println("; singleton:=true");
        manifest.println("Bundle-Version: 0.1.0.qualifier");
        manifest.print("Require-Bundle: ");
        String[] requiredBundles = this.getRequiredBundles();
        int i = 0;
        int size = requiredBundles.length;
        while (i < size) {
            manifest.print(requiredBundles[i]);
            if (++i == size) {
                manifest.println();
                break;
            }
            manifest.println(",");
            manifest.print(" ");
        }
        manifest.close();
    }

    public void setInitialProjectName(String value) {
        this.initialProjectName = value;
    }

    protected String[] getRequiredBundles() {
        return new String[]{"org.eclipse.emf.ecore"};
    }
}

