/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.ThreeWayComparisonGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.ConflictNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.ecore.EObject;

public class ConflictNodeBuilder {
    private final Conflict conflict;
    private final ThreeWayComparisonGroupProvider.ConflictsGroupImpl group;
    private final Map<Match, MatchNode> matchNodes;

    public ConflictNodeBuilder(Conflict conflict, ThreeWayComparisonGroupProvider.ConflictsGroupImpl group) {
        this.conflict = conflict;
        this.group = group;
        this.matchNodes = new LinkedHashMap<Match, MatchNode>();
    }

    public ConflictNode buildNode() {
        MatchNode matchNode;
        ConflictNode conflictNode = this.group.createConflictNode(this.conflict);
        for (Diff diff : this.conflict.getDifferences()) {
            Match match = this.group.getTargetMatch(diff);
            if (match == null) continue;
            matchNode = this.ensureMatchNode(match, conflictNode);
            this.group.addDiffNode(matchNode, diff);
        }
        ArrayList nonRootMatches = Lists.newArrayListWithCapacity((int)this.matchNodes.size());
        block1: for (Match match : this.matchNodes.keySet()) {
            EObject container = match.eContainer();
            while (container instanceof Match) {
                if (this.matchNodes.containsKey(container)) {
                    nonRootMatches.add(match);
                    continue block1;
                }
                container = container.eContainer();
            }
        }
        for (Match match : nonRootMatches) {
            matchNode = this.matchNodes.get(match);
            EObject container = match.eContainer();
            MatchNode childNode = matchNode;
            boolean stop = false;
            while (container instanceof Match && !stop) {
                MatchNode hierarchyNode;
                if (this.matchNodes.containsKey(container)) {
                    hierarchyNode = this.matchNodes.get(container);
                    stop = true;
                } else {
                    hierarchyNode = this.group.createMatchNode((Match)container);
                    this.matchNodes.put((Match)container, hierarchyNode);
                }
                hierarchyNode.addSubMatchNode(childNode);
                childNode = hierarchyNode;
                container = container.eContainer();
            }
        }
        return conflictNode;
    }

    private MatchNode ensureMatchNode(Match match, ConflictNode conflictNode) {
        MatchNode node;
        if (this.matchNodes.containsKey(match)) {
            node = this.matchNodes.get(match);
        } else {
            node = this.group.createMatchNode(match);
            conflictNode.addConflictingTree(node);
            this.matchNodes.put(match, node);
        }
        return node;
    }
}

