/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.eresource.CDOFileResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.internal.ui.editor.CDOLobEditorInput;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.ui.GlobalPartAdapter;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CDOCheckoutLobEditorInput
extends CDOLobEditorInput
implements IPersistableElement {
    protected static final String URI_TAG = "uri";
    protected static final String COMMIT_ON_SAVE_TAG = "commitOnSave";
    private final CDOCheckout checkout;

    static {
        CDOExplorerUtil.getCheckoutManager().addListener((IListener)new ContainerEventAdapter<CDOCheckout>(){

            protected void onRemoved(IContainer<CDOCheckout> container, CDOCheckout checkout) {
                this.closeLobEditors(checkout);
            }

            protected void notifyOtherEvent(IEvent event) {
                CDOCheckoutManager.CheckoutStateEvent e;
                if (event instanceof CDOCheckoutManager.CheckoutStateEvent && (e = (CDOCheckoutManager.CheckoutStateEvent)event).getNewState() == CDOCheckout.State.Closed) {
                    this.closeLobEditors(e.getCheckout());
                }
            }

            private void closeLobEditors(CDOCheckout checkout) {
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                        int n5 = iEditorReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            CDOCheckoutLobEditorInput lobInput;
                            IEditorInput input;
                            IEditorReference reference = iEditorReferenceArray[n6];
                            IEditorPart editor = reference.getEditor(false);
                            if (editor != null && (input = editor.getEditorInput()) instanceof CDOCheckoutLobEditorInput && (lobInput = (CDOCheckoutLobEditorInput)input).getCheckout() == checkout) {
                                UIUtil.syncExec(() -> {
                                    boolean bl = page.closeEditor(editor, false);
                                });
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        new GlobalPartAdapter(){

            public void partClosed(IWorkbenchPartReference partRef) {
                CDOCheckoutLobEditorInput lobInput;
                CDOView view;
                CDOCheckout checkout;
                IEditorPart editor;
                IEditorInput input;
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof IEditorPart && (input = (editor = (IEditorPart)part).getEditorInput()) instanceof CDOCheckoutLobEditorInput && ((checkout = CDOExplorerUtil.getCheckout((Object)(view = (lobInput = (CDOCheckoutLobEditorInput)input).getResource().cdoView()))) == null || checkout.getView() != view)) {
                    LifecycleUtil.deactivate((Object)view);
                }
            }
        };
    }

    public CDOCheckoutLobEditorInput(URI uri) {
        this(uri, false);
    }

    public CDOCheckoutLobEditorInput(URI uri, boolean commitOnSave) {
        super(CDOCheckoutLobEditorInput.getFile(uri), commitOnSave);
        this.setURI(uri);
        this.checkout = CDOExplorerUtil.getCheckout((Object)this.getResource());
    }

    protected final CDOCheckout getCheckout() {
        return this.checkout;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public void saveState(IMemento memento) {
        URI uri = this.getURI();
        memento.putString(URI_TAG, uri == null ? null : uri.toString());
        memento.putBoolean(COMMIT_ON_SAVE_TAG, this.isCommitOnSave());
    }

    public String getFactoryId() {
        return "org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutLobEditorInput.ElementFactory";
    }

    public static IEditorPart openEditor(IWorkbenchPage page, String editorID, URI uri) throws PartInitException {
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCheckoutLobEditorInput lobInput;
            IEditorInput editorInput;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            if (ObjectUtil.equals((Object)editorReference.getId(), (Object)editorID) && (editorInput = editorReference.getEditorInput()) instanceof CDOCheckoutLobEditorInput && (lobInput = (CDOCheckoutLobEditorInput)editorInput).getURI().equals(uri)) {
                IEditorPart editor = editorReference.getEditor(true);
                page.activate((IWorkbenchPart)editor);
                return editor;
            }
            ++n2;
        }
        CDOCheckoutLobEditorInput lobInput = new CDOCheckoutLobEditorInput(uri, true);
        return page.openEditor((IEditorInput)lobInput, editorID);
    }

    private static CDOFileResource<?> getFile(URI uri) {
        String id = uri.authority();
        CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)id);
        if (checkout != null) {
            checkout.open();
            Object view = checkout.isReadOnly() ? checkout.getView() : checkout.openTransaction();
            CDOResourceNode node = view.getResourceNode(uri.path());
            if (node instanceof CDOFileResource) {
                return (CDOFileResource)node;
            }
        }
        return null;
    }

    public static class ElementFactory
    implements IElementFactory {
        public static final String ID = "org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutLobEditorInput.ElementFactory";

        public IAdaptable createElement(IMemento memento) {
            URI uri = URI.createURI((String)memento.getString(CDOCheckoutLobEditorInput.URI_TAG));
            boolean commitOnSave = memento.getBoolean(CDOCheckoutLobEditorInput.COMMIT_ON_SAVE_TAG);
            return new CDOCheckoutLobEditorInput(uri, commitOnSave);
        }
    }
}

