/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryElement;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutBranchPointPage;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutLabelPage;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutRepositoryPage;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutRootObjectPage;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutTypePage;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;

public class CheckoutWizard
extends Wizard
implements IImportWizard,
IPageChangedListener {
    private CDORepositoryElement selectedElement;
    private CheckoutRepositoryPage repositoryPage;
    private CheckoutTypePage typePage;
    private CheckoutBranchPointPage branchPointPage;
    private CheckoutRootObjectPage rootObjectPage;
    private CheckoutLabelPage labelPage;

    public CheckoutWizard() {
        this.setWindowTitle("New Checkout");
    }

    public final CheckoutRepositoryPage getRepositoryPage() {
        return this.repositoryPage;
    }

    public final CheckoutTypePage getTypePage() {
        return this.typePage;
    }

    public final CheckoutBranchPointPage getBranchPointPage() {
        return this.branchPointPage;
    }

    public final CheckoutRootObjectPage getRootObjectPage() {
        return this.rootObjectPage;
    }

    public final CheckoutLabelPage getLabelPage() {
        return this.labelPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            this.selectedElement = (CDORepositoryElement)AdapterUtil.adapt((Object)element, CDORepositoryElement.class);
        }
    }

    public void setContainer(IWizardContainer wizardContainer) {
        if (this.getContainer() instanceof WizardDialog) {
            ((WizardDialog)this.getContainer()).removePageChangedListener((IPageChangedListener)this);
        }
        super.setContainer(wizardContainer);
        if (this.getContainer() instanceof WizardDialog) {
            ((WizardDialog)this.getContainer()).addPageChangedListener((IPageChangedListener)this);
        }
    }

    public void pageChanged(PageChangedEvent event) {
        Object page = event.getSelectedPage();
        if (page instanceof CheckoutWizardPage) {
            CheckoutWizardPage checkoutWizardPage = (CheckoutWizardPage)((Object)page);
            checkoutWizardPage.pageActivated();
        }
    }

    public void addPages() {
        CDORepository repository;
        this.repositoryPage = new CheckoutRepositoryPage();
        this.addPage((IWizardPage)this.repositoryPage);
        this.typePage = new CheckoutTypePage();
        this.addPage((IWizardPage)this.typePage);
        this.branchPointPage = new CheckoutBranchPointPage();
        this.addPage((IWizardPage)this.branchPointPage);
        this.rootObjectPage = new CheckoutRootObjectPage();
        this.addPage((IWizardPage)this.rootObjectPage);
        this.labelPage = new CheckoutLabelPage();
        this.addPage((IWizardPage)this.labelPage);
        if (this.selectedElement != null && (repository = this.selectedElement.getRepository()) != null) {
            this.repositoryPage.setRepository(repository);
            this.repositoryPage.skip();
            int branchID = this.selectedElement.getBranchID();
            long timeStamp = this.selectedElement.getTimeStamp();
            if (timeStamp != 0L) {
                this.typePage.setType("online-historical");
            }
            this.branchPointPage.setBranchPoint(branchID, timeStamp);
        }
    }

    public boolean performFinish() {
        final Properties properties = new Properties();
        this.repositoryPage.fillProperties(properties);
        this.typePage.fillProperties(properties);
        this.branchPointPage.fillProperties(properties);
        this.rootObjectPage.fillProperties(properties);
        this.labelPage.fillProperties(properties);
        new Job("Checkout"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CDOCheckoutManager checkoutManager = CDOExplorerUtil.getCheckoutManager();
                    CDOCheckout checkout = checkoutManager.addCheckout(properties);
                    checkout.open();
                    CheckoutWizard.showInProjectExplorer(checkout);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                    Status status = new Status(4, "org.eclipse.emf.cdo.explorer.ui", ex.getMessage(), (Throwable)ex);
                    UIUtil.getDisplay().asyncExec(new Runnable((IStatus)status){
                        private final /* synthetic */ IStatus val$status;
                        {
                            this.val$status = iStatus;
                        }

                        @Override
                        public void run() {
                            ErrorDialog.openError((Shell)CheckoutWizard.this.getShell(), (String)"Error", (String)"An error occured while creating the checkout.", (IStatus)this.val$status);
                        }
                    });
                    return Status.OK_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return true;
    }

    public static void showInProjectExplorer(final Object ... objects) {
        UIUtil.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow window;
                IWorkbench workbench = PlatformUI.getWorkbench();
                IViewDescriptor viewDescriptor = workbench.getViewRegistry().find("org.eclipse.ui.navigator.ProjectExplorer");
                if (viewDescriptor != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                    try {
                        page.showView(viewDescriptor.getId());
                        CDOCheckoutContentProvider checkoutContentProvider = CDOCheckoutContentProvider.getInstance("org.eclipse.ui.navigator.ProjectExplorer");
                        if (checkoutContentProvider != null) {
                            checkoutContentProvider.selectObjects(objects);
                        }
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
            }
        });
    }
}

