/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.core;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.pde.spy.core.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SpyProcessor {
    static final String SPY_TAG = "Spy";
    public static final String SPY_COMMAND = "org.eclipse.pde.spy.core.command";
    public static final String SPY_COMMAND_PARAM = "org.eclipse.pde.spy.core.command.partID";
    private static final String E4_SPIES_BINDING_TABLE = "org.eclipse.pde.spy.core.bindings";
    MApplication application;
    EModelService modelService;

    @Inject
    public SpyProcessor(MApplication application, EModelService modelService) {
        this.application = application;
        this.modelService = modelService;
    }

    @Execute
    public void process(IExtensionRegistry extRegistry) {
        MCommand command = this.getSpyCommand();
        MBindingTable bindingTable = this.getBindingTable();
        IConfigurationElement[] iConfigurationElementArray = extRegistry.getConfigurationElementsFor("org.eclipse.pde.spy.core.spyPart");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String partName = e.getAttribute("name");
            String shortCut = e.getAttribute("shortcut");
            String iconPath = e.getAttribute("icon");
            String desc = e.getAttribute("description");
            Bundle b = Platform.getBundle((String)e.getNamespaceIdentifier());
            String partID = e.getAttribute("part");
            try {
                Class partClass = b.loadClass(partID);
                this.bindSpyKeyBinding(bindingTable, shortCut, command, partID);
                this.addSpyPartDescriptor(partID, partName, iconPath, partClass, desc);
            }
            catch (InvalidRegistryObjectException e1) {
                e1.printStackTrace();
            }
            catch (ClassNotFoundException e1) {
                Platform.getLog(this.getClass()).error("The class '" + partID + "' can not be instantiated. Check name or launch config");
                e1.printStackTrace();
            }
            ++n2;
        }
    }

    public MCommand getSpyCommand() {
        for (MCommand cmd : this.application.getCommands()) {
            if (!SPY_COMMAND.equals(cmd.getElementId())) continue;
            return cmd;
        }
        Platform.getLog(this.getClass()).error("The Spy command (with ID : org.eclipse.pde.spy.core.command cannot be found (It should be provided by org.eclipse.pde.spy.core/fragmenE4.xmi");
        return null;
    }

    public void bindSpyKeyBinding(MBindingTable spyBindingTable, String keySequence, MCommand cmd, String paramViewId) {
        for (MKeyBinding kb : spyBindingTable.getBindings()) {
            if (!keySequence.equals(kb.getKeySequence())) continue;
            if (kb.getCommand().getElementId().equals(cmd.getElementId())) {
                return;
            }
            System.out.println("WARNING : Cannot bind the command '" + cmd.getElementId() + "' to the keySequence : " + keySequence + " because the command " + kb.getCommand().getElementId() + " is already bound !");
            return;
        }
        MKeyBinding binding = (MKeyBinding)this.modelService.createModelElement(MKeyBinding.class);
        binding.setElementId(String.valueOf(paramViewId) + ".binding");
        binding.setContributorURI(cmd.getContributorURI());
        binding.setKeySequence(keySequence);
        binding.getPersistedState().put("persistState", "false");
        MParameter p = (MParameter)this.modelService.createModelElement(MParameter.class);
        p.setName(SPY_COMMAND_PARAM);
        p.setValue(paramViewId);
        binding.getParameters().add(p);
        spyBindingTable.getBindings().add(binding);
        binding.setCommand(cmd);
    }

    private MBindingTable getBindingTable() {
        MBindingTable spyBindingTable = null;
        for (MBindingTable bt : this.application.getBindingTables()) {
            if (!E4_SPIES_BINDING_TABLE.equals(bt.getElementId())) continue;
            spyBindingTable = bt;
        }
        if (spyBindingTable == null) {
            MBindingContext bc = null;
            List bindingContexts = this.application.getBindingContexts();
            if (bindingContexts.size() == 0) {
                bc = (MBindingContext)this.modelService.createModelElement(MBindingContext.class);
                bc.setElementId("org.eclipse.ui.contexts.window");
            } else {
                Iterator iterator = bindingContexts.iterator();
                while (iterator.hasNext()) {
                    MBindingContext aBindingContext;
                    bc = aBindingContext = (MBindingContext)iterator.next();
                    if ("org.eclipse.ui.contexts.dialogAndWindow".equals(aBindingContext.getElementId())) break;
                }
            }
            spyBindingTable = (MBindingTable)this.modelService.createModelElement(MBindingTable.class);
            spyBindingTable.setElementId(E4_SPIES_BINDING_TABLE);
            spyBindingTable.setBindingContext(bc);
            spyBindingTable.getPersistedState().put("persistState", "false");
            this.application.getBindingTables().add(spyBindingTable);
        }
        return spyBindingTable;
    }

    public void addSpyPartDescriptor(String partId, String partLabel, String iconPath, Class<?> spyPartClass, String desc) {
        for (MPartDescriptor mp : this.application.getDescriptors()) {
            if (!partId.equals(mp.getElementId())) continue;
            mp.setCategory(Messages.SpyProcessor_category);
            mp.setDescription(desc);
            mp.setLabel(partLabel);
            mp.getPersistedState().remove("persistState");
            String bundleId = FrameworkUtil.getBundle(spyPartClass).getSymbolicName();
            mp.setContributionURI("bundleclass://" + bundleId + "/" + spyPartClass.getCanonicalName());
            String contributorURI = "platform:/plugin/" + bundleId;
            mp.setContributorURI(contributorURI);
            mp.setIconURI(String.valueOf(contributorURI) + "/" + iconPath);
            return;
        }
        MPartDescriptor descriptor = (MPartDescriptor)this.modelService.createModelElement(MPartDescriptor.class);
        descriptor.setCategory(Messages.SpyProcessor_category);
        descriptor.setElementId(partId);
        descriptor.setDescription(desc);
        descriptor.getTags().add("View");
        descriptor.getTags().add(SPY_TAG);
        descriptor.getTags().add("categoryTag:Eclipse Runtime Spies");
        descriptor.setLabel(partLabel);
        descriptor.setCloseable(true);
        String bundleId = FrameworkUtil.getBundle(spyPartClass).getSymbolicName();
        descriptor.setContributionURI("bundleclass://" + bundleId + "/" + spyPartClass.getCanonicalName());
        String contributorURI = "platform:/plugin/" + bundleId;
        descriptor.setContributorURI(contributorURI);
        descriptor.setIconURI(String.valueOf(contributorURI) + "/" + iconPath);
        this.application.getDescriptors().add(descriptor);
    }

    @AboutToShow
    public void fillE4SpyMenu(List<MMenuElement> items) {
        MCommand command = this.getSpyCommand();
        for (MPartDescriptor mp : this.application.getDescriptors()) {
            if (!mp.getTags().contains(SPY_TAG)) continue;
            MHandledMenuItem hi = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
            hi.setCommand(command);
            hi.setLabel(mp.getLabel());
            hi.setContributorURI(mp.getContributorURI());
            hi.setIconURI(mp.getIconURI());
            hi.setTooltip(mp.getDescription());
            hi.getPersistedState().put("persistState", "false");
            MParameter p = (MParameter)this.modelService.createModelElement(MParameter.class);
            p.setName(SPY_COMMAND_PARAM);
            p.setValue(mp.getElementId());
            hi.getParameters().add(p);
            items.add((MMenuElement)hi);
        }
    }
}

