/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionExpression
extends FeatureCall {
    private final Expression closure;
    private final Identifier eleName;

    public CollectionExpression(Identifier name, Identifier eleName, Expression closure) {
        super(name, null);
        this.eleName = eleName;
        this.closure = closure;
    }

    @Override
    protected String toStringInternal() {
        return String.valueOf(super.toStringInternal()) + "(" + (this.eleName != null ? String.valueOf(this.eleName.toString()) + "|" : "") + this.closure + ")";
    }

    public Expression getClosure() {
        return this.closure;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object targetObj = null;
        if (this.getTarget() == null) {
            Variable v = ctx.getVariable("this");
            if (v != null) {
                targetObj = v.getValue();
            }
        } else {
            targetObj = this.getTarget().evaluate(ctx);
        }
        if (targetObj == null) {
            return ctx.handleNullEvaluation(this);
        }
        if (!(targetObj instanceof Collection)) {
            throw new EvaluationException("Couldn't call '" + this.toString() + "' on an object of java type " + targetObj.getClass().getName(), (SyntaxElement)this, ctx);
        }
        String nameValue = this.getName().toString();
        if (nameValue.equals("collect")) {
            return this.executeCollect((Collection)targetObj, ctx);
        }
        if (nameValue.equals("select")) {
            return this.executeSelect((Collection)targetObj, ctx);
        }
        if (nameValue.equals("selectFirst")) {
            return this.executeSelectFirst((Collection)targetObj, ctx);
        }
        if (nameValue.equals("reject")) {
            return this.executeReject((Collection)targetObj, ctx);
        }
        if (nameValue.equals("exists")) {
            return this.executeExists((Collection)targetObj, ctx);
        }
        if (nameValue.equals("notExists")) {
            return this.executeNotExists((Collection)targetObj, ctx);
        }
        if (nameValue.equals("forAll")) {
            return this.executeForAll((Collection)targetObj, ctx);
        }
        if (nameValue.equals("sortBy")) {
            return this.executeSortBy((Collection)targetObj, ctx);
        }
        throw new EvaluationException("Unknown collection operation : " + nameValue, (SyntaxElement)this, ctx);
    }

    private Object executeSortBy(Collection collection, ExecutionContext ctx) {
        class Pair
        implements Comparable {
            public Object o1;
            public Object o2;
            public Comparable c2;
            public String s2;

            Pair(Object o1, Object o2) {
                this.o1 = o1;
                this.o2 = o2;
                if (o2 instanceof Comparable) {
                    this.c2 = (Comparable)o2;
                }
                if (o2 != null) {
                    this.s2 = o2.toString();
                }
            }

            public int compareTo(Object o) {
                if (this == o) {
                    return 0;
                }
                if (this.o2 == null) {
                    return -1;
                }
                Pair pair = (Pair)o;
                if (pair.o2 == null) {
                    return 1;
                }
                try {
                    if (this.c2 != null) {
                        return this.c2.compareTo(pair.o2);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return this.s2.compareTo(pair.s2);
            }
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        String elementName = this.getElementName();
        for (Object o : collection) {
            ExecutionContext _ctx = ctx.cloneWithVariable(new Variable(elementName, o));
            _ctx.preTask(this);
            pairs.add(new Pair(o, this.closure.evaluate(_ctx)));
            _ctx.postTask(this);
        }
        Collections.sort(pairs);
        ArrayList<Object> result = new ArrayList<Object>(pairs.size());
        for (Pair pair : pairs) {
            result.add(pair.o1);
        }
        return result;
    }

    private Object executeForAll(Collection collection, ExecutionContext ctx) {
        ExecutionContext _ctx = ctx;
        String elementName = this.getElementName();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            _ctx = _ctx.cloneWithVariable(new Variable(elementName, iter.next()));
            _ctx.preTask(this);
            Object result = this.closure.evaluate(_ctx);
            _ctx.postTask(this);
            if (Boolean.TRUE.equals(result)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object executeExists(Collection collection, ExecutionContext ctx) {
        ExecutionContext _ctx = ctx;
        String elementName = this.getElementName();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            _ctx = _ctx.cloneWithVariable(new Variable(elementName, iter.next()));
            _ctx.preTask(this);
            Object result = this.closure.evaluate(_ctx);
            _ctx.postTask(this);
            if (!Boolean.TRUE.equals(result)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object executeNotExists(Collection collection, ExecutionContext ctx) {
        ExecutionContext _ctx = ctx;
        String elementName = this.getElementName();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            _ctx = _ctx.cloneWithVariable(new Variable(elementName, iter.next()));
            _ctx.preTask(this);
            Object result = this.closure.evaluate(_ctx);
            _ctx.postTask(this);
            if (!Boolean.TRUE.equals(result)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object executeReject(Collection collection, ExecutionContext ctx) {
        ExecutionContext _ctx = ctx;
        ArrayList resultCol = new ArrayList(collection);
        String elementName = this.getElementName();
        for (Object ele : collection) {
            _ctx = _ctx.cloneWithVariable(new Variable(elementName, ele));
            _ctx.preTask(this);
            Object result = this.closure.evaluate(_ctx);
            _ctx.postTask(this);
            if (!Boolean.TRUE.equals(result)) continue;
            resultCol.remove(ele);
        }
        return resultCol;
    }

    private Object executeSelect(Collection collection, ExecutionContext ctx) {
        ExecutionContext _ctx = ctx;
        ArrayList resultCol = new ArrayList();
        String elementName = this.getElementName();
        for (Object ele : collection) {
            _ctx = _ctx.cloneWithVariable(new Variable(elementName, ele));
            _ctx.preTask(this);
            Object result = this.closure.evaluate(_ctx);
            _ctx.postTask(this);
            if (!Boolean.TRUE.equals(result)) continue;
            resultCol.add(ele);
        }
        return resultCol;
    }

    private Object executeSelectFirst(Collection collection, ExecutionContext ctx) {
        ExecutionContext _ctx = ctx;
        ArrayList resultCol = new ArrayList();
        String elementName = this.getElementName();
        for (Object ele : collection) {
            _ctx = _ctx.cloneWithVariable(new Variable(elementName, ele));
            _ctx.preTask(this);
            Object result = this.closure.evaluate(_ctx);
            _ctx.postTask(this);
            if (!Boolean.TRUE.equals(result)) continue;
            resultCol.add(ele);
        }
        if (resultCol.size() == 0) {
            return null;
        }
        return resultCol.iterator().next();
    }

    private Object executeCollect(Collection collection, ExecutionContext ctx) {
        ExecutionContext _ctx = ctx;
        ArrayList<Object> resultCol = new ArrayList<Object>();
        String elementName = this.getElementName();
        for (Object ele : Collections.unmodifiableCollection(collection)) {
            _ctx = _ctx.cloneWithVariable(new Variable(elementName, ele));
            _ctx.preTask(this);
            resultCol.add(this.closure.evaluate(_ctx));
            _ctx.postTask(this);
        }
        return resultCol;
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ExecutionContext _ctx = ctx;
        Type targetType = null;
        if (this.getTarget() == null) {
            Variable v = _ctx.getVariable("this");
            if (v != null) {
                targetType = (Type)v.getValue();
            }
        } else {
            targetType = this.getTarget().analyze(_ctx, issues);
        }
        if (targetType == null) {
            return null;
        }
        if (!(targetType instanceof ParameterizedType)) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Collection type expected! was : " + targetType, this.getTarget()));
            return null;
        }
        Type innerType = ((ParameterizedType)targetType).getInnerType();
        Type result = null;
        _ctx = _ctx.cloneWithVariable(new Variable(this.getElementName(), innerType));
        Type closureType = this.closure.analyze(_ctx, issues);
        String nameValue = this.getName().toString();
        if (nameValue.equals("collect")) {
            String targetTypeName = targetType.getName();
            if (targetTypeName.startsWith("Set")) {
                return _ctx.getSetType(closureType);
            }
            if (targetTypeName.startsWith("List")) {
                return _ctx.getListType(closureType);
            }
            return _ctx.getCollectionType(closureType);
        }
        if (nameValue.equals("select") || nameValue.equals("reject")) {
            return targetType;
        }
        if (nameValue.equals("selectFirst")) {
            return innerType;
        }
        if (nameValue.equals("sortBy")) {
            return _ctx.getListType(innerType);
        }
        if (nameValue.equals("typeSelect")) {
            if (closureType == null) {
                return null;
            }
            return _ctx.getListType(closureType);
        }
        if (nameValue.equals("exists") || nameValue.equals("notExists") || nameValue.equals("forAll")) {
            if (!_ctx.getBooleanType().isAssignableFrom(closureType)) {
                issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Boolean type expected! was : " + closureType, this.closure));
            }
            result = _ctx.getBooleanType();
        } else {
            issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Unknown operation : " + nameValue, this));
        }
        return result;
    }

    public String getElementName() {
        return this.eleName != null ? this.eleName.toString() : "element";
    }
}

