/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakInterningHashSet<E>
extends AbstractSet<E>
implements Serializable {
    protected static final long serialVersionUID = 1L;
    protected static final Entry<Object> NULL_ENTRY = new Entry();
    protected static final int[] PRIME_CAPACITIES = new int[]{17, 37, 67, 131, 257, 521, 1031, 2053, 4099, 8209, 16411, 32771, 65537, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000003, 2147483629};
    protected static final int MOD_COUNT_INCREMENT = 128;
    protected static final int NULL_BIT_INCREMENT = 64;
    protected static final int CAPACITY_MASK = 31;
    protected int size;
    protected transient int modCount;
    protected transient Entry<E>[] entries;
    protected transient ReferenceQueue<E> queue = new ReferenceQueue();

    @Override
    public int size() {
        this.cleanup();
        return this.size;
    }

    public void grow(int minimumCapacity) {
        int capacityIndex = this.modCount & 0x1F;
        int currentCapacity = PRIME_CAPACITIES[capacityIndex];
        if (currentCapacity < minimumCapacity) {
            int i = 0;
            int length = PRIME_CAPACITIES.length;
            while (i < length) {
                int capacity = PRIME_CAPACITIES[i];
                if (capacity > minimumCapacity) {
                    this.modCount &= 0xFFFFFFE0;
                    this.modCount += i;
                    this.rehash(this.newEntries(capacity));
                    break;
                }
                ++i;
            }
        }
    }

    protected int hashCode(Object object) {
        return object.hashCode();
    }

    protected boolean equals(Object object, Object otherObject) {
        return object == otherObject || object.equals(otherObject);
    }

    protected Entry<E>[] newEntries(int capacity) {
        Entry[] newEntries = new Entry[capacity];
        return newEntries;
    }

    protected void ensureCapacity() {
        int capacityIndex = this.modCount & 0x1F;
        int capacity = PRIME_CAPACITIES[capacityIndex];
        if (this.entries == null) {
            this.entries = this.newEntries(capacity);
        } else if (this.size > (capacity >> 2) * 3) {
            ++this.modCount;
            this.rehash(this.newEntries(PRIME_CAPACITIES[capacityIndex + 1]));
        }
    }

    protected void rehash(Entry<E>[] newEntries) {
        Entry<E>[] oldEntries = this.entries;
        this.entries = newEntries;
        if (oldEntries != null) {
            Entry<E>[] entryArray = oldEntries;
            int n = oldEntries.length;
            int n2 = 0;
            while (n2 < n) {
                Entry<E> oldEntrie;
                Entry<E> entry = oldEntrie = entryArray[n2];
                while (entry != null) {
                    Entry nextEntry = entry.next;
                    this.putEntry(entry);
                    entry = nextEntry;
                }
                ++n2;
            }
        }
    }

    protected void cleanup() {
        Entry entry;
        while ((entry = (Entry)this.queue.poll()) != null) {
            this.removeEntry(entry);
        }
        return;
    }

    @Override
    public boolean add(E object) {
        this.cleanup();
        if (object == null) {
            if ((this.modCount & 0x40) == 0) {
                this.modCount += 64;
                ++this.size;
                return true;
            }
            return false;
        }
        int hashCode = this.hashCode(object);
        if (this.entries != null) {
            int index = this.index(hashCode);
            Entry<E> entry = this.entries[index];
            while (entry != null) {
                Object otherObject;
                if (hashCode == entry.hashCode && this.equals(object, otherObject = entry.get())) {
                    return false;
                }
                entry = entry.next;
            }
        }
        this.addEntry(this.createEntry(object, hashCode));
        return true;
    }

    @Override
    public boolean remove(Object object) {
        this.cleanup();
        if (object == null) {
            if ((this.modCount & 0x40) == 0) {
                return false;
            }
            this.modCount += 64;
            --this.size;
            return true;
        }
        if (this.entries != null) {
            int hashCode = this.hashCode(object);
            int index = this.index(hashCode);
            Entry<E> previousEntry = null;
            Entry<E> entry = this.entries[index];
            while (entry != null) {
                Object otherObject;
                if (hashCode == entry.hashCode && this.equals(object, otherObject = entry.get())) {
                    if (previousEntry == null) {
                        this.entries[index] = entry.next;
                    } else {
                        previousEntry.next = entry.next;
                    }
                    --this.size;
                    this.modCount += 128;
                    return true;
                }
                previousEntry = entry;
                entry = entry.next;
            }
        }
        return false;
    }

    public E intern(E object) {
        this.cleanup();
        if (object == null) {
            if ((this.modCount & 0x40) == 0) {
                this.modCount += 64;
                ++this.size;
            }
            return null;
        }
        int hashCode = this.hashCode(object);
        if (this.entries != null) {
            int index = this.index(hashCode);
            Entry<E> entry = this.entries[index];
            while (entry != null) {
                Object otherObject;
                if (hashCode == entry.hashCode && this.equals(object, otherObject = entry.get())) {
                    return (E)otherObject;
                }
                entry = entry.next;
            }
        }
        this.addEntry(this.createEntry(object, hashCode));
        return object;
    }

    public E get(E object) {
        this.cleanup();
        if (object == null) {
            return null;
        }
        if (this.entries != null) {
            int hashCode = this.hashCode(object);
            int index = this.index(hashCode);
            Entry<E> entry = this.entries[index];
            while (entry != null) {
                Object otherObject;
                if (hashCode == entry.hashCode && this.equals(object, otherObject = entry.get())) {
                    return (E)otherObject;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    @Override
    public boolean contains(Object object) {
        this.cleanup();
        if (object == null) {
            return (this.modCount & 0x40) != 0;
        }
        if (this.entries != null) {
            int hashCode = this.hashCode(object);
            int index = this.index(hashCode);
            Entry<E> entry = this.entries[index];
            while (entry != null) {
                Object otherObject;
                if (hashCode == entry.hashCode && this.equals(object, otherObject = entry.get())) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        this.cleanup();
        return new Iterator<E>(){
            int expectedModCount;
            int index;
            E nextObject;
            Entry<E> nextEntry;
            E removeObject;
            Entry<E> removeEntry;
            {
                this.expectedModCount = WeakInterningHashSet.this.modCount;
                if (WeakInterningHashSet.this.size > 0) {
                    if ((WeakInterningHashSet.this.modCount & 0x40) != 0) {
                        this.index = -1;
                        this.nextEntry = WeakInterningHashSet.this.nullEntry();
                    } else if (WeakInterningHashSet.this.entries != null) {
                        do {
                            Object object;
                            Entry entry;
                            if ((entry = WeakInterningHashSet.this.entries[this.index]) == null || (object = entry.get()) == null) continue;
                            this.nextObject = object;
                            this.nextEntry = entry;
                            break;
                        } while (++this.index != WeakInterningHashSet.this.entries.length);
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (WeakInterningHashSet.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return this.nextEntry != null;
            }

            @Override
            public E next() {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.removeObject = this.nextObject;
                this.removeEntry = this.nextEntry;
                Object result = this.nextObject;
                if (WeakInterningHashSet.this.entries != null) {
                    Entry entry = this.nextEntry.next;
                    while (true) {
                        if (entry != null) {
                            Object object = entry.get();
                            if (object != null) {
                                this.nextObject = object;
                                this.nextEntry = entry;
                                break;
                            }
                            entry = entry.next;
                            continue;
                        }
                        if (++this.index == WeakInterningHashSet.this.entries.length) {
                            this.nextEntry = null;
                            this.nextObject = null;
                            break;
                        }
                        entry = WeakInterningHashSet.this.entries[this.index];
                    }
                }
                return result;
            }

            @Override
            public void remove() {
                if (WeakInterningHashSet.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.removeEntry == null) {
                    throw new IllegalStateException();
                }
                WeakInterningHashSet.this.removeEntry(this.removeEntry);
                this.expectedModCount = WeakInterningHashSet.this.modCount;
                this.removeObject = null;
                this.removeEntry = null;
            }
        };
    }

    protected int index(int hashCode) {
        return (hashCode & Integer.MAX_VALUE) % this.entries.length;
    }

    protected Entry<E> getEntry(int hashCode) {
        this.cleanup();
        if (this.entries != null) {
            int index = this.index(hashCode);
            Entry<E> entry = this.entries[index];
            while (entry != null) {
                if (hashCode == entry.hashCode) {
                    return entry;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    protected Entry<E> nullEntry() {
        return NULL_ENTRY;
    }

    protected Entry<E> createEntry(E object, int hashCode) {
        return new Entry<E>(object, hashCode, this.queue);
    }

    protected void putEntry(Entry<E> entry) {
        int index = this.index(entry.hashCode);
        Entry<E> otherEntry = this.entries[index];
        this.entries[index] = entry;
        entry.next = otherEntry;
    }

    protected void addEntry(Entry<E> entry) {
        this.ensureCapacity();
        ++this.size;
        this.modCount += 128;
        this.putEntry(entry);
    }

    protected void removeEntry(Entry<E> entry) {
        int index = this.index(entry.hashCode);
        Entry<E> otherEntry = this.entries[index];
        --this.size;
        this.modCount += 128;
        if (entry == otherEntry) {
            this.entries[index] = entry.next;
        } else {
            Entry nextOtherEntry = otherEntry.next;
            while (nextOtherEntry != null) {
                if (nextOtherEntry == entry) {
                    otherEntry.next = entry.next;
                    break;
                }
                otherEntry = nextOtherEntry;
                nextOtherEntry = nextOtherEntry.next;
            }
        }
        entry.next = null;
        entry.clear();
    }

    protected void dump() {
        System.out.println(this.toString());
        System.out.println("size = " + this.size);
        System.out.println("null = " + ((this.modCount & 0x40) != 0));
        if (this.entries != null) {
            int i = 0;
            while (i < this.entries.length) {
                System.out.print(i);
                System.out.print(": ");
                Entry<E> entry = this.entries[i];
                while (entry != null) {
                    System.out.print("(" + entry.hashCode + ", " + entry.get() + ")");
                    if (entry.next != null) {
                        System.out.print(" -> ");
                    }
                    entry = entry.next;
                }
                System.out.println();
                ++i;
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeByte(this.modCount & 0x1F);
        if (this.size > 0) {
            for (E object : this) {
                objectOutputStream.writeObject(object);
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.queue = new ReferenceQueue();
        this.modCount = objectInputStream.readByte();
        if (this.size > 0) {
            this.ensureCapacity();
            int i = 0;
            while (i < this.size) {
                Object object = objectInputStream.readObject();
                if (object == null) {
                    this.modCount += 64;
                } else {
                    this.putEntry(this.createEntry(object, this.hashCode(object)));
                }
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<E>
    extends WeakReference<E> {
        public int hashCode;
        public Entry<E> next;

        private Entry() {
            super(null);
        }

        public Entry(E object, int hashCode, ReferenceQueue<? super E> q) {
            super(object, q);
            this.hashCode = hashCode;
        }

        public Entry<E> getNextEntry() {
            Entry<E> entry = this.next;
            while (entry != null) {
                if (entry.hashCode == this.hashCode) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        public String toString() {
            Object object = this.get();
            return object == null ? "null" : object.toString();
        }
    }
}

