/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security.operations;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.net4j.util.collection.CollectionUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;

public final class AuthorizableOperationFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.security.authorizableOperations";

    public AuthorizableOperationFactory() {
        super(PRODUCT_GROUP, null);
    }

    public String getOperationID() {
        return this.getType();
    }

    @Override
    public AuthorizableOperation create(String description) throws ProductCreationException {
        return AuthorizableOperation.build(this.getOperationID());
    }

    public static AuthorizableOperation getAuthorizableOperation(IManagedContainer container, String operationID) {
        AuthorizableOperation operation = (AuthorizableOperation)container.getElementOrNull(PRODUCT_GROUP, operationID, null);
        if (operation == null) {
            operation = AuthorizableOperation.build(operationID);
        }
        return operation;
    }

    public static AuthorizableOperation[] getAuthorizableOperations(IManagedContainer container) {
        Set<String> operationIDs = container.getFactoryTypes(PRODUCT_GROUP);
        ArrayList operations = new ArrayList();
        for (String operationID : operationIDs) {
            AuthorizableOperation operation = (AuthorizableOperation)container.getElementOrNull(PRODUCT_GROUP, operationID, null);
            CollectionUtil.addNotNull(operations, operation);
        }
        return operations.toArray(new AuthorizableOperation[operations.size()]);
    }
}

