/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.widgets.databinding.GrayedCheckboxObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class BooleanCheckbox
extends AbstractValueEditor {
    private final Button checkbox;
    private AggregatedObservable aggregated;

    public BooleanCheckbox(Composite parent, int style) {
        this(parent, style, null);
    }

    public BooleanCheckbox(Composite parent, int style, String label) {
        super(parent);
        this.checkbox = factory.createButton((Composite)this, label, 0x20 | style);
        ISWTObservableValue widgetObservable = WidgetProperties.selection().observe((Widget)this.checkbox);
        this.setWidgetObservable((IObservableValue)widgetObservable, true);
        GridData gridData = this.getDefaultLayoutData();
        this.checkbox.setLayoutData((Object)gridData);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
    }

    @Override
    public void setModelObservable(IObservableValue modelProperty) {
        Object newWidgetObservable;
        if (this.widgetObservable != null) {
            this.widgetObservable.dispose();
        }
        if (modelProperty instanceof AggregatedObservable) {
            this.aggregated = (AggregatedObservable)modelProperty;
            newWidgetObservable = new GrayedCheckboxObservableValue(this.checkbox, this.aggregated);
        } else {
            newWidgetObservable = WidgetProperties.selection().observe((Widget)this.checkbox);
        }
        this.setWidgetObservable((IObservableValue)newWidgetObservable, true);
        super.setModelObservable(modelProperty);
    }

    @Override
    public Object getEditableType() {
        return Boolean.class;
    }

    @Override
    public Boolean getValue() {
        return this.checkbox.getSelection();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.checkbox.setEnabled(!readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return !this.checkbox.isEnabled();
    }

    public void setToolTipText(String text) {
        this.checkbox.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    @Override
    public void setLabel(String label) {
        this.checkbox.setText(label);
    }

    public void setValue(Boolean selected) {
        if (this.modelProperty != null) {
            this.modelProperty.setValue((Object)selected);
        }
        this.widgetObservable.setValue((Object)selected);
    }
}

