/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.papyrus.infra.emf.utils.PlatformHelper;

public class ResourceUtils {
    private static final String PATH_SEPARATOR = "/";

    private ResourceUtils() {
    }

    public static IFile getFile(Resource resource) {
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            if (uri.isPlatformResource()) {
                String uriPlatformString = uri.toPlatformString(true);
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uriPlatformString));
            }
        }
        return null;
    }

    public static Collection<String> getAllResourceIds(XMIResource resource) {
        HashSet<String> ids = new HashSet<String>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject current = (EObject)iterator.next();
            String id = resource.getID(current);
            Assert.isNotNull((Object)id);
            Assert.isTrue((!ids.contains(id) ? 1 : 0) != 0);
            ids.add(id);
        }
        return ids;
    }

    public static Map<String, Object> getSaveOptions() {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        return saveOptions;
    }

    public static String mapAndEncodePath(IFile file) {
        String targetURI;
        URI pluginURI = URI.createPlatformPluginURI((String)(String.valueOf(file.getProject().getName()) + PATH_SEPARATOR + file.getProjectRelativePath().toString()), (boolean)true);
        String path = pluginURI.toString();
        for (Map.Entry<String, String> entry : ResourceUtils.getLocalUriMappings(file.getProject()).entrySet()) {
            targetURI = entry.getValue();
            if (targetURI == null || !targetURI.endsWith(PATH_SEPARATOR) || !path.startsWith(targetURI)) continue;
            return path.replaceFirst(targetURI, entry.getKey());
        }
        for (Map.Entry<String, String> entry : URIMappingRegistryImpl.INSTANCE.entrySet()) {
            targetURI = ((URI)entry.getValue()).toString();
            if (targetURI == null || !targetURI.endsWith(PATH_SEPARATOR) || !path.startsWith(targetURI)) continue;
            return path.replaceFirst(targetURI, ((URI)entry.getKey()).toString());
        }
        IPath relativePath = file.getProjectRelativePath();
        return ResourceUtils.getStringURI(relativePath);
    }

    public static URIConverter createWorkspaceAwareURIConverter() {
        ExtensibleURIConverterImpl result = new ExtensibleURIConverterImpl();
        Map uriMap = result.getURIMap();
        uriMap.putAll(ResourceUtils.computePlatformResourceMap());
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject next = iProjectArray[n2];
            if (next.isAccessible()) {
                Map<String, String> mappings = ResourceUtils.getLocalUriMappings(next);
                for (Map.Entry<String, String> mapping : mappings.entrySet()) {
                    URI prefix = URI.createURI((String)mapping.getKey());
                    URI target = URI.createURI((String)mapping.getValue());
                    uriMap.put(prefix, target);
                }
            }
            ++n2;
        }
        return result;
    }

    public static Map<String, String> getLocalUriMappings(IProject project) {
        return PlatformHelper.INSTANCE.getLocalUriMappings(project);
    }

    public static String getStringURI(IPath path) {
        return Arrays.stream(path.segments()).map(segment -> URI.encodeSegment((String)segment, (boolean)false)).collect(Collectors.joining(PATH_SEPARATOR));
    }

    public static Map<URI, URI> computePlatformResourceMap() {
        HashMap<URI, URI> result = new HashMap<URI, URI>();
        result.putAll(EcorePlugin.computePlatformPluginToPlatformResourceMap());
        List platform = PlatformHelper.INSTANCE.getPlatformBundleIDs().stream().map(name -> URI.createPlatformPluginURI((String)name, (boolean)true)).collect(Collectors.toList());
        result.putAll(EcorePlugin.computePlatformResourceToPlatformPluginMap(platform));
        return result;
    }

    public static EPackage.Registry createWorkspaceAwarePackageRegistry() {
        return PlatformHelper.INSTANCE.createWorkspacePackageRegistry();
    }
}

