/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ps extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AED = "AED";
        final String metaValue_ALL = "ALL";
        final String metaValue_AMD = "AMD";
        final String metaValue_ANG = "ANG";
        final String metaValue_AOA = "AOA";
        final String metaValue_ARS = "ARS";
        final String metaValue_AWG = "AWG";
        final String metaValue_AZN = "AZN";
        final String metaValue_BAM = "BAM";
        final String metaValue_BBD = "BBD";
        final String metaValue_BDT = "BDT";
        final String metaValue_BGN = "BGN";
        final String metaValue_BHD = "BHD";
        final String metaValue_BIF = "BIF";
        final String metaValue_BMD = "BMD";
        final String metaValue_BND = "BND";
        final String metaValue_BOB = "BOB";
        final String metaValue_BSD = "BSD";
        final String metaValue_BTN = "BTN";
        final String metaValue_BWP = "BWP";
        final String metaValue_BYN = "BYN";
        final String metaValue_BZD = "BZD";
        final String metaValue_CDF = "CDF";
        final String metaValue_CHF = "CHF";
        final String metaValue_CLP = "CLP";
        final String metaValue_CNH = "CNH";
        final String metaValue_COP = "COP";
        final String metaValue_CRC = "CRC";
        final String metaValue_CUC = "CUC";
        final String metaValue_CUP = "CUP";
        final String metaValue_CVE = "CVE";
        final String metaValue_CZK = "CZK";
        final String metaValue_DJF = "DJF";
        final String metaValue_DKK = "DKK";
        final String metaValue_DOP = "DOP";
        final String metaValue_DZD = "DZD";
        final String metaValue_EGP = "EGP";
        final String metaValue_ERN = "ERN";
        final String metaValue_ETB = "ETB";
        final String metaValue_FJD = "FJD";
        final String metaValue_FKP = "FKP";
        final String metaValue_GEL = "GEL";
        final String metaValue_GHS = "GHS";
        final String metaValue_GIP = "GIP";
        final String metaValue_GMD = "GMD";
        final String metaValue_GNF = "GNF";
        final String metaValue_GTQ = "GTQ";
        final String metaValue_GYD = "GYD";
        final String metaValue_HNL = "HNL";
        final String metaValue_HRK = "HRK";
        final String metaValue_HTG = "HTG";
        final String metaValue_HUF = "HUF";
        final String metaValue_IDR = "IDR";
        final String metaValue_IQD = "IQD";
        final String metaValue_IRR = "IRR";
        final String metaValue_ISK = "ISK";
        final String metaValue_JMD = "JMD";
        final String metaValue_JOD = "JOD";
        final String metaValue_KES = "KES";
        final String metaValue_KGS = "KGS";
        final String metaValue_KHR = "KHR";
        final String metaValue_KMF = "KMF";
        final String metaValue_KPW = "KPW";
        final String metaValue_KWD = "KWD";
        final String metaValue_KYD = "KYD";
        final String metaValue_KZT = "KZT";
        final String metaValue_LAK = "LAK";
        final String metaValue_LBP = "LBP";
        final String metaValue_LKR = "LKR";
        final String metaValue_LRD = "LRD";
        final String metaValue_LYD = "LYD";
        final String metaValue_MAD = "MAD";
        final String metaValue_MDL = "MDL";
        final String metaValue_MGA = "MGA";
        final String metaValue_MKD = "MKD";
        final String metaValue_MMK = "MMK";
        final String metaValue_MNT = "MNT";
        final String metaValue_MOP = "MOP";
        final String metaValue_MRO = "MRO";
        final String metaValue_MUR = "MUR";
        final String metaValue_MVR = "MVR";
        final String metaValue_MWK = "MWK";
        final String metaValue_MYR = "MYR";
        final String metaValue_MZN = "MZN";
        final String metaValue_NAD = "NAD";
        final String metaValue_NGN = "NGN";
        final String metaValue_NIO = "NIO";
        final String metaValue_NOK = "NOK";
        final String metaValue_OMR = "OMR";
        final String metaValue_PAB = "PAB";
        final String metaValue_PEN = "PEN";
        final String metaValue_PGK = "PGK";
        final String metaValue_PHP = "PHP";
        final String metaValue_PLN = "PLN";
        final String metaValue_PYG = "PYG";
        final String metaValue_QAR = "QAR";
        final String metaValue_RON = "RON";
        final String metaValue_RSD = "RSD";
        final String metaValue_RUB = "RUB";
        final String metaValue_RWF = "RWF";
        final String metaValue_SAR = "SAR";
        final String metaValue_SBD = "SBD";
        final String metaValue_SCR = "SCR";
        final String metaValue_SDG = "SDG";
        final String metaValue_SEK = "SEK";
        final String metaValue_SGD = "SGD";
        final String metaValue_SHP = "SHP";
        final String metaValue_SLL = "SLL";
        final String metaValue_SOS = "SOS";
        final String metaValue_SRD = "SRD";
        final String metaValue_SSP = "SSP";
        final String metaValue_STD = "STD";
        final String metaValue_STN = "STN";
        final String metaValue_SYP = "SYP";
        final String metaValue_SZL = "SZL";
        final String metaValue_THB = "THB";
        final String metaValue_TJS = "TJS";
        final String metaValue_TMT = "TMT";
        final String metaValue_TND = "TND";
        final String metaValue_TOP = "TOP";
        final String metaValue_TRY = "TRY";
        final String metaValue_TTD = "TTD";
        final String metaValue_TZS = "TZS";
        final String metaValue_UAH = "UAH";
        final String metaValue_UGX = "UGX";
        final String metaValue_UYU = "UYU";
        final String metaValue_UZS = "UZS";
        final String metaValue_VEF = "VEF";
        final String metaValue_VUV = "VUV";
        final String metaValue_WST = "WST";
        final String metaValue_YER = "YER";
        final String metaValue_ZAR = "ZAR";
        final String metaValue_ZMW = "ZMW";
        final Object[][] data = new Object[][] {
            { "mwk", metaValue_MWK },
            { "FJD", metaValue_FJD },
            { "STD", metaValue_STD },
            { "SCR", metaValue_SCR },
            { "CDF", metaValue_CDF },
            { "BBD", metaValue_BBD },
            { "mga", metaValue_MGA },
            { "HNL", metaValue_HNL },
            { "UGX", metaValue_UGX },
            { "ZAR", metaValue_ZAR },
            { "STN", metaValue_STN },
            { "bam", metaValue_BAM },
            { "egp", metaValue_EGP },
            { "CUC", metaValue_CUC },
            { "ssp", metaValue_SSP },
            { "BSD", metaValue_BSD },
            { "nio", metaValue_NIO },
            { "SDG", metaValue_SDG },
            { "nzd", "NZD" },
            { "IQD", metaValue_IQD },
            { "brl", "BRL" },
            { "CUP", metaValue_CUP },
            { "GMD", metaValue_GMD },
            { "fjd", metaValue_FJD },
            { "RSD", metaValue_RSD },
            { "std", metaValue_STD },
            { "mxn", "MXN" },
            { "scr", metaValue_SCR },
            { "cdf", metaValue_CDF },
            { "bbd", metaValue_BBD },
            { "hnl", metaValue_HNL },
            { "MYR", metaValue_MYR },
            { "ugx", metaValue_UGX },
            { "FKP", metaValue_FKP },
            { "zar", metaValue_ZAR },
            { "stn", metaValue_STN },
            { "cuc", metaValue_CUC },
            { "UYU", metaValue_UYU },
            { "bsd", metaValue_BSD },
            { "CVE", metaValue_CVE },
            { "OMR", metaValue_OMR },
            { "sdg", metaValue_SDG },
            { "KES", metaValue_KES },
            { "SEK", metaValue_SEK },
            { "BTN", metaValue_BTN },
            { "iqd", metaValue_IQD },
            { "GNF", metaValue_GNF },
            { "cup", metaValue_CUP },
            { "gmd", metaValue_GMD },
            { "MZN", metaValue_MZN },
            { "twd", "TWD" },
            { "ARS", metaValue_ARS },
            { "rsd", metaValue_RSD },
            { "QAR", metaValue_QAR },
            { "myr", metaValue_MYR },
            { "IRR", metaValue_IRR },
            { "fkp", metaValue_FKP },
            { "xof", "XOF" },
            { "THB", metaValue_THB },
            { "UZS", metaValue_UZS },
            { "uyu", metaValue_UYU },
            { "BDT", metaValue_BDT },
            { "cve", metaValue_CVE },
            { "omr", metaValue_OMR },
            { "LYD", metaValue_LYD },
            { "kes", metaValue_KES },
            { "sek", metaValue_SEK },
            { "KWD", metaValue_KWD },
            { "btn", metaValue_BTN },
            { "gnf", metaValue_GNF },
            { "RUB", metaValue_RUB },
            { "ISK", metaValue_ISK },
            { "mzn", metaValue_MZN },
            { "ars", metaValue_ARS },
            { "qar", metaValue_QAR },
            { "MKD", metaValue_MKD },
            { "irr", metaValue_IRR },
            { "DZD", metaValue_DZD },
            { "thb", metaValue_THB },
            { "uzs", metaValue_UZS },
            { "xpf", "XPF" },
            { "PAB", metaValue_PAB },
            { "SGD", metaValue_SGD },
            { "bdt", metaValue_BDT },
            { "KGS", metaValue_KGS },
            { "lyd", metaValue_LYD },
            { "kwd", metaValue_KWD },
            { "rub", metaValue_RUB },
            { "CHF", metaValue_CHF },
            { "HRK", metaValue_HRK },
            { "isk", metaValue_ISK },
            { "DJF", metaValue_DJF },
            { "mkd", metaValue_MKD },
            { "TZS", metaValue_TZS },
            { "dzd", metaValue_DZD },
            { "pab", metaValue_PAB },
            { "sgd", metaValue_SGD },
            { "KHR", metaValue_KHR },
            { "IDR", metaValue_IDR },
            { "kgs", metaValue_KGS },
            { "KYD", metaValue_KYD },
            { "BWP", metaValue_BWP },
            { "SHP", metaValue_SHP },
            { "TJS", metaValue_TJS },
            { "xaf", "XAF" },
            { "AED", metaValue_AED },
            { "chf", metaValue_CHF },
            { "hrk", metaValue_HRK },
            { "RWF", metaValue_RWF },
            { "djf", metaValue_DJF },
            { "DKK", metaValue_DKK },
            { "BGN", metaValue_BGN },
            { "MMK", metaValue_MMK },
            { "NOK", metaValue_NOK },
            { "SYP", metaValue_SYP },
            { "tzs", metaValue_TZS },
            { "vnd", "VND" },
            { "aud", "AUD" },
            { "LKR", metaValue_LKR },
            { "khr", metaValue_KHR },
            { "CZK", metaValue_CZK },
            { "idr", metaValue_IDR },
            { "kyd", metaValue_KYD },
            { "bwp", metaValue_BWP },
            { "HTG", metaValue_HTG },
            { "shp", metaValue_SHP },
            { "tjs", metaValue_TJS },
            { "BHD", metaValue_BHD },
            { "rwf", metaValue_RWF },
            { "aed", metaValue_AED },
            { "KZT", metaValue_KZT },
            { "SZL", metaValue_SZL },
            { "dkk", metaValue_DKK },
            { "YER", metaValue_YER },
            { "bgn", metaValue_BGN },
            { "AFN", "\u060b" },
            { "mmk", metaValue_MMK },
            { "nok", metaValue_NOK },
            { "syp", metaValue_SYP },
            { "AWG", metaValue_AWG },
            { "NPR", "NPR" },
            { "lkr", metaValue_LKR },
            { "MNT", metaValue_MNT },
            { "czk", metaValue_CZK },
            { "BYN", metaValue_BYN },
            { "HUF", metaValue_HUF },
            { "xcd", "XCD" },
            { "htg", metaValue_HTG },
            { "afa", "\u0627\u0641\u063a\u0627\u0646\u06cd (1927\u20132002)" },
            { "BIF", metaValue_BIF },
            { "bhd", metaValue_BHD },
            { "kzt", metaValue_KZT },
            { "szl", metaValue_SZL },
            { "yer", metaValue_YER },
            { "afn", "\u0627\u0641\u063a\u0627\u0646\u06cd" },
            { "BZD", metaValue_BZD },
            { "MOP", metaValue_MOP },
            { "awg", metaValue_AWG },
            { "NAD", metaValue_NAD },
            { "npr", "\u0646\u064a\u067e\u0627\u0644\u064a \u0631\u0648\u067e\u064a\u0647" },
            { "mnt", metaValue_MNT },
            { "gbp", "GBP" },
            { "byn", metaValue_BYN },
            { "huf", metaValue_HUF },
            { "PEN", metaValue_PEN },
            { "WST", metaValue_WST },
            { "TMT", metaValue_TMT },
            { "bif", metaValue_BIF },
            { "GTQ", metaValue_GTQ },
            { "CLP", metaValue_CLP },
            { "TND", metaValue_TND },
            { "bzd", metaValue_BZD },
            { "mop", metaValue_MOP },
            { "nad", metaValue_NAD },
            { "SLL", metaValue_SLL },
            { "pen", metaValue_PEN },
            { "wst", metaValue_WST },
            { "tmt", metaValue_TMT },
            { "DOP", metaValue_DOP },
            { "gtq", metaValue_GTQ },
            { "KMF", metaValue_KMF },
            { "clp", metaValue_CLP },
            { "tnd", metaValue_TND },
            { "GEL", metaValue_GEL },
            { "MAD", metaValue_MAD },
            { "sll", metaValue_SLL },
            { "TOP", metaValue_TOP },
            { "AZN", metaValue_AZN },
            { "PGK", metaValue_PGK },
            { "CNH", metaValue_CNH },
            { "UAH", metaValue_UAH },
            { "ERN", metaValue_ERN },
            { "dop", metaValue_DOP },
            { "kmf", metaValue_KMF },
            { "MRO", metaValue_MRO },
            { "gel", metaValue_GEL },
            { "mad", metaValue_MAD },
            { "azn", metaValue_AZN },
            { "top", metaValue_TOP },
            { "pgk", metaValue_PGK },
            { "BMD", metaValue_BMD },
            { "PHP", metaValue_PHP },
            { "cnh", metaValue_CNH },
            { "uah", metaValue_UAH },
            { "PYG", metaValue_PYG },
            { "ern", metaValue_ERN },
            { "JMD", metaValue_JMD },
            { "COP", metaValue_COP },
            { "mro", metaValue_MRO },
            { "cny", "CNY" },
            { "mru", "MRU" },
            { "ETB", metaValue_ETB },
            { "SOS", metaValue_SOS },
            { "VEF", metaValue_VEF },
            { "VUV", metaValue_VUV },
            { "LAK", metaValue_LAK },
            { "bmd", metaValue_BMD },
            { "BND", metaValue_BND },
            { "php", metaValue_PHP },
            { "xxx", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645 \u062f \u0627\u0633\u0639\u0627\u0631\u0648 \u0644\u0647" },
            { "LRD", metaValue_LRD },
            { "pyg", metaValue_PYG },
            { "jmd", metaValue_JMD },
            { "ALL", metaValue_ALL },
            { "cop", metaValue_COP },
            { "ZMW", metaValue_ZMW },
            { "usd", "USD" },
            { "etb", metaValue_ETB },
            { "GHS", metaValue_GHS },
            { "GYD", metaValue_GYD },
            { "KPW", metaValue_KPW },
            { "BOB", metaValue_BOB },
            { "MDL", metaValue_MDL },
            { "sos", metaValue_SOS },
            { "vef", metaValue_VEF },
            { "vuv", metaValue_VUV },
            { "lak", metaValue_LAK },
            { "AMD", metaValue_AMD },
            { "bnd", metaValue_BND },
            { "TRY", metaValue_TRY },
            { "LBP", metaValue_LBP },
            { "JOD", metaValue_JOD },
            { "lrd", metaValue_LRD },
            { "all", metaValue_ALL },
            { "zmw", metaValue_ZMW },
            { "MUR", metaValue_MUR },
            { "GIP", metaValue_GIP },
            { "RON", metaValue_RON },
            { "ils", "ILS" },
            { "ghs", metaValue_GHS },
            { "gyd", metaValue_GYD },
            { "kpw", metaValue_KPW },
            { "bob", metaValue_BOB },
            { "mdl", metaValue_MDL },
            { "NGN", metaValue_NGN },
            { "CRC", metaValue_CRC },
            { "PKR", "PKR" },
            { "amd", metaValue_AMD },
            { "ANG", metaValue_ANG },
            { "try", metaValue_TRY },
            { "lbp", metaValue_LBP },
            { "jod", metaValue_JOD },
            { "hkd", "HKD" },
            { "eur", "EUR" },
            { "SRD", metaValue_SRD },
            { "SAR", metaValue_SAR },
            { "TTD", metaValue_TTD },
            { "cad", "CAD" },
            { "MVR", metaValue_MVR },
            { "mur", metaValue_MUR },
            { "gip", metaValue_GIP },
            { "ron", metaValue_RON },
            { "AOA", metaValue_AOA },
            { "PLN", metaValue_PLN },
            { "ngn", metaValue_NGN },
            { "SBD", metaValue_SBD },
            { "crc", metaValue_CRC },
            { "pkr", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646\u06cd \u06a9\u0644\u062f\u0627\u0631\u0647" },
            { "ang", metaValue_ANG },
            { "MWK", metaValue_MWK },
            { "srd", metaValue_SRD },
            { "sar", metaValue_SAR },
            { "ttd", metaValue_TTD },
            { "MGA", metaValue_MGA },
            { "mvr", metaValue_MVR },
            { "inr", "INR" },
            { "BAM", metaValue_BAM },
            { "EGP", metaValue_EGP },
            { "SSP", metaValue_SSP },
            { "krw", "KRW" },
            { "aoa", metaValue_AOA },
            { "jpy", "JPY" },
            { "pln", metaValue_PLN },
            { "sbd", metaValue_SBD },
            { "NIO", metaValue_NIO },
        };
        return data;
    }
}
