/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_as extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u09a8\u09be\u0989\u09f0\u09c1";
        final String metaValue_TV = "\u099f\u09c1\u09ad\u09be\u09b2\u09c1";
        final String metaValue_ar = "\u0986\u09f0\u09ac\u09c0";
        final String metaValue_bn = "\u09ac\u09be\u0982\u09b2\u09be";
        final String metaValue_bo = "\u09a4\u09bf\u09ac\u09cd\u09ac\u09a4\u09c0";
        final String metaValue_el = "\u0997\u09cd\u09f0\u09c0\u0995";
        final String metaValue_gu = "\u0997\u09c1\u099c\u09f0\u09be\u099f\u09c0";
        final String metaValue_he = "\u09b9\u09bf\u09ac\u09cd\u09f0\u09c1";
        final String metaValue_hy = "\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc";
        final String metaValue_ja = "\u099c\u09be\u09aa\u09be\u09a8\u09c0";
        final String metaValue_ka = "\u099c\u09f0\u09cd\u099c\u09bf\u09af\u09bc\u09be\u09a8";
        final String metaValue_km = "\u0996\u09ae\u09c7\u09f0";
        final String metaValue_kn = "\u0995\u09be\u09a8\u09be\u09a1\u09bc\u09be";
        final String metaValue_ko = "\u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be\u09a8";
        final String metaValue_la = "\u09b2\u09c7\u099f\u09bf\u09a8";
        final String metaValue_lo = "\u09b2\u09be\u0993";
        final String metaValue_ml = "\u09ae\u09be\u09b2\u09be\u09af\u09bc\u09be\u09b2\u09ae";
        final String metaValue_or = "\u0993\u09a1\u09bc\u09bf\u09af\u09bc\u09be";
        final String metaValue_ta = "\u09a4\u09be\u09ae\u09bf\u09b2";
        final String metaValue_te = "\u09a4\u09c7\u09b2\u09c1\u0997\u09c1";
        final String metaValue_th = "\u09a5\u09be\u0987";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0995\u09cb\u09b2\u09cb\u0997\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "mwl", "\u09ae\u09bf\u09f0\u09be\u09a3\u09cd\u09a1\u09bf\u099c" },
            { "Zsym", "\u09aa\u09cd\u09f0\u09a4\u09c0\u0995" },
            { "Zsye", "\u0987\u09ae\u2019\u099c\u09bf" },
            { "tem", "\u099f\u09bf\u09ae\u09cd\u09a8\u09c7" },
            { "teo", "\u09a4\u09c7\u099b\u09cb" },
            { "rap", "\u09f0\u09be\u09aa\u09be\u09a8\u09c1\u0987" },
            { "AC", "\u098f\u099a\u09c7\u09a8\u099a\u09bf\u09af\u09bc\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "rar", "\u09f0\u09be\u09f0\u09cb\u09a4\u09cb\u0999\u09cd\u0997\u09a8" },
            { "tet", "\u09a4\u09c7\u09a4\u09c1\u09ae" },
            { "AD", "\u0986\u09a8\u09cd\u09a6\u09cb\u09f0\u09be" },
            { "AE", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0986\u09f0\u09ac \u0986\u09ae\u09bf\u09f0\u09be\u09a4" },
            { "nl_BE", "\u09ab\u09cd\u09b2\u09c7\u09ae\u09bf\u099a" },
            { "AF", "\u0986\u09ab\u0997\u09be\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "AG", "\u098f\u09a3\u09cd\u099f\u09bf\u0997\u09c1\u09f1\u09be \u0986\u09f0\u09c1 \u09ac\u09be\u09f0\u09cd\u09ac\u09c1\u09a1\u09be" },
            { "type.ca.ethiopic", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u0995 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "AI", "\u098f\u09a8\u0997\u09c1\u0987\u09b2\u09be" },
            { "AL", "\u0986\u09b2\u09ac\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "AM", "\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "AO", "\u098f\u0982\u0997\u09cb\u09b2\u09be" },
            { "AQ", "\u098f\u09a3\u09cd\u099f\u09be\u09f0\u09cd\u0995\u099f\u09bf\u0995\u09be" },
            { "AR", "\u0986\u09f0\u09cd\u099c\u09c7\u09a3\u09cd\u099f\u09bf\u09a8\u09be" },
            { "AS", "\u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be\u09a8 \u099a\u09be\u09ae\u09cb\u09f1\u09be" },
            { "AT", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09bf\u09af\u09bc\u09be" },
            { "AU", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be" },
            { "AW", "\u0986\u09f0\u09c1\u09ac\u09be" },
            { "en_US", "\u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be\u09a8 \u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "AX", "\u0986\u09b2\u09a3\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "AZ", "\u0986\u099c\u09be\u09f0\u09ac\u09c7\u0987\u099c\u09be\u09a8" },
            { "BA", "\u09ac\u2019\u099b\u09a8\u09bf\u09af\u09bc\u09be \u0986\u09f0\u09c1 \u09b9\u09be\u09f0\u09cd\u099c\u09c7\u0997\u2019\u09ad\u09bf\u09a8\u09be" },
            { "BB", "\u09ac\u09be\u09f0\u09cd\u09ac\u09be\u09a1\u09cb\u099a" },
            { "ceb", "\u099a\u09bf\u09ac\u09c1\u09f1\u09be\u09a8\u09cb" },
            { "BD", "\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6" },
            { "kum", "\u0995\u09c1\u09ae\u09bf\u0995" },
            { "BE", "\u09ac\u09c7\u09b2\u099c\u09bf\u09af\u09bc\u09be\u09ae" },
            { "BF", "\u09ac\u09c1\u09f0\u0995\u09bf\u09a8\u09be \u09ab\u09be\u099a\u09cb" },
            { "BG", "\u09ac\u09c1\u09b2\u0997\u09c7\u09f0\u09bf\u09af\u09bc\u09be" },
            { "BH", "\u09ac\u09be\u09b9\u09f0\u09c7\u0987\u09a8" },
            { "BI", "\u09ac\u09c1\u09f0\u09c1\u09a3\u09cd\u09a1\u09bf" },
            { "BJ", "\u09ac\u09c7\u09a8\u09bf\u09a8" },
            { "BL", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09ac\u09be\u09f0\u09cd\u09a5\u09b2\u09c7\u09ae\u09c7" },
            { "BM", "\u09ac\u09be\u09f0\u09cd\u09ae\u09c1\u09a1\u09be" },
            { "myv", "\u098f\u09f0\u099c\u09bf\u09af\u09bc\u09be" },
            { "BN", "\u09ac\u09cd\u09f0\u09c1\u09a8\u09c7\u0987" },
            { "BO", "\u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be" },
            { "BQ", "\u0995\u09c7\u09f0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09c7\u09a6\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1\u099b" },
            { "BR", "\u09ac\u09cd\u09f0\u09be\u099c\u09bf\u09b2" },
            { "BS", "\u09ac\u09be\u09b9\u09be\u09ae\u09be\u099b" },
            { "xog", "\u099b\u09cb\u0997\u09be" },
            { "BT", "\u09ad\u09c1\u099f\u09be\u09a8" },
            { "BV", "\u09ac\u09c1\u09ad\u09c7 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "BW", "\u09ac\u2019\u099f\u099a\u09cb\u09f1\u09be\u09a8\u09be" },
            { "BY", "\u09ac\u09c7\u09b2\u09be\u09f0\u09c1\u099b" },
            { "BZ", "\u09ac\u09c7\u09b2\u09bf\u099c" },
            { "type.ca.persian", "\u09ab\u09be\u09f0\u09cd\u099a\u09c0 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "type.nu.hebr", "\u09b9\u09bf\u09ac\u09cd\u09f0\u09c1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "CA", "\u0995\u09be\u09a8\u09be\u09a1\u09be" },
            { "CC", "\u0995\u09cb\u0995\u09cb\u099a (\u0995\u09c0\u09b2\u09bf\u0982) \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "mzn", "\u09ae\u09be\u099c\u09c7\u09a8\u09cd\u09a6\u09be\u09f0\u09be\u09a8\u09bf" },
            { "CD", "\u0995\u0999\u09cd\u0997\u09cb - \u0995\u09bf\u09a8\u099a\u09be\u099b\u09be" },
            { "CF", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09a8 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0" },
            { "CG", "\u0995\u0999\u09cd\u0997\u09cb - \u09ac\u09cd\u09b0\u09be\u099c\u09be\u09ad\u09bf\u09b2" },
            { "CH", "\u099a\u09c1\u0987\u099c\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "CI", "\u0995\u09cb\u099f\u09c7 \u09a1\u09bf \u0986\u0987\u09ad\u09f0" },
            { "CK", "\u0995\u09c1\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "CL", "\u099a\u09bf\u09b2\u09bf" },
            { "CM", "\u0995\u09c7\u09ae\u09c7\u09f0\u09c1\u09a3" },
            { "CN", "\u099a\u09c0\u09a8" },
            { "CO", "\u0995\u09b2\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "CP", "\u0995\u09cd\u09b2\u09bf\u09aa\u09be\u09f0\u099f\u09cb\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "CR", "\u0995\u09cb\u09b7\u09cd\u099f\u09be \u09f0\u09bf\u0995\u09be" },
            { "CU", "\u0995\u09bf\u0989\u09ac\u09be" },
            { "CV", "\u0995\u09c7\u09aa \u09ad\u09be\u09b0\u09cd\u09a6\u09c7" },
            { "CW", "\u0995\u09c1\u09f0\u09be\u0995\u09be\u0993" },
            { "CX", "\u0996\u09cd\u09f0\u09c0\u09b7\u09cd\u099f\u09ae\u09be\u099b \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "CY", "\u099a\u09be\u0987\u09aa\u09cd\u09f0\u09be\u099b" },
            { "CZ", "\u099a\u09bf\u099c\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "eka", "\u098f\u0995\u09be\u099c\u09c1\u0995" },
            { "DE", "\u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8\u09c0" },
            { "ace", "\u0986\u099a\u09bf\u09a8\u09bf\u099c" },
            { "cgg", "\u099a\u09bf\u0997\u09be" },
            { "DG", "\u09a1\u09bf\u09af\u09bc\u09c7\u0997\u09cb \u0997\u09be\u09f0\u09cd\u099a\u09bf\u09af\u09bc\u09be" },
            { "type.nu.deva", "\u09a6\u09c7\u09f1\u09a8\u09be\u0997\u09f0\u09c0 \u0985\u0982\u0995" },
            { "DJ", "\u099c\u09bf\u09ac\u09c1\u099f\u09bf" },
            { "DK", "\u09a1\u09c7\u09a8\u09ae\u09be\u09f0\u09cd\u0995" },
            { "Brai", "\u09ac\u09cd\u09f0\u09c7\u0987\u09b2" },
            { "DM", "\u09a1\u2019\u09ae\u09bf\u09a8\u09bf\u0995\u09be" },
            { "type.nu.armnlow", "\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc \u09b8\u09f0\u09c1\u09ab\u09b2\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "DO", "\u09a1\u2019\u09ae\u09bf\u09a8\u09bf\u0995\u09be\u09a8 \u09f0\u09bf\u09aa\u09be\u09ac\u09cd\u09b2\u09bf\u0995" },
            { "gor", "\u0997\u09cb\u09f0\u09cb\u09a8\u09cd\u09a4\u09be\u09b2\u09cb" },
            { "zun", "\u099d\u09c1\u09a8\u09bf" },
            { "tig", "\u09a4\u09be\u0987\u0997\u09cd\u09f0\u09c7" },
            { "DZ", "\u0986\u09b2\u099c\u09c7\u09f0\u09bf\u09af\u09bc\u09be" },
            { "pag", "\u09aa\u0982\u0997\u09be\u099b\u09bf\u09a8\u09be\u09a8" },
            { "EA", "\u099a\u09c7\u0989\u099f\u09be \u0986\u09f0\u09c1 \u09ae\u09c7\u09b2\u09bf\u09b2\u09be" },
            { "pam", "\u09aa\u09be\u09ae\u09cd\u09aa\u09be\u09a8\u09cd\u0997\u09be" },
            { "EC", "\u0987\u0995\u09c1\u09f1\u09c7\u09a1\u09f0" },
            { "pap", "\u09aa\u09be\u09aa\u09bf\u09af\u09bc\u09be\u09ae\u09c7\u09a3\u09cd\u099f\u09cb" },
            { "ada", "\u0986\u09a6\u09be\u0982\u09ae\u09c7" },
            { "EE", "\u0987\u09b7\u09cd\u099f\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "EG", "\u0987\u099c\u09bf\u09aa\u09cd\u09a4" },
            { "EH", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae\u09c0\u09af\u09bc \u099b\u09be\u09b9\u09be\u09f0\u09be" },
            { "pau", "\u09aa\u09be\u09b2\u09be\u0989\u09f1\u09be\u09a8" },
            { "chk", "\u099a\u09c1\u0995\u09bf\u099c" },
            { "chm", "\u09ae\u09be\u09f0\u09bf" },
            { "cho", "\u099a\u09cb\u0995\u09cd\u099f\u09be\u0989" },
            { "chr", "\u099a\u09c7\u09f0\u09cb\u0995\u09bf" },
            { "ER", "\u098f\u09f0\u09bf\u09a4\u09cd\u09f0\u09bf\u09af\u09bc\u09be" },
            { "ES", "\u09b8\u09cd\u09aa\u09c7\u0987\u09a8" },
            { "ET", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u09af\u09bc\u09be" },
            { "EU", "\u0987\u0989\u09f0\u09cb\u09aa\u09c0\u09af\u09bc \u09b8\u0982\u0998" },
            { "type.ca.gregorian", "\u0997\u09cd\u09f0\u09c7\u0997\u09cb\u09f0\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "EZ", "\u0987\u0989\u09f0\u09cb\u099c\u2019\u09a8" },
            { "chy", "\u099a\u09be\u0987\u09af\u09bc\u09c7\u09a8" },
            { "type.nu.gujr", "\u0997\u09c1\u099c\u09f0\u09be\u099f\u09c0 \u0985\u0982\u0995" },
            { "ady", "\u0986\u09a6\u09bf\u0997\u09c7" },
            { "FI", "\u09ab\u09bf\u09a8\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "FJ", "\u09ab\u09bf\u099c\u09bf" },
            { "FK", "\u09ab\u0995\u09b2\u09c7\u09a3\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "FM", "\u09ae\u09be\u0987\u0995\u09cd\u09f0\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "FO", "\u09ab\u09be\u09f0\u09cb \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "Taml", metaValue_ta },
            { "FR", "\u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8" },
            { "root", "\u09f0\u09c1\u099f" },
            { "type.ca.indian", "\u09ad\u09be\u09f0\u09a4\u09c0\u09af\u09bc \u09f0\u09be\u09b7\u09cd\u099f\u09cd\u09f0\u09c0\u09af\u09bc \u09aa\u099e\u09cd\u099c\u09bf\u0995\u09be" },
            { "GA", "\u0997\u09c7\u09ac\u09a8" },
            { "GB", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u09f0\u09be\u099c\u09cd\u09af" },
            { "pcm", "\u09a8\u09be\u0987\u099c\u09c7\u09f0\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09bf\u099c\u09bf\u09a8" },
            { "GD", "\u0997\u09cd\u09f0\u09c7\u09a8\u09be\u09a1\u09be" },
            { "GE", "\u099c\u09f0\u09cd\u099c\u09bf\u09af\u09bc\u09be" },
            { "GF", "\u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8 \u0997\u09af\u09bc\u09be\u09a8\u09be" },
            { "GG", "\u0997\u09cb\u09f0\u09c7\u09a8\u099a\u09bf" },
            { "GH", "\u0998\u09be\u09a8\u09be" },
            { "GI", "\u099c\u09bf\u09ac\u09cd\u09f0\u09be\u09b2\u09cd\u099f\u09f0" },
            { "GL", "\u0997\u09cd\u09f0\u09c0\u09a3\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "GM", "\u0997\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "GN", "\u0997\u09bf\u09a8\u09bf" },
            { "GP", "\u0997\u09c1\u09f1\u09be\u09a1\u09c7\u09b2\u09c1\u09aa" },
            { "GQ", "\u0987\u0995\u09c1\u09f1\u09c7\u099f\u09f0\u09bf\u09af\u09bc\u09c7\u09b2 \u0997\u09bf\u09a8\u09bf" },
            { "GR", "\u0997\u09cd\u09f0\u09c0\u099a" },
            { "GS", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099c\u09f0\u09cd\u099c\u09bf\u09af\u09bc\u09be \u0986\u09f0\u09c1 \u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099a\u09c7\u09a3\u09cd\u09a1\u09f1\u09bf\u099a \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "GT", "\u0997\u09c1\u09f1\u09be\u099f\u09c7\u09ae\u09be\u09b2\u09be" },
            { "GU", "\u0997\u09c1\u09f1\u09be\u09ae" },
            { "GW", "\u0997\u09bf\u09a8\u09bf-\u09ac\u09bf\u099b\u09be\u0993" },
            { "tlh", "\u0995\u09cd\u09b2\u09bf\u0982\u0997\u09a8" },
            { "GY", "\u0997\u09be\u09af\u09bc\u09be\u09a8\u09be" },
            { "ckb", "\u099a\u09c7\u09a3\u09cd\u099f\u09cd\u09f0\u09c7\u09b2 \u0995\u09c1\u09f0\u09cd\u09a1\u09bf\u099a" },
            { "zxx", "\u0995\u09cb\u09a8\u09cb \u09ad\u09be\u09b7\u09be \u09b8\u09ae\u09b2 \u09a8\u09be\u0987" },
            { "de_AT", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8" },
            { "HK", "\u09b9\u0982 \u0995\u0982 \u098f\u099b. \u098f. \u0986\u09f0. \u099a\u09c0\u09a8" },
            { "HM", "\u09b9\u09be\u09f0\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa \u0986\u09f0\u09c1 \u09ae\u09c7\u0995\u09a1\u09cb\u09a8\u09be\u09b2\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "HN", "\u09b9\u09a8\u09cd\u09a6\u09c1\u09f0\u09be\u099b" },
            { "HR", "\u0995\u09cd\u09f0\u09cb\u09f1\u09c7\u099b\u09bf\u09af\u09bc\u09be" },
            { "agq", "\u0986\u0998\u09c7\u09ae" },
            { "gsw", "\u099b\u09c1\u0987\u099a \u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8" },
            { "HT", "\u09b9\u09be\u0987\u099f\u09bf" },
            { "HU", "\u09b9\u09be\u0982\u0997\u09c7\u09f0\u09c0" },
            { "IC", "\u0995\u09c7\u09a8\u09c7\u09f0\u09c0 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "ID", "\u0987\u09a3\u09cd\u09a1\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "IE", "\u0986\u09af\u09bc\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "nap", "\u09a8\u09bf\u09af\u09bc\u09be\u09aa\u09cb\u09b2\u09bf\u099f\u09c7\u09a8" },
            { "naq", "\u09a8\u09be\u09ae\u09be" },
            { "zza", "\u099d\u09be\u099d\u09be" },
            { "IL", "\u0987\u099c\u09f0\u09be\u0987\u09b2" },
            { "IM", "\u0986\u0987\u09b2 \u0985\u09ab \u09ae\u09c7\u09a8" },
            { "IN", "\u09ad\u09be\u09f0\u09a4" },
            { "IO", "\u09ac\u09cd\u09f0\u09bf\u099f\u09bf\u099b \u0987\u09a3\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u0985\u2019\u099a\u09a8 \u099f\u09c7\u09f0\u09bf\u099f\u2019\u09f0\u09bf" },
            { "IQ", "\u0987\u09f0\u09be\u0995" },
            { "IR", "\u0987\u09f0\u09be\u09a8" },
            { "IS", "\u0986\u0987\u099a\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "IT", "\u0987\u099f\u09be\u09b2\u09bf" },
            { "Zmth", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u099a\u09bf\u09b9\u09cd\u09a8" },
            { "type.nu.thai", "\u09a5\u09be\u0987 \u0985\u0982\u0995" },
            { "type.nu.beng", "\u09ac\u09be\u0982\u09b2\u09be \u0985\u0982\u0995" },
            { "JE", "\u099c\u09be\u09f0\u09cd\u099a\u09bf" },
            { "type.ca.islamic", "\u0987\u099b\u09b2\u09be\u09ae\u09c0 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "Beng", metaValue_bn },
            { "JM", "\u099c\u09be\u09ae\u09be\u0987\u0995\u09be" },
            { "JO", "\u099c\u09f0\u09cd\u09a1\u09be\u09a8" },
            { "JP", "\u099c\u09be\u09aa\u09be\u09a8" },
            { "ain", "\u0986\u0987\u09a8\u09c1" },
            { "guz", "\u0997\u09c1\u099b\u09bf" },
            { "type.nu.knda", "\u0995\u09be\u09a8\u09be\u09a1\u09bc\u09be \u0985\u0982\u0995" },
            { "de_CH", "\u099b\u09c1\u0987\u099a \u09b9\u09be\u0987 \u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8" },
            { "type.ca.buddhist", "\u09ac\u09cc\u09a6\u09cd\u09a7 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "KE", "\u0995\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "419", "\u09b2\u09c7\u099f\u09bf\u09a8 \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "KG", "\u0995\u09bf\u09f0\u09cd\u0997\u09bf\u099c\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "KH", "\u0995\u09ae\u09cd\u09ac\u09cb\u09a1\u09bf\u09af\u09bc\u09be" },
            { "KI", "\u0995\u09bf\u09f0\u09bf\u09ac\u09be\u099f\u09bf" },
            { "KM", "\u0995\u09cb\u09ae\u09cb\u09f0\u09cb\u099c" },
            { "Knda", metaValue_kn },
            { "KN", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u0995\u09bf\u099f\u099b \u0986\u09f0\u09c1 \u09a8\u09c7\u09ad\u09bf\u099b" },
            { "fr_CA", "\u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u09ab\u09cd\u09f0\u09c7\u09a8\u09cd\u09b8" },
            { "KP", "\u0989\u09a4\u09cd\u09a4\u09f0 \u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be" },
            { "KR", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be" },
            { "fr_CH", "\u099b\u09c1\u0987\u099a \u09ab\u09cd\u09f0\u09c7\u09a8\u09cd\u09b8" },
            { "KW", "\u0995\u09c1\u09f1\u09c7\u0987\u099f" },
            { "tpi", "\u099f\u09cb\u0995 \u09aa\u09bf\u099b\u09bf\u09a8" },
            { "KY", "\u0995\u09c7\u0987\u09ae\u09c7\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "KZ", "\u0995\u09be\u099c\u09be\u0996\u09be\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "Cyrl", "\u099a\u09bf\u09f0\u09bf\u09b2\u09bf\u0995" },
            { "LA", "\u09b2\u09be\u0993\u099a" },
            { "LB", "\u09b2\u09c7\u09ac\u09be\u09a8\u09a8" },
            { "LC", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09b2\u09c1\u099a\u09bf\u09af\u09bc\u09be" },
            { "gwi", "\u099c\u09bf\u0989\u0987\u099a\u09bf\u09a8" },
            { "LI", "\u09b2\u09bf\u099a\u099f\u09c7\u09a8\u09b7\u09cd\u099f\u09c7\u0987\u09a8" },
            { "LK", "\u09b6\u09cd\u09b0\u09c0\u09b2\u0982\u0995\u09be" },
            { "LR", "\u09b2\u09bf\u09ac\u09c7\u09f0\u09bf\u09af\u09bc\u09be" },
            { "LS", "\u09b2\u09c7\u099b\u2019\u09a5\u2019" },
            { "LT", "\u09b2\u09bf\u09a5\u09c1\u09f1\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "LU", "\u09b2\u09be\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09f0\u09cd\u0997" },
            { "LV", "\u09b2\u09be\u099f\u09ad\u09bf\u09af\u09bc\u09be" },
            { "Kana", "\u0995\u09be\u099f\u09be\u0995\u09be\u09a8\u09be" },
            { "LY", "\u09b2\u09bf\u09ac\u09bf\u09af\u09bc\u09be" },
            { "lad", "\u09b2\u09be\u09a1\u09bf\u09a8\u09cb" },
            { "vun", "\u09ad\u09c1\u099e\u09cd\u099c\u09c1" },
            { "lag", "\u09b2\u09be\u0982\u0997\u09bf" },
            { "Thaa", "\u09a5\u09be\u09a8\u09be" },
            { "MA", "\u09ae\u09f0\u0995\u09cd\u0995\u09cb" },
            { "MC", "\u09ae\u09cb\u09a8\u09be\u0995\u09cb" },
            { "MD", "\u09ae\u09cb\u09b2\u09a1\u09cb\u09ad\u09be" },
            { "ME", "\u09ae\u09a3\u09cd\u099f\u09c7\u09a8\u09c7\u0997\u09cd\u09f0\u09c1" },
            { "MF", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09ae\u09be\u09f0\u09cd\u099f\u09bf\u09a8" },
            { "MG", "\u09ae\u09be\u09a6\u09be\u0997\u09be\u09b8\u09cd\u0995\u09be\u09f0" },
            { "Thai", metaValue_th },
            { "MH", "\u09ae\u09be\u09f0\u09cd\u09b6\u09cd\u09ac\u09be\u09b2 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "ale", "\u0986\u09b2\u09c7\u0989\u099f" },
            { "MK", "\u09ae\u09c7\u099a\u09bf\u09a1\u09cb\u09a8\u09c0\u09af\u09bc\u09be" },
            { "ML", "\u09ae\u09be\u09b2\u09bf" },
            { "MM", "\u09ae\u09cd\u09af\u09be\u09a8\u09ae\u09be\u09f0 (\u09ac\u09be\u09f0\u09cd\u09ae\u09be)" },
            { "MN", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc\u09be" },
            { "new", "\u09a8\u09c7\u09f1\u09be\u09f0\u09bf" },
            { "MO", "\u09ae\u09be\u0995\u09be\u0989 \u098f\u099b. \u098f. \u0986\u09f0. \u099a\u09c0\u09a8" },
            { "MP", "\u0989\u09a4\u09cd\u09a4\u09f0 \u09ae\u09be\u09f0\u09bf\u09af\u09bc\u09be\u09a8\u09be \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "MQ", "\u09ae\u09be\u09f0\u09cd\u099f\u09bf\u09a8\u09bf\u0995" },
            { "MR", "\u09ae\u09be\u0989\u09f0\u09bf\u099f\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "MS", "\u09ae\u2019\u09a3\u09cd\u099f\u099b\u09c7\u09f0\u09be\u099f" },
            { "MT", "\u09ae\u09be\u09b2\u09cd\u099f\u09be" },
            { "MU", "\u09ae\u09f0\u09bf\u099b\u09be\u099b" },
            { "alt", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u0986\u09b2\u09cd\u099f\u09be\u0987" },
            { "MV", "\u09ae\u09be\u09b2\u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "MW", "\u09ae\u09be\u09b2\u09be\u09f1\u09bf" },
            { "MX", "\u09ae\u09c7\u0995\u09cd\u09b8\u09bf\u0995\u09cb" },
            { "type.ca.japanese", "\u099c\u09be\u09aa\u09be\u09a8\u09c0 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "MY", "\u09ae\u09be\u09b2\u09af\u09bc\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "MZ", "\u09ae\u2019\u099c\u09be\u09ae\u09ac\u09bf\u0995" },
            { "NA", "\u09a8\u09be\u09ae\u09bf\u09ac\u09bf\u09af\u09bc\u09be" },
            { "202", "\u0989\u09aa-\u099b\u09be\u09b9\u09be\u09f0\u09be\u09a8 \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "type.ca.hebrew", "\u09b9\u09bf\u09ac\u09cd\u09f0\u09c1 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "NC", "\u09a8\u09bf\u0989 \u0995\u09c7\u09b2\u09bf\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "NE", "\u09a8\u09be\u0987\u099c\u09be\u09f0" },
            { "NF", "\u09a8\u2019\u09f0\u09ab\u2019\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "NG", "\u09a8\u09be\u0987\u099c\u09c7\u09f0\u09bf\u09af\u09bc\u09be" },
            { "trv", "\u09a4\u09be\u09f0\u09cb\u0995\u09cb" },
            { "NI", "\u09a8\u09bf\u0995\u09be\u09f0\u09be\u0997\u09c1\u09f1\u09be" },
            { "NL", "\u09a8\u09c7\u09a1\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "NO", "\u09a8\u09f0\u09f1\u09c7" },
            { "NP", "\u09a8\u09c7\u09aa\u09be\u09b2" },
            { "NR", metaValue_NR },
            { "NU", "\u09a8\u09bf\u0989" },
            { "rof", "\u09f0\u09cb\u09ae\u09cd\u09ac\u09cb" },
            { "NZ", "\u09a8\u09bf\u0989\u099c\u09bf\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "OM", "\u0993\u09ae\u09be\u09a8" },
            { "anp", "\u0986\u0999\u09cd\u0997\u09bf\u0995\u09be" },
            { "crs", "\u099b\u09c7\u099b\u09c7\u09b2\u09f1\u09be \u0995\u09cd\u09f0\u09bf\u0993\u09b2 \u09ab\u09cd\u09f0\u09c7\u09a8\u09cd\u09b8" },
            { "PA", "\u09aa\u09be\u09a8\u09be\u09ae\u09be" },
            { "type.ca.islamic-civil", "\u0987\u099a\u09b2\u09be\u09ae\u09c0-\u09a8\u09be\u0997\u09f0\u09bf\u0995\u09f0 \u09aa\u099e\u09cd\u099c\u09bf\u0995\u09be" },
            { "en_GB", "\u09ac\u09cd\u09f0\u09bf\u099f\u09bf\u099b \u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "PE", "\u09aa\u09c7\u09f0\u09c1" },
            { "PF", "\u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8 \u09aa\u09cb\u09b2\u09c7\u09a8\u099a\u09bf\u09af\u09bc\u09be" },
            { "PG", "\u09aa\u09be\u09aa\u09c1\u09f1\u09be \u09a8\u09bf\u0989 \u0997\u09bf\u09a8\u09bf" },
            { "PH", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09be\u0987\u09a8\u099b" },
            { "PK", "\u09aa\u09be\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "PL", "\u09aa\u09cb\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "ewo", "\u0987\u0993\u09a8\u09cd\u09a6\u09cb" },
            { "PM", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09aa\u09bf\u09af\u09bc\u09c7\u09f0\u09c7 \u0986\u09f0\u09c1 \u09ae\u09bf\u0995\u09bf\u0989\u09f1\u09c7\u09b2\u09a8" },
            { "PN", "\u09aa\u09bf\u099f\u0995\u09c7\u0987\u09f0\u09cd\u09a3 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "PR", "\u09aa\u09c1\u09f1\u09c7\u09f0\u09cd\u099f\u09cb \u09f0\u09bf\u0995\u09cb" },
            { "PS", "\u09ab\u09bf\u09b2\u09bf\u09b8\u09cd\u09a4\u09bf\u09a8 \u0985\u099e\u09cd\u099a\u09b2" },
            { "PT", "\u09aa\u09f0\u09cd\u09a4\u09c1\u0997\u09be\u09b2" },
            { "PW", "\u09aa\u09be\u09b2\u09be\u0989" },
            { "nia", "\u09a8\u09bf\u09af\u09bc\u09be\u099b" },
            { "type.nu.greklow", "\u0997\u09cd\u09f0\u09c0\u0995 \u09b8\u09f0\u09c1\u09ab\u09b2\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "PY", "\u09aa\u09be\u09f0\u09be\u0997\u09c1\u09f1\u09c7" },
            { "tum", "\u09a4\u09c1\u09ae\u09cd\u09ac\u09c1\u0995\u09be" },
            { "Hebr", metaValue_he },
            { "QA", "\u0995\u09be\u099f\u09be\u09f0" },
            { "niu", "\u09a8\u09bf\u09af\u09bc\u09c1\u09f1\u09be\u09a8" },
            { "QO", "\u0986\u0989\u099f\u09b2\u09be\u09af\u09bc\u09bf\u0982 \u0985\u2019\u099a\u09bf\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "lez", "\u09b2\u09c7\u099c\u0998\u09bf\u09af\u09bc\u09be\u09a8" },
            { "tvl", metaValue_TV },
            { "001", "\u09ac\u09bf\u09b6\u09cd\u09ac" },
            { "002", "\u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "003", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "RE", "\u09f0\u09bf\u0987\u0989\u09a8\u09bf\u09af\u09bc\u09a8" },
            { "005", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "jbo", "\u09b2\u09cb\u099c\u09cd\u09ac\u09be\u09a8" },
            { "009", "\u0985\u2019\u099a\u09c7\u09a8\u09c0\u09af\u09bc\u09be" },
            { "RO", "\u09f0\u09cb\u09ae\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "RS", "\u099b\u09be\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "RU", "\u09f0\u09be\u099b\u09bf\u09af\u09bc\u09be" },
            { "RW", "\u09f0\u09cb\u09f1\u09be\u09a3\u09cd\u09a1\u09be" },
            { "SA", "\u099a\u09cc\u09a1\u09bf \u0986\u09f0\u09ac\u09bf\u09af\u09bc\u09be" },
            { "SB", "\u099a\u09cb\u09b2\u09cb\u09ae\u09cb\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "twq", "\u099f\u09be\u099b\u09be\u09f1\u09be\u0995" },
            { "011", "\u09aa\u09be\u09b6\u09cd\u099a\u09be\u09a4\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "SC", "\u099b\u09bf\u099a\u09bf\u09b2\u09bf\u099b" },
            { "SD", "\u099a\u09c1\u09a1\u09be\u09a8" },
            { "013", "\u09ae\u09a7\u09cd\u09af \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "SE", "\u099a\u09c1\u0987\u09a1\u09c7\u09a8" },
            { "014", "\u09aa\u09cd\u09f0\u09be\u099a\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "015", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "SG", "\u099b\u09bf\u0982\u0997\u09be\u09aa\u09c1\u09f0" },
            { "SH", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09b9\u09c7\u09b2\u09c7\u09a8\u09be" },
            { "type.lb.strict", "\u0995\u09a0\u09cb\u09f0 \u09aa\u0982\u0995\u09cd\u09a4\u09bf \u09ac\u09bf\u099a\u09cd\u099b\u09c7\u09a6 \u09b6\u09c8\u09b2\u09c0" },
            { "017", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "SI", "\u09b6\u09cd\u09b2\u09cb\u09ad\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "018", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be" },
            { "SJ", "\u099a\u09be\u09ad\u09be\u09b2\u09ac\u09be\u09f0\u09cd\u09a1 \u0986\u09f0\u09c1 \u099c\u09a8 \u09ae\u09c7\u09af\u09bc\u09a8" },
            { "019", "\u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be\u099b\u09cd" },
            { "SK", "\u09b6\u09cd\u09b2\u09cb\u09ad\u09be\u0995\u09bf\u09af\u09bc\u09be" },
            { "SL", "\u099a\u09bf\u09af\u09bc\u09c7\u09f0\u09be \u09b2\u09bf\u0985\u2019\u09a8" },
            { "SM", "\u099a\u09be\u09a8 \u09ae\u09be\u09f0\u09bf\u09a8\u09cb" },
            { "SN", "\u099a\u09c7\u09a8\u09c7\u0997\u09be\u09b2" },
            { "SO", "\u099a\u09cb\u09ae\u09be\u09b2\u09bf\u09af\u09bc\u09be" },
            { "arn", "\u09ae\u09be\u09aa\u09c1\u099a\u09c7" },
            { "arp", "\u0986\u09f0\u09be\u09aa\u09be\u09b9\u09cb" },
            { "type.nu.taml", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u09a4\u09be\u09ae\u09bf\u09b2 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "SR", "\u099b\u09c1\u09f0\u09bf\u09a8\u09be\u09ae" },
            { "SS", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099a\u09c1\u09a1\u09be\u09a8" },
            { "ST", "\u099a\u09be\u0993 \u099f\u09cb\u09ae\u09c7 \u0986\u09f0\u09c1 \u09aa\u09cd\u09f0\u09bf\u09a8\u099a\u09bf\u09aa\u09c7" },
            { "SV", "\u098f\u09b2 \u099b\u09c7\u09b2\u09ad\u09c7\u09a1\u2019\u09f0" },
            { "SX", "\u099a\u09bf\u09a3\u09cd\u099f \u09ae\u09be\u09f0\u09cd\u099f\u09c7\u09a8" },
            { "SY", "\u099a\u09bf\u09f0\u09bf\u09af\u09bc\u09be" },
            { "SZ", "\u09b8\u09cd\u09ac\u09be\u099c\u09bf\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "TA", "\u09a4\u09cd\u09f0\u09bf\u09b8\u09cd\u09a4\u09be\u09a8 \u09a6\u09cd\u09af\u09be \u0995\u09c1\u09a8\u09b9\u09be" },
            { "asa", "\u0986\u099b\u09c1" },
            { "type.ms.ussystem", "\u09ae\u09be\u09f0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09f0\u09be\u09b7\u09cd\u099f\u09cd\u09f0\u09f0 \u099c\u09cb\u0996-\u09ae\u09be\u0996\u09f0 \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0" },
            { "021", "\u0989\u09a4\u09cd\u09a4\u09f0\u09c0\u09af\u09bc \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be" },
            { "TC", "\u099f\u09be\u09f0\u09cd\u0995\u099b \u0985\u09f0\u09c1 \u0995\u09c7\u0987\u0995\u2019\u099b \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "yav", "\u09af\u09bc\u09be\u0982\u09ac\u09c7\u09a8" },
            { "TD", "\u099a\u09be\u09a1" },
            { "TF", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8\u09f0 \u0985\u099e\u09cd\u099a\u09b2" },
            { "TG", "\u099f\u09cb\u0997\u09cb" },
            { "TH", "\u09a5\u09be\u0987\u09b2\u09c7\u09a3\u09cd\u09a1" },
            { "TJ", "\u09a4\u09be\u099c\u09bf\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "029", "\u0995\u09c7\u09f0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "TK", "\u099f\u09cb\u0995\u09c7\u09b2\u09be\u0989" },
            { "TL", "\u099f\u09bf\u09ae\u09cb\u09f0-\u09b2\u09c7\u099a\u099f\u09c7" },
            { "ybb", "\u09af\u09bc\u09c7\u09ae\u09cd\u09ac\u09be" },
            { "TM", "\u09a4\u09c1\u09f0\u09cd\u0995\u09ae\u09c7\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "TN", "\u099f\u09c1\u09a8\u09bf\u099a\u09bf\u09af\u09bc\u09be" },
            { "TO", "\u099f\u0982\u0997\u09be" },
            { "TR", "\u09a4\u09c1\u09f0\u09cd\u0995\u09bf" },
            { "TT", "\u099f\u09cd\u09f0\u09bf\u09a8\u09bf\u09a1\u09be\u09a1 \u0986\u09f0\u09c1 \u099f\u09cb\u09ac\u09be\u0997\u09cb" },
            { "TV", metaValue_TV },
            { "TW", "\u099f\u09be\u0987\u09f1\u09be\u09a8" },
            { "ast", "\u098f\u09b7\u09cd\u099f\u09c1\u09f0\u09c0\u09af\u09bc" },
            { "TZ", "\u09a4\u09be\u099e\u09cd\u099c\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "nmg", "\u0995\u09cb\u09f1\u09be\u099b\u09bf\u0985\u2019" },
            { "Zzzz", "\u0985\u099c\u09cd\u099e\u09be\u09a4 \u09b2\u09bf\u09aa\u09bf" },
            { "UA", "\u0987\u0989\u0995\u09cd\u09f0\u09c7\u0987\u09a8" },
            { "rup", "\u0986\u09f0\u09cb\u09ae\u09be\u09a8\u09c0\u09af\u09bc" },
            { "030", "\u09aa\u09cd\u09f0\u09be\u099a\u09cd\u09af \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "tyv", "\u09a4\u09c1\u09ad\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sw_CD", "\u0995\u0999\u09cd\u0997\u09cb \u09b8\u09cd\u09ac\u09be\u09b9\u09bf\u09b2\u09bf" },
            { "034", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "035", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3-\u09aa\u09c2\u09ac \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "UG", "\u0989\u0997\u09be\u09a3\u09cd\u09a1\u09be" },
            { "type.co.pinyin", "\u09aa\u09bf\u09a8\u09cd\u200c\u09af\u09bc\u09bf\u09a8 \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae" },
            { "039", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u0987\u0989\u09f0\u09cb\u09aa" },
            { "Sinh", "\u09b8\u09bf\u0982\u09b9\u09b2\u09c0" },
            { "UM", "\u0987\u0989. \u098f\u099b. \u0986\u0989\u099f\u09b2\u09be\u09af\u09bc\u09bf\u0982 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "UN", "\u09f0\u09be\u09b7\u09cd\u099f\u09cd\u09f0\u09b8\u0982\u0998" },
            { "US", "\u09ae\u09be\u09f0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09f0\u09be\u09b7\u09cd\u099f\u09cd\u09f0" },
            { "haw", "\u09b9\u09be\u09f1\u09be\u0987" },
            { "type.co.gb2312han", "\u09b8\u09f0\u09b2 \u099a\u09c0\u09a8\u09be \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae - GB2312" },
            { "UY", "\u0989\u09f0\u09c1\u0997\u09c1\u09f1\u09c7" },
            { "prg", "\u09aa\u09cd\u09f0\u09c1\u099b\u09bf\u09af\u09bc\u09be\u09a8" },
            { "UZ", "\u0989\u099c\u09ac\u09c7\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "tzm", "\u099a\u09c7\u09a3\u09cd\u099f\u09cd\u09f0\u09c7\u09b2 \u098f\u099f\u09b2\u09be\u099b \u099f\u09be\u09ae\u09be\u099c\u09be\u0987\u099f" },
            { "type.co.stroke", "\u09b8\u09cd\u099f\u09cd\u09f0\u09cb\u0995 \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae" },
            { "nnh", "\u09a8\u09bf\u09af\u09bc\u09c7\u09ae\u09cd\u09ac\u09cb\u09a8" },
            { "VA", "\u09ad\u09c7\u099f\u09bf\u0995\u09be\u09a8 \u099a\u09bf\u099f\u09bf" },
            { "VC", "\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09ad\u09bf\u09a8\u099a\u09c7\u09a3\u09cd\u099f \u0986\u09f0\u09c1 \u0997\u09cd\u09f0\u09c0\u09a3\u09be\u09a1\u09be\u0987\u09a8\u099b" },
            { "VE", "\u09ad\u09c7\u09a8\u09bf\u099c\u09c1\u09f1\u09c7\u09b2\u09be" },
            { "VG", "\u09ac\u09cd\u09f0\u09bf\u099f\u09bf\u099b \u09ad\u09be\u09f0\u09cd\u099c\u09bf\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "VI", "\u0987\u0989. \u098f\u099b. \u09ad\u09be\u09f0\u09cd\u099c\u09bf\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "VN", "\u09ad\u09bf\u09af\u09bc\u09c7\u099f\u09a8\u09be\u09ae" },
            { "VU", "\u09ad\u09be\u09a8\u09be\u099f\u09c1" },
            { "nog", "\u09a8\u09cb\u0997\u09be\u0987" },
            { "rwk", "\u09f0\u09f1\u09be" },
            { "053", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09c7\u099b\u09bf\u09af\u09bc\u09be" },
            { "054", "\u09ae\u09c7\u09b2\u09be\u09a8\u09c7\u099b\u09bf\u09af\u09bc\u09be" },
            { "WF", "\u09f1\u09be\u09b2\u09bf\u099b \u0986\u09f0\u09c1 \u09ab\u09c1\u099f\u09c1\u09a8\u09be" },
            { "type.co.traditional", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4\u09ad\u09be\u09ac\u09c7 \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae" },
            { "057", "\u09ae\u09be\u0987\u0995\u09cd\u09f0\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc \u0995\u09cd\u09b7\u09c7\u09a4\u09cd\u09f0" },
            { "jgo", "\u09a8\u0997\u09cb\u09ae\u09cd\u09ac\u09be" },
            { "lkt", "\u09b2\u09be\u0995\u09cb\u099f\u09be" },
            { "wae", "\u09f1\u09be\u09b2\u099b\u09c7\u09f0" },
            { "WS", "\u099a\u09be\u09ae\u09cb\u09f1\u09be" },
            { "wal", "\u0993\u09b2\u09c7\u0987\u099f\u09be" },
            { "war", "\u09f1\u09be\u09f0\u09c7" },
            { "awa", "\u0986\u09f1\u09be\u09a7\u09bf" },
            { "061", "\u09aa\u09b2\u09bf\u09a8\u09c7\u099a\u09bf\u09af\u09bc\u09be" },
            { "XK", "\u0995\u099a\u2019\u09ad\u2019" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0985\u09b2\u09bf\u0996\u09bf\u09a4" },
            { "YE", "\u09af\u09bc\u09c7\u09ae\u09c7\u09a8" },
            { "nqo", "\u098f\u09a8\u09cd\u0995\u09cb" },
            { "type.co.standard", "\u09ae\u09be\u09a8\u09cd\u09af \u09b8\u099c\u09cb\u09f1\u09be \u0995\u09cd\u09f0\u09ae" },
            { "YT", "\u09ae\u09be\u09af\u09bc\u09cb\u099f\u09cd\u099f\u09c7" },
            { "ZA", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "type.lb.loose", "\u09a2\u09bf\u09b2\u09be \u09aa\u0982\u0995\u09cd\u09a4\u09bf \u09ac\u09bf\u099a\u09cd\u099b\u09c7\u09a6 \u09b6\u09c8\u09b2\u09c0" },
            { "Deva", "\u09a6\u09c7\u09f1\u09a8\u09be\u0997\u09f0\u09c0" },
            { "type.nu.geor", "\u099c\u09f0\u09cd\u099c\u09c0\u09af\u09bc\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "Hira", "\u09b9\u09bf\u09f0\u09be\u0997\u09be\u09a8\u09be" },
            { "ZM", "\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "ZW", "\u099c\u09bf\u09ae\u09cd\u09ac\u09be\u09ac\u09f1\u09c7" },
            { "ZZ", "\u0985\u099c\u09cd\u099e\u09be\u09a4 \u0995\u09cd\u09b7\u09c7\u09a4\u09cd\u09f0" },
            { "type.ms.metric", "\u09ae\u09c7\u099f\u09cd\u09f0\u09bf\u0995 \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0" },
            { "type.ca.iso8601", "\u0986\u0987. \u098f\u099b. \u0985\u2019.-\u09ee\u09ec\u09e6\u09e7 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "nso", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u099b\u09cb\u09a5\u09cb" },
            { "type.nu.telu", "\u09a4\u09c7\u09b2\u09c1\u0997\u09c1 \u0985\u0982\u0995" },
            { "loz", "\u09b2\u09cb\u099c\u09bf" },
            { "jmc", "\u09ae\u09c7\u0995\u09b9\u09c7\u09ae" },
            { "type.nu.hansfin", "\u09b8\u09f0\u09b2\u09c0\u0995\u09c3\u09a4 \u099a\u09c0\u09a8\u09be \u09ac\u09bf\u09a4\u09cd\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "hil", "\u09b9\u09bf\u09b2\u09bf\u0997\u09be\u09af\u09bc\u09a8\u09cb\u09a8" },
            { "type.nu.arabext", "\u09ac\u09bf\u09b8\u09cd\u09a4\u09be\u09f0\u09bf\u09a4 \u0986\u09f0\u09ac\u09c0-\u09ad\u09be\u09f0\u09a4\u09c0\u09af\u09bc \u0985\u0982\u0995" },
            { "nus", "\u09a8\u09c1\u09af\u09bc\u09c7\u09f0" },
            { "dak", "\u09a1\u09be\u0995\u09cb\u099f\u09be" },
            { "type.nu.fullwide", "\u09aa\u09c2\u09f0\u09cd\u09a3-\u09aa\u09cd\u09f0\u09b8\u09cd\u09a5\u09f0 \u0985\u0982\u0995" },
            { "dar", "\u09a6\u09be\u09f0\u09cd\u0997\u09f1\u09be" },
            { "dav", "\u09a4\u09c7\u0987\u09a4\u09be" },
            { "lrc", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u09b2\u09c1\u09f0\u09bf" },
            { "udm", "\u0989\u09a6\u09ae\u09c1\u09f0\u09cd\u09a4" },
            { "Khmr", metaValue_km },
            { "sad", "\u099b\u09be\u09a8\u09cd\u09a6\u09be\u09f1\u09c7" },
            { "type.nu.roman", "\u09f0\u09cb\u09ae\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "sah", "\u099b\u09be\u0996\u09be" },
            { "saq", "\u099b\u09be\u09ae\u09cd\u09ac\u09c1\u09f0\u09c1" },
            { "sat", "\u099a\u09be\u0993\u09a4\u09be\u09b2\u09bf" },
            { "sba", "\u09a8\u09be\u0982\u09ae\u09cd\u09ac\u09c7" },
            { "Guru", "\u0997\u09c1\u09f0\u09c1\u09ae\u09c1\u0996\u09c0" },
            { "lua", "\u09b2\u09c1\u09ac\u09be-\u09b2\u09c1\u09b2\u09c1\u09f1\u09be" },
            { "sbp", "\u099b\u09be\u0999\u09cd\u0997\u09c1" },
            { "nyn", "\u09a8\u09cd\u09af\u09be\u09a8\u0995\u09cb\u09b2" },
            { "lun", "\u09b2\u09c1\u09a3\u09cd\u09a1\u09be" },
            { "luo", "\u09b2\u09c1\u0993" },
            { "fil", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09bf\u09a8\u09cb" },
            { "hmn", "\u09b9\u09ae\u0982" },
            { "lus", "\u09ae\u09bf\u099c\u09cb" },
            { "ban", "\u09ac\u09be\u09b2\u09bf\u09a8\u09c0\u099c" },
            { "luy", "\u09b2\u09c1\u0987\u09af\u09bc\u09be" },
            { "bas", "\u09ac\u09be\u099b\u09be" },
            { "es_ES", "\u0987\u0989\u09f0\u09cb\u09aa\u09c0\u09af\u09bc\u09be\u09a8 \u09b8\u09cd\u09aa\u09c7\u09a8\u09bf\u099a" },
            { "sco", "\u09b8\u09cd\u0995\u099f\u099b" },
            { "scn", "\u099b\u09bf\u099a\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "aa", "\u0986\u09ab\u09be\u09f0" },
            { "ab", "\u0986\u09ac\u0996\u09be\u099c\u09bf\u09af\u09bc\u09be\u09a8" },
            { "af", "\u0986\u09ab\u09cd\u09f0\u09bf\u0995\u09be\u09a8\u099b\u09cd" },
            { "ak", "\u0986\u0995\u09be\u09a8" },
            { "am", "\u0986\u09ae\u09b9\u09be\u09f0\u09bf\u0995" },
            { "Arab", metaValue_ar },
            { "an", "\u0986\u09f0\u09cd\u0997\u09cb\u09a8\u09bf\u099c" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u099c\u09be\u09aa\u09be\u09a8\u09c0 \u099b\u09bf\u09b2\u09c7\u09ac\u09c7\u09f0\u09bf\u099c" },
            { "as", "\u0985\u09b8\u09ae\u09c0\u09af\u09bc\u09be" },
            { "av", "\u0986\u09ad\u09c7\u09f0\u09bf\u0995" },
            { "ay", "\u0986\u09af\u09bc\u09ae\u09be\u09f0\u09be" },
            { "az", "\u0986\u099c\u09c7\u09f0\u09ac\u09be\u0987\u099c\u09be\u09a8\u09c0" },
            { "ba", "\u09ac\u09be\u099b\u0996\u09bf\u09f0" },
            { "be", "\u09ac\u09c7\u09b2\u09be\u09f0\u09c1\u099b\u09c0\u09af\u09bc" },
            { "bg", "\u09ac\u09c1\u09b2\u0997\u09c7\u09f0\u09c0\u09af\u09bc" },
            { "bi", "\u09ac\u09bf\u099b\u09b2\u09be\u09ae\u09be" },
            { "bm", "\u09ac\u09be\u09ae\u09ac\u09be\u09f0\u09be" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u09a1\u09cb\u0997\u09cd\u09f0\u09bf\u09ac" },
            { "br", "\u09ac\u09cd\u09f0\u09c7\u099f\u09a8" },
            { "bs", "\u09ac\u099b\u09a8\u09c0\u09af\u09bc" },
            { "Mymr", "\u09ae\u09cd\u09af\u09be\u09a8\u09ae\u09be\u09f0" },
            { "type.nu.laoo", "\u09b2\u09be\u0993 \u0985\u0982\u0995" },
            { "seh", "\u099b\u09c7\u09a8\u09be" },
            { "ca", "\u0995\u09be\u09a4\u09be\u09b2\u09be\u09a8" },
            { "ses", "\u0995\u09cb\u0987\u09f0\u09be\u09ac\u09cb\u09f0\u09cb \u099a\u09c7\u09a8\u09cd\u09a8\u09bf" },
            { "ce", "\u099a\u09c7\u099a\u09c7\u09a8" },
            { "ch", "\u099a\u09be\u09ae\u09cb\u09f0\u09cb" },
            { "co", "\u0995\u09cb\u09f0\u09cd\u099b\u09bf\u0995\u09be\u09a8" },
            { "Orya", metaValue_or },
            { "cs", "\u099a\u09c7\u0995" },
            { "cu", "\u099a\u09be\u09f0\u09cd\u099a \u09b6\u09cd\u09b2\u09c7\u09ad\u09bf\u0995" },
            { "cv", "\u099a\u09c1\u09ad\u09be\u099a" },
            { "cy", "\u09f1\u09c7\u09b2\u099a" },
            { "type.nu.ethi", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "da", "\u09a1\u09c7\u09a8\u09bf\u099a" },
            { "pt_PT", "\u0987\u0989\u09f0\u09cb\u09aa\u09c0\u09af\u09bc\u09be\u09a8 \u09aa\u09f0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "de", "\u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8" },
            { "type.cf.standard", "\u09ae\u09be\u09a8\u09cd\u09af \u09ae\u09c1\u09a6\u09cd\u09f0\u09be \u09b8\u099c\u09cd\u099c\u09be" },
            { "bem", "\u09ac\u09c7\u09ae\u09cd\u09ac\u09be" },
            { "dv", "\u09a6\u09bf\u09ac\u09c7\u09b9\u09bf" },
            { "es_419", "\u09b2\u09c7\u099f\u09bf\u09a8 \u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be\u09a8 \u09b8\u09cd\u09aa\u09c7\u09a8\u09bf\u099a" },
            { "dz", "\u099c\u09cb\u0982\u0996\u09be" },
            { "bez", "\u09ac\u09c7\u09a8\u09be" },
            { "type.ca.chinese", "\u099a\u09c0\u09a8\u09be \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "dje", "\u099d\u09be\u09f0\u09cd\u09ae\u09be" },
            { "type.nu.grek", "\u0997\u09cd\u09f0\u09c0\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ee", "\u0987\u09f1\u09c7" },
            { "type.lb.normal", "\u09b8\u09be\u09a7\u09be\u09f0\u09a3 \u09aa\u0982\u0995\u09cd\u09a4\u09bf \u09ac\u09bf\u099a\u09cd\u099b\u09c7\u09a6 \u09b6\u09c8\u09b2\u09c0" },
            { "ro_MD", "\u09ae\u09cb\u09b2\u09cd\u09a1\u09be\u09ad\u09bf\u09af\u09bc\u09be\u09a8" },
            { "el", metaValue_el },
            { "en", "\u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "eo", "\u098f\u09b8\u09cd\u09aa\u09c7\u09f0\u09be\u09a8\u09cd\u09a4\u09cb" },
            { "type.co.big5han", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be \u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae - Big5" },
            { "es", "\u09b8\u09cd\u09aa\u09c7\u09a8\u09bf\u099a" },
            { "et", "\u098f\u09b7\u09cd\u099f\u09cb\u09a8\u09bf\u09af\u09bc" },
            { "Hanb", "\u09ac\u09cb\u09aa\u09cb\u09ae\u09cb\u09ab\u09cb\u09f0 \u09b8\u09c8\u09a4\u09c7 \u09b9\u09be\u09a8" },
            { "eu", "\u09ac\u09be\u09b8\u09cd\u0995" },
            { "Hang", "\u09b9\u09c7\u0999\u09cd\u0997\u09c1\u09b2" },
            { "shi", "\u09a4\u09be\u099a\u09c7\u09b2\u09b9\u09bf\u099f" },
            { "hsb", "\u0986\u09aa\u09be\u09f0 \u099b\u09cb\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "Hani", "\u09b9\u09be\u09a8" },
            { "shn", "\u099a\u09be\u09a8" },
            { "fa", "\u09ab\u09be\u09f0\u09cd\u099b\u09c0" },
            { "Hans", "\u09b8\u09f0\u09b2\u09c0\u0995\u09c3\u09a4" },
            { "type.nu.latn", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae\u09c0\u09af\u09bc\u09be \u0985\u0982\u0995" },
            { "Hant", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4" },
            { "ff", "\u09ab\u09c1\u09b2\u09be\u09b9" },
            { "fi", "\u09ab\u09bf\u09a8\u09bf\u099a" },
            { "fj", "\u09ab\u09bf\u099c\u09bf\u09af\u09bc\u09be\u09a8" },
            { "fon", "\u09ab\u2019\u09a8" },
            { "yue", "\u0995\u09c7\u09a3\u09cd\u099f\u09cb\u09a8\u09c0\u099c" },
            { "fo", "\u09ab\u09be\u09f0\u09cb\u0987\u099c" },
            { "umb", "\u0989\u09ae\u09cd\u09ac\u09c1\u09a8\u09cd\u09a6\u09c1" },
            { "fr", "\u09ab\u09cd\u09f0\u09c7\u09a8\u09cd\u09b8" },
            { "fy", "\u09f1\u09c7\u09b7\u09cd\u099f\u09be\u09f0\u09cd\u09a3 \u09ab\u09cd\u09f0\u09bf\u099b\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ga", "\u0986\u0987\u09f0\u09bf\u099a" },
            { "gd", "\u09b8\u09cd\u0995\u099f\u09bf\u099a \u0997\u09c7\u0987\u09b2\u09bf\u0995" },
            { "gl", "\u0997\u09c7\u09b2\u09bf\u099a\u09bf\u09af\u09bc\u09be\u09a8" },
            { "gn", "\u0997\u09c1\u09f1\u09be\u09f0\u09be\u09a3\u09c0" },
            { "bho", "\u09ad\u09cb\u099c\u09aa\u09c1\u09f0\u09c0" },
            { "und", "\u0985\u099c\u09cd\u099e\u09be\u09a4 \u09ad\u09be\u09b7\u09be" },
            { "gu", metaValue_gu },
            { "gv", "\u09ae\u09c7\u0982\u0995\u09cd\u09b8" },
            { "ha", "\u09b9\u09be\u0989\u099b\u09be" },
            { "he", metaValue_he },
            { "hi", "\u09b9\u09bf\u09a8\u09cd\u09a6\u09c0" },
            { "hup", "\u09b9\u09c1\u09aa\u09be" },
            { "bin", "\u09ac\u09bf\u09a8\u09bf" },
            { "hr", "\u0995\u09cd\u09f0\u09cb\u09f1\u09c7\u099a\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ht", "\u09b9\u09c7\u0987\u099f\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09f0\u09bf\u09af\u09bc\u09b2" },
            { "hu", "\u09b9\u09be\u0999\u09cd\u0997\u09c7\u09f0\u09bf\u09af\u09bc\u09be\u09a8" },
            { "hy", metaValue_hy },
            { "hz", "\u09b9\u09c7\u09f0\u09c7\u09f0\u09cb" },
            { "ia", "\u0987\u09a3\u09cd\u099f\u09be\u09f0\u09b2\u09bf\u0982\u0997\u09c1\u09f1\u09be" },
            { "Jamo", "\u099c\u09be\u09ae\u09cb" },
            { "id", "\u0987\u09a3\u09cd\u09a1\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc" },
            { "type.nu.tibt", "\u09a4\u09bf\u09ac\u09cd\u09ac\u09a4\u09c0 \u0985\u0982\u0995" },
            { "ig", "\u0987\u0997\u09cd\u09ac\u09cb" },
            { "ii", "\u099b\u09bf\u099a\u09c1\u09f1\u09be\u09a8 \u0987" },
            { "io", "\u0987\u09a1\u09cb" },
            { "is", "\u0986\u0987\u099a\u09b2\u09c7\u09a3\u09cd\u09a1\u09bf\u0995" },
            { "it", "\u0987\u099f\u09be\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "iu", "\u0987\u09a8\u09c1\u0995\u09cd\u099f\u09bf\u099f\u09c1\u099f" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "sma", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u099b\u09be\u09ae\u09bf" },
            { "jv", "\u099c\u09be\u09ad\u09be\u09a8\u09c0" },
            { "mad", "\u09ae\u09be\u09a6\u09c1\u09f0\u09c7\u099b\u09c7" },
            { "smj", "\u09b2\u09c1\u09b2\u09c7 \u099b\u09be\u09ae\u09bf" },
            { "mag", "\u09ae\u09be\u0997\u09be\u09b9\u09bf" },
            { "mai", "\u09ae\u09c8\u09a5\u09bf\u09b2\u09c0" },
            { "smn", "\u0987\u09a8\u09be\u09f0\u09bf \u099b\u09be\u09ae\u09bf" },
            { "ka", metaValue_ka },
            { "bla", "\u099b\u09bf\u0995\u09cd\u09b8\u09bf\u0995\u09be" },
            { "mak", "\u09ae\u09be\u0995\u09be\u099b\u09be\u09f0" },
            { "sms", "\u09b8\u09cd\u0995\u09cb\u09b2\u09cd\u099f \u099b\u09be\u09ae\u09bf" },
            { "ki", "\u0995\u09bf\u0995\u09c1\u09af\u09bc\u09c1" },
            { "mas", "\u09ae\u09be\u099b\u09be\u0987" },
            { "kj", "\u0995\u09c1\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09ae\u09be" },
            { "kk", "\u0995\u09be\u099c\u09be\u0996" },
            { "kl", "\u0995\u09be\u09b2\u09be\u09b2\u09bf\u099b\u09c1\u099f" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0995\u09be\u09a8\u09c1\u09f0\u09bf" },
            { "ks", "\u0995\u09be\u09b6\u09cd\u09ae\u09bf\u09f0\u09c0" },
            { "ku", "\u0995\u09c1\u09f0\u09cd\u09a1\u09bf\u099a" },
            { "kv", "\u0995\u09cb\u09ae\u09bf" },
            { "kw", "\u0995\u09cb\u09f0\u09cd\u09a8\u09bf\u099a" },
            { "ky", "\u0995\u09bf\u09f0\u09cd\u0997\u09bf\u099c" },
            { "snk", "\u099b\u09cb\u09a8\u09bf\u09a8\u0995\u09c7" },
            { "la", metaValue_la },
            { "lb", "\u09b2\u09be\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09f0\u09cd\u0997\u09bf\u099a" },
            { "type.nu.mlym", "\u09ae\u09be\u09b2\u09be\u09af\u09bc\u09be\u09b2\u09ae \u0985\u0982\u0995" },
            { "lg", "\u0997\u09be\u09a8\u09cd\u09a6\u09be" },
            { "li", "\u09b2\u09bf\u09ae\u09cd\u09ac\u09c1\u09f0\u09cd\u0997\u09bf\u099a" },
            { "Tibt", metaValue_bo },
            { "ln", "\u09b2\u09bf\u0982\u0997\u09be\u09b2\u09be" },
            { "fur", "\u09ab\u09cd\u09f0\u09bf\u0989\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0987\u09ae\u09cd\u09aa\u09c7\u09f0\u09bf\u09af\u09bc\u09c7\u09b2 \u099c\u09cb\u0996-\u09ae\u09be\u0996\u09f0 \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0" },
            { "lt", "\u09b2\u09bf\u09a5\u09c1\u09f1\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "lu", "\u09b2\u09c1\u09ac\u09be-\u0995\u09be\u099f\u09be\u0982\u0997\u09be" },
            { "lv", "\u09b2\u09be\u099f\u09ad\u09bf\u09af\u09bc\u09be\u09a8" },
            { "mg", "\u09ae\u09be\u09b2\u09be\u0997\u09be\u099b\u09c0" },
            { "mh", "\u09ae\u09be\u09f0\u09cd\u099a\u09b2\u09bf\u099c" },
            { "type.co.ducet", "\u09a1\u09bf\u09ab\u2019\u09b2\u09cd\u099f \u0987\u0989\u09a8\u09bf\u0995\u09cb\u09a1 \u09b8\u099c\u09cb\u09f1\u09be \u0995\u09cd\u09f0\u09ae" },
            { "mi", "\u09ae\u09be\u0993\u09f0\u09bf" },
            { "mk", "\u09ae\u09c7\u099a\u09bf\u09a1\u09cb\u09a8\u09c0\u09af\u09bc" },
            { "ml", metaValue_ml },
            { "mn", "\u09ae\u0982\u0997\u09cb\u09b2\u09c0\u09af\u09bc" },
            { "mr", "\u09ae\u09be\u09f0\u09be\u09a0\u09c0" },
            { "ms", "\u09ae\u09be\u09b2\u09af\u09bc" },
            { "mt", "\u09ae\u09be\u09b2\u09cd\u099f\u09bf\u099c" },
            { "my", "\u09ac\u09be\u09f0\u09cd\u09ae\u09c0\u099c" },
            { "Armn", metaValue_hy },
            { "mdf", "\u09ae\u09cb\u0995\u09cd\u09b8\u09be" },
            { "dsb", "\u09b2\u2019\u09f1\u09be\u09f0 \u099b\u09cb\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "na", metaValue_NR },
            { "type.co.search", "\u09b8\u09be\u09a7\u09be\u09f0\u09a3 \u0989\u09a6\u09cd\u09a6\u09c7\u09b6\u09cd\u09af\u09c7 \u0985\u09a8\u09c1\u09b8\u09a8\u09cd\u09a7\u09be\u09a8" },
            { "nb", "\u09a8\u09f0\u09f1\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09cb\u0995\u09ae\u09be\u09b2" },
            { "nd", "\u0989\u09a4\u09cd\u09a4\u09f0 \u09a8\u09bf\u09ac\u09c7\u09ac\u09c7\u09b2\u09c7" },
            { "ne", "\u09a8\u09c7\u09aa\u09be\u09b2\u09c0" },
            { "ng", "\u098f\u09a8\u09cd\u09a6\u09cb\u0999\u09cd\u0997\u09be" },
            { "nl", "\u09a1\u09be\u099a" },
            { "nn", "\u09a8\u09f0\u09f1\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09be\u09af\u09bc\u09a8\u09cb\u09f0\u09cd\u09b8\u09cd\u0995" },
            { "nr", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09a6\u09c7\u09ac\u09c7\u09b2" },
            { "nv", "\u09a8\u09be\u09ad\u09be\u099c\u09cb" },
            { "ny", "\u09a8\u09cd\u09af\u09be\u099e\u09cd\u099c\u09be" },
            { "kac", "\u0995\u09be\u099a\u09bf\u09a8" },
            { "kab", "\u0995\u09be\u09ac\u09be\u0987\u09b2" },
            { "oc", "\u0985\u2019\u099a\u09bf\u099f\u09be\u09a8" },
            { "kaj", "\u099c\u099c\u09c1" },
            { "kam", "\u0995\u09be\u09ae\u09cd\u09ac\u09be" },
            { "men", "\u09ae\u09c7\u09a3\u09cd\u09a1\u09c7" },
            { "mer", "\u09ae\u09c7\u09f0\u09c1" },
            { "type.nu.armn", "\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "om", "\u0993\u09f0\u09cb\u09ae\u09cb" },
            { "or", metaValue_or },
            { "os", "\u0993\u099b\u09c7\u099f\u09bf\u0995" },
            { "kbd", "\u0995\u09be\u09ac\u09be\u09f0\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8" },
            { "mfe", "\u09ae\u09f0\u09bf\u099b\u09bf\u09af\u09bc\u09be\u09a8" },
            { "srn", "\u09b8\u09cd\u09f0\u09be\u09a8\u09be\u09a8 \u099f\u09cb\u0999\u09cd\u0997\u09cb" },
            { "pa", "\u09aa\u09be\u099e\u09cd\u099c\u09be\u09ac\u09c0" },
            { "dua", "\u09a1\u09c1\u09f1\u09be\u09b2\u09be" },
            { "pl", "\u09aa\u2019\u09b2\u09bf\u099a" },
            { "type.ca.dangi", "\u09a6\u09be\u0982\u0997\u09bf \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "ps", "\u09aa\u09c1\u09b8\u09cd\u09a4" },
            { "pt", "\u09aa\u09f0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "key.co", "\u09b8\u099c\u09cb\u09f1\u09be \u0995\u09cd\u09f0\u09ae" },
            { "pt_BR", "\u09ac\u09cd\u09f0\u09be\u099c\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u09aa\u09f0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "kcg", "\u09a4\u09cd\u09af\u09be\u09aa" },
            { "mgh", "\u09ae\u09be\u0996\u09c1\u09f1\u09be-\u09ae\u09bf\u099f\u09cd\u099f\u09cb" },
            { "key.cf", "\u09ae\u09c1\u09a6\u09cd\u09f0\u09be \u09b8\u099c\u09cd\u099c\u09be" },
            { "key.ca", "\u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u09ae\u09c7\u099f\u09be" },
            { "type.hc.h23", "\u09e8\u09ea \u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0 (\u09e6\u2013\u09e8\u09e9)" },
            { "type.hc.h24", "\u09e8\u09ea \u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0 (\u09e7\u2013\u09e8\u09ea)" },
            { "ssy", "\u099b\u09be\u09b9\u09cb" },
            { "type.nu.mymr", "\u09ae\u09cd\u09af\u09be\u09a8\u09ae\u09be\u09f0 \u0985\u0982\u0995" },
            { "qu", "\u0995\u09c1\u09f1\u09c7\u099a\u09c1\u09f1\u09be" },
            { "brx", "\u09ac\u09a1\u09bc\u09cb" },
            { "kde", "\u09ae\u09be\u0995\u09cb\u09a3\u09cd\u09a1" },
            { "Ethi", "\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u0995" },
            { "type.hc.h12", "\u09e7\u09e8 \u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0 (\u09e7\u2013\u09e7\u09e8)" },
            { "type.hc.h11", "\u09e7\u09e8 \u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0 (\u09e6\u2013\u09e7\u09e7)" },
            { "rm", "\u09f0\u09cb\u09ae\u09be\u09a8\u099a" },
            { "rn", "\u09f0\u09c1\u09a8\u09cd\u09a6\u09bf" },
            { "key.cu", "\u09ae\u09c1\u09a6\u09cd\u09f0\u09be" },
            { "ro", "\u09f0\u09cb\u09ae\u09be\u09a8\u09c0\u09af\u09bc" },
            { "type.nu.orya", "\u0993\u09a1\u09bc\u09bf\u09af\u09bc\u09be \u0985\u0982\u0995" },
            { "type.nu.hanidec", "\u099a\u09c0\u09a8\u09be \u09a6\u09b6\u09ae\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ru", "\u09f0\u09be\u099b\u09bf\u09af\u09bc\u09be\u09a8" },
            { "rw", "\u0995\u09bf\u09a8\u09af\u09bc\u09be\u09f0\u09cb\u09f1\u09be\u09a3\u09cd\u09a1\u09be" },
            { "kea", "\u0995\u09be\u09ac\u09c1\u09ad\u09c7\u09f0\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8\u09c1" },
            { "mic", "\u09ae\u09bf\u0995\u09ae\u09c7\u0995" },
            { "suk", "\u099b\u09c1\u0995\u09c1\u09ae\u09be" },
            { "en_AU", "\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8 \u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "sa", "\u09b8\u0982\u09b8\u09cd\u0995\u09c3\u09a4" },
            { "sc", "\u099b\u09be\u09f0\u09cd\u09a1\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sd", "\u09b8\u09bf\u09a8\u09cd\u09a7\u09bf" },
            { "se", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u099b\u09be\u09ae\u09bf" },
            { "min", "\u09ae\u09bf\u09a8\u09be\u0982\u0995\u09be\u09ac\u09be\u0989" },
            { "sg", "\u099b\u09be\u0999\u09cd\u0997\u09cb" },
            { "si", "\u09b8\u09bf\u0982\u09b9\u09b2\u09be" },
            { "sk", "\u09b6\u09cd\u09b2\u09cb\u09ad\u09be\u0995" },
            { "sl", "\u09b6\u09cd\u09b2\u09cb\u09ad\u09c7\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sm", "\u099b\u09be\u09ae\u09cb\u09a8" },
            { "sn", "\u099a\u09cb\u09a8\u09be" },
            { "so", "\u099b\u09cb\u09ae\u09be\u09b2\u09bf" },
            { "type.nu.arab", "\u0986\u09f0\u09ac\u09c0-\u09ad\u09be\u09f0\u09a4\u09c0\u09af\u09bc \u0985\u0982\u0995" },
            { "sq", "\u0986\u09b2\u09ac\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "sr", "\u099b\u09be\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ss", "\u09b8\u09cd\u09ac\u09be\u09a4\u09bf" },
            { "type.cf.account", "\u0997\u09be\u09a3\u09a8\u09bf\u0995 \u09ae\u09c1\u09a6\u09cd\u09f0\u09be \u09b8\u099c\u09cd\u099c\u09be" },
            { "st", "\u09a6\u09be\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u09a4\u09cd\u09af \u099b\u09cb\u09a5\u09cb" },
            { "su", "\u099b\u09c1\u09a3\u09cd\u09a1\u09be\u09a8\u09c0\u099c" },
            { "sv", "\u099b\u09c1\u0987\u09a1\u09bf\u099a" },
            { "sw", "\u09b8\u09cd\u09ac\u09be\u09b9\u09bf\u09b2\u09bf" },
            { "type.nu.hantfin", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be \u09ac\u09bf\u09a4\u09cd\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "ibb", "\u0987\u09ac\u09bf\u09ac\u09bf\u0993" },
            { "iba", "\u0987\u09ac\u09be\u09a8" },
            { "ta", metaValue_ta },
            { "142", "\u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "143", "\u09ae\u09a7\u09cd\u09af \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "te", metaValue_te },
            { "145", "\u09aa\u09be\u09b6\u09cd\u099a\u09be\u09a4\u09cd\u09af \u098f\u099b\u09bf\u09af\u09bc\u09be" },
            { "tg", "\u09a4\u09be\u099c\u09bf\u0995" },
            { "th", metaValue_th },
            { "ti", "\u099f\u09bf\u0997\u09f0\u09bf\u09a8\u09bf\u09af\u09bc\u09be" },
            { "bug", "\u09ac\u0997\u09bf\u09a8\u09c0\u099c" },
            { "kfo", "\u0995\u09cb\u09f0\u09cb" },
            { "en_CA", "\u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u0987\u0982\u09f0\u09be\u099c\u09c0" },
            { "tk", "\u09a4\u09c1\u09f0\u09cd\u0995\u09ae\u09c7\u09a8" },
            { "tn", "\u099b\u09cb\u09f1\u09be\u09a8\u09be" },
            { "to", "\u099f\u09cb\u0999\u09cd\u0997\u09be\u09a8" },
            { "dyo", "\u099c\u09cb\u09b2\u09be-\u09ab\u2019\u09a8\u09bf" },
            { "type.nu.jpan", "\u099c\u09be\u09aa\u09be\u09a8\u09c0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "tr", "\u09a4\u09c1\u09f0\u09cd\u0995\u09c0" },
            { "ts", "\u099b\u09cb\u0999\u09cd\u0997\u09be" },
            { "swb", "\u0995\u09cb\u09ae\u09cb\u09f0\u09bf\u09af\u09bc\u09be\u09a8" },
            { "tt", "\u09a4\u09be\u09a4\u09be\u09f0" },
            { "ty", "\u09a4\u09be\u09b9\u09bf\u09a4\u09bf\u09af\u09bc\u09be\u09a8" },
            { "150", "\u0987\u0989\u09f0\u09cb\u09aa" },
            { "151", "\u09aa\u09cd\u09f0\u09be\u099a\u09cd\u09af \u0987\u0989\u09f0\u09cb\u09aa" },
            { "154", "\u0989\u09a6\u09c0\u099a\u09cd\u09af \u0987\u0989\u09f0\u09cb\u09aa" },
            { "dzg", "\u09a6\u09be\u099c\u09be\u0997\u09be" },
            { "155", "\u09aa\u09be\u09b6\u09cd\u099a\u09be\u09a4\u09cd\u09af \u0987\u0989\u09f0\u09cb\u09aa" },
            { "ug", "\u0989\u0987\u0998\u09c1\u09f0" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u0995\u09cb\u09ae\u09cb\u09a8" },
            { "uk", "\u0987\u0989\u0995\u09cd\u09f0\u09c7\u0987\u09a8\u09c0\u09af\u09bc" },
            { "ur", "\u0989\u09f0\u09cd\u09a6\u09c1" },
            { "xal", "\u0995\u09be\u09b2\u09cd\u09ae\u09bf\u0995" },
            { "uz", "\u0989\u099c\u09ac\u09c7\u0995" },
            { "kha", "\u0996\u09be\u099a\u09bf" },
            { "ve", "\u09ad\u09c7\u09a3\u09cd\u09a1\u09be" },
            { "type.ca.roc", "\u099a\u09c0\u09a8\u09be \u09aa\u09cd\u09f0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09f0\u09f0 \u0995\u09c7\u09b2\u09c7\u09a3\u09cd\u09a1\u09be\u09f0" },
            { "vi", "\u09ad\u09bf\u09af\u09bc\u09c7\u099f\u09a8\u09be\u09ae\u09c0" },
            { "khq", "\u0995\u09cb\u09af\u09bc\u09be\u09f0 \u099a\u09bf\u09a8\u09bf" },
            { "key.hc", "\u0998\u09a3\u09cd\u099f\u09c0\u09af\u09bc\u09be \u099a\u0995\u09cd\u09f0 (\u09e7\u09e8 \u09ac\u09a8\u09be\u09ae \u09e8\u09ea)" },
            { "vo", "\u09ad\u09cb\u09b2\u09be\u09aa\u09c1\u0995" },
            { "quc", "\u0995\u09bf\u099a\u09bf\u09af\u09bc\u09c7" },
            { "gaa", "\u0997\u09be" },
            { "wa", "\u09f1\u09be\u09b2\u09c1\u09a8" },
            { "syr", "\u099a\u09bf\u09f0\u09bf\u09af\u09bc\u09be\u0995" },
            { "Grek", metaValue_el },
            { "wo", "\u09f1\u09cb\u09b2\u09be\u09ab" },
            { "zgh", "\u09b7\u09cd\u099f\u09c7\u09a3\u09cd\u09a1\u09be\u09f0\u09cd\u09a1 \u09ae\u09cb\u09f0\u09cb\u0995\u09cd\u0995\u09be\u09a8 \u09a4\u09be\u09ae\u09be\u099c\u09be\u0987\u099f" },
            { "ar_001", "\u0986\u09a7\u09c1\u09a8\u09bf\u0995 \u09ae\u09be\u09a8\u0995 \u0986\u09f0\u09ac\u09c0" },
            { "Mong", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc" },
            { "mni", "\u09ae\u09a3\u09bf\u09aa\u09c1\u09f0\u09c0" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "\u09b8\u09f0\u09b2\u09c0\u0995\u09c3\u09a4 \u099a\u09c0\u09a8\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hant", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "xh", "\u09b9\u09cb\u099b\u09be" },
            { "type.nu.romanlow", "\u09f0\u09cb\u09ae\u09be\u09a8 \u09b8\u09f0\u09c1\u09ab\u09b2\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "byn", "\u09ac\u09cd\u09b2\u09bf\u09a8" },
            { "moh", "\u09ae\u09cb\u09b9\u09cb\u0995" },
            { "kkj", "\u0995\u09be\u0995\u09cb" },
            { "yi", "\u0987\u09a6\u09cd\u09a6\u09bf\u099b" },
            { "mos", "\u09ae\u09cb\u099b\u09bf" },
            { "yo", "\u0987\u0989\u09f0\u09c1\u09ac\u09be" },
            { "es_MX", "\u09ae\u09c7\u0995\u09cd\u09b8\u09bf\u0995\u09be\u09a8 \u09b8\u09cd\u09aa\u09c7\u09a8\u09bf\u099a" },
            { "vai", "\u09ad\u09be\u0987" },
            { "kln", "\u0995\u09be\u09b2\u09c7\u09a8\u099c\u09bf\u09a8" },
            { "zh", "\u099a\u09c0\u09a8\u09be" },
            { "Bopo", "\u09ac\u09cb\u09aa\u09cb\u09ae\u09cb\u09ab\u09cb" },
            { "key.lb", "\u09aa\u0982\u0995\u09cd\u09a4\u09bf \u09ac\u09bf\u099a\u09cd\u099b\u09c7\u09a6 \u09b6\u09c8\u09b2\u09c0" },
            { "zu", "\u099d\u09c1\u09b2\u09c1" },
            { "type.co.phonebook", "\u099f\u09c7\u09b2\u09bf\u09ab\u09cb\u09a8 \u09ac\u09b9\u09bf\u09f0 \u09ae\u09a4\u09c7\u09b6\u09c3\u0999\u09cd\u0996\u09b2\u09be\u09ac\u09a6\u09cd\u09a7 \u0995\u09f0\u09be\u09f0 \u0995\u09cd\u09f0\u09ae" },
            { "Geor", metaValue_ka },
            { "kmb", "\u0995\u09bf\u09ae\u09cd\u09ac\u09c1\u09a8\u09cd\u09a6\u09c1" },
            { "type.nu.jpanfin", "\u099c\u09be\u09aa\u09be\u09a8\u09c0 \u09ac\u09bf\u09a4\u09cd\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "gez", "\u0997\u09c0\u099c" },
            { "ebu", "\u098f\u09ae\u09cd\u09ac\u09c1" },
            { "zh_Hans", "\u09b8\u09f0\u09b2\u09c0\u0995\u09c3\u09a4 \u099a\u09c0\u09a8\u09be" },
            { "kok", "\u0995\u09cb\u0982\u0995\u09a3\u09c0" },
            { "zh_Hant", "\u09aa\u09f0\u09ae\u09cd\u09aa\u09f0\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be" },
            { "kpe", "\u0995\u09c7\u09aa\u09c7\u09b2" },
            { "type.nu.khmr", "\u0996\u09ae\u09c7\u09f0 \u0985\u0982\u0995" },
            { "ilo", "\u0987\u09b2\u09cb\u0995\u09cb" },
            { "mua", "\u09ae\u09c1\u09a3\u09cd\u09a1\u09be\u0982" },
            { "type.nu.guru", "\u0997\u09c1\u09f0\u09c1\u09ae\u09c1\u0996\u09c0 \u0985\u0982\u0995" },
            { "mul", "\u098f\u0995\u09be\u09a7\u09bf\u0995 \u09ad\u09be\u09b7\u09be" },
            { "key.ms", "\u099c\u09cb\u0996-\u09ae\u09be\u0996\u09f0 \u09aa\u09cd\u09f0\u09a3\u09be\u09b2\u09c0" },
            { "mus", "\u0995\u09cd\u09f0\u09c0\u0995" },
            { "gil", "\u0997\u09bf\u09b2\u09ac\u09be\u09f0\u09cd\u099f\u09bf\u099b" },
            { "type.nu.tamldec", "\u09a4\u09be\u09ae\u09bf\u09b2 \u0985\u0982\u0995" },
            { "krc", "\u0995\u09be\u09f0\u09be\u099a\u09c7-\u09ac\u09be\u09b2\u09cd\u0995\u09be\u09f0" },
            { "inh", "\u0987\u0982\u0997\u09c1\u099a" },
            { "krl", "\u0995\u09c7\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "efi", "\u098f\u09ab\u09bf\u0995" },
            { "key.nu", "\u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "kru", "\u0995\u09c1\u09f0\u09c1\u0996" },
            { "ksb", "\u099a\u09be\u09ae\u09cd\u09ac\u09be\u09b2\u09be" },
            { "Telu", metaValue_te },
            { "ksf", "\u09ac\u09be\u09ab\u09bf\u09af\u09bc\u09be" },
        };
        return data;
    }
}
