/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.CDOQueryQueue;
import org.eclipse.emf.cdo.internal.common.CDOQueryInfoImpl;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.internal.cdo.object.CDOObjectReferenceImpl;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.io.IORuntimeException;

public class QueryRequest
extends CDOClientRequest<Boolean> {
    private CDOView view;
    private AbstractQueryIterator<?> queryResult;

    public QueryRequest(CDOClientProtocol protocol, CDOView view, AbstractQueryIterator<?> queryResult) {
        super(protocol, (short)17);
        this.view = view;
        this.queryResult = queryResult;
    }

    @Override
    protected CDOIDProvider getIDProvider() {
        return (InternalCDOView)this.view;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.view.getViewID());
        ((CDOQueryInfoImpl)this.queryResult.getQueryInfo()).write(out);
    }

    /*
     * Loose catch block
     */
    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        block12: {
            int queryID = in.readXInt();
            this.queryResult.setQueryID(queryID);
            CDOQueryQueue resultQueue = this.queryResult.getQueue();
            boolean xrefs = this.queryResult.getQueryInfo().getQueryLanguage().equals("xrefs");
            try {
                while (in.readBoolean()) {
                    Object element;
                    if (xrefs) {
                        CDOIDReference delegate = in.readCDOIDReference();
                        element = new CDOObjectReferenceImpl(this.view, delegate);
                    } else {
                        element = in.readCDORevisionOrPrimitive();
                    }
                    resultQueue.add(element);
                }
            }
            catch (Error | RuntimeException ex) {
                resultQueue.setException(ex);
                resultQueue.close();
                break block12;
            }
            catch (IOException ex) {
                resultQueue.setException((Throwable)new IORuntimeException(ex.getMessage(), (Throwable)ex));
                break block12;
            }
            catch (Throwable ex) {
                resultQueue.setException((Throwable)new CDOException(ex.getMessage(), ex));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                resultQueue.close();
                break block12;
            }
            {
                finally {
                    resultQueue.close();
                }
            }
            resultQueue.close();
        }
        return true;
    }
}

