/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.preferences;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.xtext.ui.preferences.Messages;
import org.eclipse.xtext.ui.preferences.StatusInfo;

public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private static final String DIALOG_SETTINGS_SHOW_ALL = "ProjectSelectionDialog.show_all";
    private TableViewer tableViewer;
    private Set<IProject> projectsWithSpecifics;
    private ViewerFilter viewerFilter;
    private final IDialogSettings dialogSettings;

    public ProjectSelectionDialog(Shell parentShell, Set<IProject> projectsWithSpecifics, IDialogSettings dialogSettings) {
        super(parentShell);
        this.dialogSettings = dialogSettings;
        this.setTitle(Messages.ProjectSelectionDialog_title);
        this.setMessage(Messages.ProjectSelectionDialog_desciption);
        this.projectsWithSpecifics = projectsWithSpecifics;
        this.viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ProjectSelectionDialog.this.projectsWithSpecifics.contains(element);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        this.tableViewer = new TableViewer(composite, 2816);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.tableViewer.getTable().setLayoutData((Object)data);
        this.tableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tableViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.tableViewer.getControl().setFont(font);
        Button checkbox = new Button(composite, 32);
        checkbox.setText(Messages.ProjectSelectionDialog_filter);
        checkbox.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }
        });
        boolean doFilter = !this.dialogSettings.getBoolean(DIALOG_SETTINGS_SHOW_ALL) && !this.projectsWithSpecifics.isEmpty();
        checkbox.setSelection(doFilter);
        this.updateFilter(doFilter);
        this.tableViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void updateFilter(boolean selected) {
        if (selected) {
            this.tableViewer.addFilter(this.viewerFilter);
        } else {
            this.tableViewer.removeFilter(this.viewerFilter);
        }
        this.dialogSettings.put(DIALOG_SETTINGS_SHOW_ALL, !selected);
    }

    private void doSelectionChanged(Object[] objects) {
        if (objects.length != 1) {
            this.updateStatus(new StatusInfo(4, ""));
            this.setSelectionResult(null);
        } else {
            this.updateStatus(new StatusInfo());
            this.setSelectionResult(objects);
        }
    }

    protected void computeResult() {
    }
}

