/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.InvertEqualsFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class InvertEqualsCleanUpCore
extends AbstractCleanUpCore {
    public InvertEqualsCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public InvertEqualsCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.invert_equals");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.invert_equals")) {
            return null;
        }
        return InvertEqualsFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.invert_equals")) {
            result.add(MultiFixMessages.InvertEqualsCleanUp_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.invert_equals")) {
            return "boolean result = \"foo\".equals(text);\nboolean result2 = (text1 + text2).equals(text);\nboolean result3 = DayOfWeek.MONDAY.equals(object);\nboolean result4 = \"foo\".equalsIgnoreCase(text);\n";
        }
        return "boolean result = text.equals(\"foo\");\nboolean result2 = text.equals(text1 + text2);\nboolean result3 = object.equals(DayOfWeek.MONDAY);\nboolean result4 = text.equalsIgnoreCase(\"foo\");\n";
    }
}

