/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.configuration;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.grid.cell.AlternatingRowConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;

final class PapyrusAlternateRowConfigLabelAccumulatorForRegion
extends AlternatingRowConfigLabelAccumulator {
    private final ILayer layer;
    private IConfigRegistry configRegistry;

    public PapyrusAlternateRowConfigLabelAccumulatorForRegion(ILayer layer) {
        super(layer);
        this.layer = layer;
    }

    void setConfigRegistry(IConfigRegistry configRegistry) {
        this.configRegistry = configRegistry;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        BodyLayerStack layerStack = this.getBodyLayerStack();
        NatTable natTable = this.getNatTable();
        if (layerStack != null && natTable != null) {
            int rowIndex;
            RowHideShowLayer rowHideShowLayer = layerStack.getRowHideShowLayer();
            int realRowPosition = rowHideShowLayer.underlyingToLocalRowPosition((ILayer)natTable, rowIndex = this.layer.getRowIndexByPosition(rowPosition));
            configLabels.addLabel(realRowPosition % 2 == 0 ? "EVEN_BODY" : "ODD_BODY");
        }
        super.accumulateConfigLabels(configLabels, columnPosition, rowPosition);
    }

    private NatTable getNatTable() {
        INattableModelManager manager = this.getNattableModelManager();
        if (manager == null) {
            return null;
        }
        NatTable natTable = (NatTable)manager.getAdapter(NatTable.class);
        if (natTable.isDisposed()) {
            return null;
        }
        return natTable;
    }

    private INattableModelManager getNattableModelManager() {
        if (this.configRegistry == null) {
            return null;
        }
        return (INattableModelManager)this.configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
    }

    private BodyLayerStack getBodyLayerStack() {
        INattableModelManager manager = this.getNattableModelManager();
        if (manager == null) {
            return null;
        }
        return manager.getBodyLayerStack();
    }
}

