/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectRootElementPage
extends WizardPage {
    protected EObject selectedModelElement;
    private TreeViewer modelViewer;
    private final Resource myDomainModelResource;
    public static final String PAGE_ID = "SelectRootPage";

    public SelectRootElementPage(IStructuredSelection selection) {
        super(PAGE_ID);
        URI uri;
        this.setTitle(Messages.SelectRootElementPage_select_root_element_title);
        this.setDescription(Messages.SelectRootElementPage_select_root_element_desc);
        Resource resource = null;
        if (!selection.isEmpty() && (resource = WizardsHelper.adapt(selection.getFirstElement(), Resource.class)) == null && (uri = WizardsHelper.getSelectedResourceURI(selection)) != null) {
            resource = this.getResourceForURI(uri);
        }
        this.myDomainModelResource = resource;
    }

    public EObject getModelElement() {
        return this.selectedModelElement;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite plate = new Composite(parent, 0);
        plate.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        plate.setLayout((Layout)layout);
        this.setControl((Control)plate);
        Label label = new Label(plate, 0);
        label.setLayoutData((Object)new GridData(32));
        this.modelViewer = new TreeViewer(plate, 2820);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.modelViewer.getTree().setLayoutData((Object)layoutData);
        ComposedAdapterFactory adapterFactory = this.createAdapterFactory();
        this.modelViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.modelViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.modelViewer.setInput((Object)this.myDomainModelResource);
        this.selectedModelElement = this.getModelRoot(this.myDomainModelResource);
        this.modelViewer.setSelection((ISelection)(this.selectedModelElement == null ? new StructuredSelection() : new StructuredSelection((Object)this.selectedModelElement)));
        this.modelViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectRootElementPage.this.updateSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.modelViewer.getControl().addDisposeListener(new DisposeListener((AdapterFactory)adapterFactory){
            private final /* synthetic */ AdapterFactory val$adapterFactory;
            {
                this.val$adapterFactory = adapterFactory;
            }

            public void widgetDisposed(DisposeEvent e) {
                if (this.val$adapterFactory instanceof IDisposable) {
                    ((IDisposable)this.val$adapterFactory).dispose();
                }
            }
        });
        this.setPageComplete(this.validatePage());
    }

    private EObject getModelRoot(Resource modelResource) {
        if (modelResource == null) {
            return null;
        }
        return (EObject)modelResource.getContents().get(0);
    }

    private Resource getResourceForURI(URI uri) {
        if (uri == null) {
            return null;
        }
        ModelSet modelSet = new ModelSet();
        Resource resource = null;
        try {
            resource = modelSet.getResource(uri, true);
        }
        catch (WrappedException e) {
            if (ModelUtils.isDegradedModeAllowed((Throwable)e.getCause())) {
                resource = modelSet.getResource(uri, true);
                if (resource == null) {
                    this.error(e.getMessage());
                    throw e;
                }
            }
            this.error(e.getMessage());
            throw e;
        }
        if (!resource.getErrors().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Resource.Diagnostic d : resource.getErrors()) {
                builder.append(String.format("<li>%s</li>", d.getMessage().replaceAll("\\<.*?\\>", "")));
            }
            this.error(builder.toString());
        }
        return resource;
    }

    private void error(String message) {
        try {
            NotificationBuilder.createWarningPopup((String)String.format("<form>Problems encountered in your input model, after the save you could lose data :%s</form>", message)).setHTML(true).setType(Type.WARNING).run();
        }
        catch (Exception ex) {
            Activator.log.error(message, (Throwable)ex);
        }
    }

    protected void updateSelection(IStructuredSelection selection) {
        this.selectedModelElement = null;
        if (selection.size() == 1) {
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof IWrapperItemProvider) {
                selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
            }
            if (selectedElement instanceof FeatureMap.Entry) {
                selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
            }
            if (selectedElement instanceof EObject) {
                this.selectedModelElement = (EObject)selectedElement;
            }
        }
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        return this.selectedModelElement != null;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    protected void fillItemProviderFactories(List<AdapterFactory> factories) {
        factories.add((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add((AdapterFactory)new EcoreItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }
}

