/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.DynamicRuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.SerializationBuilder;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMetaData;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.UserElementAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.UserModelAnalysis;

public class UserElementSerializer {
    protected final @NonNull DynamicRuleMatch dynamicRuleMatch;
    protected final @NonNull UserModelAnalysis modelAnalysis;
    protected final @NonNull SerializationRule serializationRule;
    protected final @NonNull EObject element;
    private @Nullable Map<@NonNull EStructuralFeature, @NonNull Integer> feature2consumptions = null;

    public UserElementSerializer(@NonNull DynamicRuleMatch dynamicRuleMatch, @NonNull EObject element) {
        this.dynamicRuleMatch = dynamicRuleMatch;
        UserElementAnalysis elementAnalysis = dynamicRuleMatch.getElementAnalysis();
        this.modelAnalysis = elementAnalysis.getModelAnalysis();
        this.serializationRule = dynamicRuleMatch.getSerializationRule();
        this.element = element;
    }

    public @Nullable Object consumeNext(@NonNull EStructuralFeature eStructuralFeature) {
        int index;
        Integer count;
        Map<@NonNull EStructuralFeature, @NonNull Integer> feature2consumptions = this.feature2consumptions;
        if (feature2consumptions == null) {
            this.feature2consumptions = feature2consumptions = new HashMap<EStructuralFeature, Integer>();
        }
        if ((count = SerializationUtils.maybeNull(feature2consumptions.get(eStructuralFeature))) == null) {
            @NonNull Integer castInteger = 1;
            feature2consumptions.put(eStructuralFeature, castInteger);
            index = 0;
        } else {
            int intValue = count;
            @NonNull Integer castInteger = intValue + 1;
            feature2consumptions.put(eStructuralFeature, castInteger);
            index = intValue;
        }
        Object object = this.element.eGet(eStructuralFeature);
        if (eStructuralFeature.isMany()) {
            List eList = (List)object;
            assert (index < eList.size());
            object = eList.get(index);
        } else assert (index == 0);
        return object;
    }

    public @NonNull EObject getElement() {
        return this.element;
    }

    public @NonNull UserModelAnalysis getModelAnalysis() {
        return this.modelAnalysis;
    }

    public @NonNull SerializationMetaData getSerializationMetaData() {
        return this.modelAnalysis.getSerializationMetaData();
    }

    public @NonNull SerializationRule getSerializationRule() {
        return this.serializationRule;
    }

    public int getValue(int variableIndex) {
        return SerializationUtils.nonNullState(this.dynamicRuleMatch.getValue(variableIndex));
    }

    public void serialize(@NonNull SerializationBuilder serializationBuilder) {
        this.serializationRule.serialize(this, serializationBuilder);
    }

    public void serializeElement(@NonNull SerializationBuilder serializationBuilder, @NonNull EObject element, @Nullable GrammarRuleValue targetRuleValue) {
        this.modelAnalysis.serialize(serializationBuilder, element, targetRuleValue);
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        Map<@NonNull EStructuralFeature, @NonNull Integer> feature2consumptions2 = this.feature2consumptions;
        if (feature2consumptions2 != null) {
            ArrayList<@NonNull EStructuralFeature> features = new ArrayList<EStructuralFeature>(feature2consumptions2.keySet());
            Collections.sort(features, SerializationUtils.ENAMED_ELEMENT_COMPARATOR);
            boolean isFirst = true;
            for (EStructuralFeature feature : features) {
                if (!isFirst) {
                    s.append(",");
                }
                s.append(feature.getName());
                Integer consumed = feature2consumptions2.get(feature);
                assert (consumed != null);
                s.append("[");
                s.append(consumed);
                s.append("]");
                isFirst = false;
            }
        }
        @NonNull String castString = s.toString();
        return castString;
    }
}

