/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.ThreeWayTextDiff;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;

public class AttributeChangeMerger
extends AbstractMerger {
    @Override
    public boolean isMergerFor(Diff target) {
        return target instanceof AttributeChange;
    }

    @Override
    protected void accept(Diff diff, boolean rightToLeft) {
        AttributeChange attributeChange = (AttributeChange)diff;
        switch (diff.getKind()) {
            case ADD: {
                this.addInTarget(attributeChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.removeFromTarget(attributeChange, rightToLeft);
                break;
            }
            case MOVE: {
                this.moveElement(attributeChange, rightToLeft);
                break;
            }
            case CHANGE: {
                this.changeValue(attributeChange, rightToLeft);
                break;
            }
        }
    }

    @Override
    protected void reject(Diff diff, boolean rightToLeft) {
        AttributeChange attributeChange = (AttributeChange)diff;
        switch (diff.getKind()) {
            case ADD: {
                this.removeFromTarget(attributeChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.addInTarget(attributeChange, rightToLeft);
                break;
            }
            case MOVE: {
                this.moveElement(attributeChange, rightToLeft);
                break;
            }
            case CHANGE: {
                this.changeValue(attributeChange, rightToLeft);
                break;
            }
        }
    }

    protected void addInTarget(AttributeChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EObject targetContainer = this.getTargetContainer(diff, rightToLeft);
        if (targetContainer == null) {
            throw new IllegalStateException("Couldn't add in target because its parent hasn't been merged yet: " + diff);
        }
        Comparison comparison = match.getComparison();
        EAttribute attribute = diff.getAttribute();
        Object expectedValue = diff.getValue();
        if (attribute.isMany()) {
            int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
            List targetList = (List)ReferenceUtil.safeEGet(targetContainer, (EStructuralFeature)attribute);
            this.addAt(targetList, expectedValue, insertionIndex);
        } else {
            ReferenceUtil.safeESet(targetContainer, (EStructuralFeature)attribute, expectedValue);
        }
    }

    protected void removeFromTarget(AttributeChange diff, boolean rightToLeft) {
        EObject currentContainer = this.getTargetContainer(diff, rightToLeft);
        if (currentContainer != null) {
            Object expectedValue = diff.getValue();
            EAttribute attribute = diff.getAttribute();
            if (attribute.isMany()) {
                if (attribute.isUnique()) {
                    List targetList = (List)ReferenceUtil.safeEGet(currentContainer, (EStructuralFeature)attribute);
                    targetList.remove(expectedValue);
                } else {
                    this.removeNonUniqueFromTarget(diff, rightToLeft);
                }
            } else {
                currentContainer.eUnset((EStructuralFeature)attribute);
            }
        }
    }

    private void removeNonUniqueFromTarget(AttributeChange diff, boolean rightToLeft) {
        EObject targetContainer;
        EObject sourceContainer;
        Comparison comparison = diff.getMatch().getComparison();
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        EAttribute attribute = diff.getAttribute();
        if (rightToLeft) {
            sourceContainer = diff.getMatch().getRight();
            targetContainer = diff.getMatch().getLeft();
        } else {
            sourceContainer = diff.getMatch().getLeft();
            targetContainer = diff.getMatch().getRight();
        }
        List sourceList = (List)ReferenceUtil.safeEGet(sourceContainer, (EStructuralFeature)attribute);
        List targetList = (List)ReferenceUtil.safeEGet(targetContainer, (EStructuralFeature)attribute);
        Object valueToRemove = diff.getValue();
        List lcs = DiffUtil.longestCommonSubsequence(comparison, sourceList, targetList);
        int currentIndexInTarget = -1;
        Iterator lcsIteratorForTargetLookup = lcs.iterator();
        Object currentLCS = null;
        if (lcsIteratorForTargetLookup.hasNext()) {
            currentLCS = lcsIteratorForTargetLookup.next();
        }
        int j = 0;
        while (j < targetList.size() && currentIndexInTarget == -1) {
            if (currentLCS == null) {
                if (equalityHelper.matchingAttributeValues(targetList.get(j), valueToRemove)) {
                    currentIndexInTarget = j;
                }
            } else if (equalityHelper.matchingAttributeValues(targetList.get(j), currentLCS)) {
                currentLCS = lcsIteratorForTargetLookup.hasNext() ? lcsIteratorForTargetLookup.next() : null;
            } else if (equalityHelper.matchingAttributeValues(targetList.get(j), valueToRemove)) {
                currentIndexInTarget = j;
            }
            ++j;
        }
        if (currentIndexInTarget >= 0) {
            targetList.remove(currentIndexInTarget);
        }
    }

    protected void moveElement(AttributeChange diff, boolean rightToLeft) {
        EObject expectedContainer = this.getTargetContainer(diff, rightToLeft);
        if (expectedContainer == null) {
            throw new IllegalStateException("Couldn't move element because its target parent hasn't been merged yet: " + diff);
        }
        Comparison comparison = diff.getMatch().getComparison();
        Object expectedValue = diff.getValue();
        this.doMove(diff, comparison, expectedContainer, expectedValue, rightToLeft);
    }

    protected void doMove(AttributeChange diff, Comparison comparison, EObject expectedContainer, Object expectedValue, boolean rightToLeft) {
        EAttribute attribute = diff.getAttribute();
        if (attribute.isMany()) {
            if (!attribute.isUnique()) {
                this.doMoveNonUniqueAttribute(diff, comparison, rightToLeft);
            } else {
                this.doMoveUniqueAttribute(diff, comparison, expectedContainer, expectedValue, rightToLeft);
            }
        } else {
            ReferenceUtil.safeESet(expectedContainer, (EStructuralFeature)attribute, expectedValue);
        }
    }

    private void doMoveUniqueAttribute(AttributeChange diff, Comparison comparison, EObject expectedContainer, Object expectedValue, boolean rightToLeft) {
        List targetList;
        int currentIndex;
        EAttribute attribute = diff.getAttribute();
        int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
        if (insertionIndex > (currentIndex = (targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)attribute)).indexOf(expectedValue))) {
            --insertionIndex;
        }
        if (targetList instanceof EList) {
            if (insertionIndex < 0 || insertionIndex >= targetList.size()) {
                ((EList)targetList).move(targetList.size() - 1, expectedValue);
            } else {
                ((EList)targetList).move(insertionIndex, expectedValue);
            }
        } else {
            targetList.remove(expectedValue);
            if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                targetList.add(expectedValue);
            } else {
                targetList.add(insertionIndex, expectedValue);
            }
        }
    }

    private void doMoveNonUniqueAttribute(AttributeChange diff, Comparison comparison, boolean rightToLeft) {
        EObject targetContainer;
        EObject sourceContainer;
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        EAttribute attribute = diff.getAttribute();
        if (rightToLeft) {
            sourceContainer = diff.getMatch().getRight();
            targetContainer = diff.getMatch().getLeft();
        } else {
            sourceContainer = diff.getMatch().getLeft();
            targetContainer = diff.getMatch().getRight();
        }
        List sourceList = (List)ReferenceUtil.safeEGet(sourceContainer, (EStructuralFeature)attribute);
        List targetList = (List)ReferenceUtil.safeEGet(targetContainer, (EStructuralFeature)attribute);
        ArrayList copyTarget = new ArrayList(targetList);
        Object valueToMove = diff.getValue();
        Set<Object> ignoredElements = this.computeIgnoredValuesForMove(comparison, diff, targetList, rightToLeft);
        List<Object> lcs = DiffUtil.longestCommonSubsequence(comparison, ignoredElements, sourceList, copyTarget);
        int currentIndexInSource = -1;
        Iterator<Object> lcsIteratorForSourceLookup = lcs.iterator();
        Object currentLCS = null;
        if (lcsIteratorForSourceLookup.hasNext()) {
            currentLCS = lcsIteratorForSourceLookup.next();
        }
        int j = 0;
        while (j < sourceList.size() && currentIndexInSource == -1) {
            if (currentLCS == null) {
                if (equalityHelper.matchingAttributeValues(sourceList.get(j), valueToMove)) {
                    currentIndexInSource = j;
                }
            } else if (equalityHelper.matchingAttributeValues(sourceList.get(j), currentLCS)) {
                currentLCS = lcsIteratorForSourceLookup.hasNext() ? lcsIteratorForSourceLookup.next() : null;
            } else if (equalityHelper.matchingAttributeValues(sourceList.get(j), valueToMove)) {
                currentIndexInSource = j;
            }
            ++j;
        }
        int currentIndexInTarget = -1;
        Iterator<Object> lcsIteratorForTargetLookup = lcs.iterator();
        currentLCS = null;
        if (lcsIteratorForTargetLookup.hasNext()) {
            currentLCS = lcsIteratorForTargetLookup.next();
        }
        int j2 = 0;
        while (j2 < targetList.size() && currentIndexInTarget == -1) {
            if (currentLCS == null) {
                if (equalityHelper.matchingAttributeValues(targetList.get(j2), valueToMove)) {
                    currentIndexInTarget = j2;
                }
            } else if (equalityHelper.matchingAttributeValues(targetList.get(j2), currentLCS)) {
                currentLCS = lcsIteratorForTargetLookup.hasNext() ? lcsIteratorForTargetLookup.next() : null;
            } else if (equalityHelper.matchingAttributeValues(targetList.get(j2), valueToMove)) {
                currentIndexInTarget = j2;
            }
            ++j2;
        }
        int insertionIndex = DiffUtil.findInsertionIndexForElementAt(comparison, sourceList, copyTarget, lcs, currentIndexInSource);
        if (insertionIndex > currentIndexInTarget) {
            --insertionIndex;
        }
        if (targetList instanceof EList) {
            if (insertionIndex < 0 || insertionIndex >= targetList.size()) {
                ((EList)targetList).move(targetList.size() - 1, currentIndexInTarget);
            } else {
                ((EList)targetList).move(insertionIndex, currentIndexInTarget);
            }
        } else {
            targetList.remove(currentIndexInTarget);
            if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                targetList.add(valueToMove);
            } else {
                targetList.add(insertionIndex, valueToMove);
            }
        }
    }

    private Set<Object> computeIgnoredValuesForMove(Comparison comparison, AttributeChange diff, List<Object> targetList, boolean rightToLeft) {
        Set<Object> ignoredElements = DiffUtil.computeIgnoredElements(comparison, comparison.getEqualityHelper(), targetList, diff, rightToLeft);
        Iterator siblingDiffs = diff.getMatch().getDifferences().stream().filter(AttributeChange.class::isInstance).filter(d -> d.getState() == DifferenceState.UNRESOLVED && comparison.getEqualityHelper().matchingAttributeValues(diff.getValue(), ((AttributeChange)d).getValue())).iterator();
        boolean ignoreValue = true;
        while (siblingDiffs.hasNext()) {
            Diff sibling = (Diff)siblingDiffs.next();
            if (sibling.getKind() == DifferenceKind.ADD) {
                if (sibling.getSource() == DifferenceSource.LEFT && rightToLeft) {
                    ignoreValue = false;
                    continue;
                }
                if (sibling.getSource() != DifferenceSource.RIGHT || rightToLeft) continue;
                ignoreValue = false;
                continue;
            }
            if (sibling.getKind() != DifferenceKind.DELETE) continue;
            if (sibling.getSource() == DifferenceSource.LEFT && !rightToLeft) {
                ignoreValue = false;
                continue;
            }
            if (sibling.getSource() != DifferenceSource.RIGHT || !rightToLeft) continue;
            ignoreValue = false;
        }
        if (ignoreValue) {
            if (ignoredElements.isEmpty()) {
                ignoredElements = Collections.singleton(diff.getValue());
            } else {
                ignoredElements.add(diff.getValue());
            }
        }
        return ignoredElements;
    }

    @Deprecated
    protected void resetInTarget(AttributeChange diff, boolean rightToLeft) {
        EAttribute attribute = diff.getAttribute();
        EObject targetContainer = this.getTargetContainer(diff, rightToLeft);
        EObject sourceContainer = this.getSourceContainer(diff, rightToLeft);
        if (sourceContainer == null || !ReferenceUtil.safeEIsSet(targetContainer, (EStructuralFeature)attribute) || !ReferenceUtil.safeEIsSet(sourceContainer, (EStructuralFeature)attribute)) {
            targetContainer.eUnset((EStructuralFeature)attribute);
        } else {
            Object expectedValue = ReferenceUtil.safeEGet(sourceContainer, (EStructuralFeature)attribute);
            ReferenceUtil.safeESet(targetContainer, (EStructuralFeature)attribute, expectedValue);
        }
    }

    protected void changeValue(AttributeChange diff, boolean rightToLeft) {
        EObject targetContainer = this.getTargetContainer(diff, rightToLeft);
        if (targetContainer == null) {
            return;
        }
        EAttribute attribute = diff.getAttribute();
        Object targetValue = this.getTargetValue(diff, rightToLeft);
        if (this.isUnset(diff, targetValue)) {
            targetContainer.eUnset((EStructuralFeature)attribute);
        } else {
            ReferenceUtil.safeESet(targetContainer, (EStructuralFeature)attribute, targetValue);
        }
    }

    private Object getTargetValue(AttributeChange diff, boolean rightToLeft) {
        Object targetValue;
        EAttribute attribute = diff.getAttribute();
        EObject targetContainer = this.getTargetContainer(diff, rightToLeft);
        EObject sourceContainer = this.getSourceContainer(diff, rightToLeft);
        Object sourceValue = ReferenceUtil.safeEGet(sourceContainer, (EStructuralFeature)attribute);
        if (this.isEnumChangeOfDynamicEObject(diff, targetContainer)) {
            EEnum eEnum = this.getAttributeTypeEnumFromDynamicObject(targetContainer, (EStructuralFeature)attribute);
            targetValue = eEnum.getEEnumLiteral(((ENamedElement)sourceValue).getName());
        } else {
            targetValue = this.requireThreeWayTextMerge(diff) ? this.performThreeWayTextMerge(diff, rightToLeft) : sourceValue;
        }
        return targetValue;
    }

    private boolean isEnumChangeOfDynamicEObject(AttributeChange diff, EObject targetContainer) {
        return diff.getAttribute().getEType() instanceof EEnum && targetContainer instanceof DynamicEObjectImpl;
    }

    private EEnum getAttributeTypeEnumFromDynamicObject(EObject dynamicObject, EStructuralFeature attribute) {
        return (EEnum)((EEnumLiteral)ReferenceUtil.safeEGet(dynamicObject, attribute)).eContainer();
    }

    private EObject getSourceContainer(AttributeChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EObject sourceContainer = match.getComparison().isThreeWay() && this.isRejectingChange(diff, rightToLeft) ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        return sourceContainer;
    }

    private EObject getTargetContainer(AttributeChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        if (rightToLeft) {
            return match.getLeft();
        }
        return match.getRight();
    }

    private boolean isUnset(AttributeChange diff, Object targetValue) {
        Object defaultValue = diff.getAttribute().getDefaultValue();
        return targetValue == null || targetValue.equals(defaultValue) || defaultValue == null && "".equals(targetValue);
    }

    private boolean requireThreeWayTextMerge(AttributeChange diff) {
        return diff.getMatch().getComparison().isThreeWay() && this.isStringAttribute(diff.getAttribute());
    }

    private boolean isStringAttribute(EAttribute attribute) {
        return attribute.getEAttributeType().getInstanceClass() == String.class;
    }

    private boolean isAcceptingChange(AttributeChange diff, boolean rightToLeft) {
        return DifferenceSource.LEFT.equals((Object)diff.getSource()) && !rightToLeft || DifferenceSource.RIGHT.equals((Object)diff.getSource()) && rightToLeft;
    }

    private boolean isRejectingChange(AttributeChange diff, boolean rightToLeft) {
        return !this.isAcceptingChange(diff, rightToLeft);
    }

    private String performThreeWayTextMerge(AttributeChange diff, boolean rightToLeft) {
        if (this.isAcceptingChange(diff, rightToLeft)) {
            return this.performAcceptingThreeWayTextMerge(diff);
        }
        return this.performRejectingThreeWayTextMerge(diff, rightToLeft);
    }

    private String performAcceptingThreeWayTextMerge(AttributeChange diff) {
        Match match = diff.getMatch();
        EAttribute attribute = diff.getAttribute();
        String originValue = (String)ReferenceUtil.safeEGet(match.getOrigin(), (EStructuralFeature)attribute);
        String leftValue = (String)ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)attribute);
        String rightValue = (String)ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)attribute);
        return this.performThreeWayTextMerge(leftValue, rightValue, originValue);
    }

    private String performRejectingThreeWayTextMerge(AttributeChange diff, boolean rightToLeft) {
        EAttribute attribute = diff.getAttribute();
        EObject originContainer = diff.getMatch().getOrigin();
        String originValue = (String)ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)attribute);
        String changedValueFromModel = this.getChangedValueFromModel(diff);
        String changedValue = (String)diff.getValue();
        if (this.isUnset(diff, changedValueFromModel)) {
            return originValue;
        }
        return this.performThreeWayTextMerge(changedValueFromModel, originValue, changedValue);
    }

    private String getChangedValueFromModel(AttributeChange diff) {
        EObject changedContainer;
        EAttribute attribute = diff.getAttribute();
        switch (diff.getSource()) {
            case LEFT: {
                changedContainer = diff.getMatch().getLeft();
                break;
            }
            case RIGHT: {
                changedContainer = diff.getMatch().getRight();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return (String)ReferenceUtil.safeEGet(changedContainer, (EStructuralFeature)attribute);
    }

    protected String performThreeWayTextMerge(String left, String right, String origin) {
        ThreeWayTextDiff textDiff = new ThreeWayTextDiff(origin, left, right);
        return textDiff.getMerged();
    }

    protected int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        return DiffUtil.findInsertionIndex(comparison, diff, rightToLeft);
    }
}

