/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.pde.internal.build.BundleHelper;
import org.osgi.framework.Bundle;

public class AntLogAdapter
implements ILog {
    private final Object antLog;
    private Method log;

    public AntLogAdapter(Object antLog) throws NoSuchMethodException {
        this.antLog = antLog;
        try {
            this.log = antLog.getClass().getMethod("log", String.class, Integer.TYPE);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void addLogListener(ILogListener listener) {
        throw new UnsupportedOperationException();
    }

    public Bundle getBundle() {
        return BundleHelper.getDefault().getBundle();
    }

    public void log(IStatus status) {
        try {
            IStatus[] nestedStatus;
            String statusMessage = status.getMessage();
            String exceptionMessage = status.getException() != null ? status.getException().getMessage() : null;
            this.log.invoke(this.antLog, statusMessage, this.mapLogLevels(status.getSeverity()));
            if (exceptionMessage != null && !exceptionMessage.equals(statusMessage)) {
                this.log.invoke(this.antLog, exceptionMessage, this.mapLogLevels(status.getSeverity()));
            }
            if ((nestedStatus = status.getChildren()) != null) {
                IStatus[] iStatusArray = nestedStatus;
                int n = nestedStatus.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus element = iStatusArray[n2];
                    this.log(element);
                    ++n2;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private int mapLogLevels(int iStatusLevel) {
        switch (iStatusLevel) {
            case 4: {
                return 0;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 1;
    }

    public void removeLogListener(ILogListener listener) {
        throw new UnsupportedOperationException();
    }
}

