/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.pde.internal.ui.editor.PDEFormEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEProjectionSourcePage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.actions.FormatAction;
import org.eclipse.pde.internal.ui.editor.actions.HyperlinkAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class PDEFormTextEditorContributor
extends PDEFormEditorContributor {
    private RetargetTextEditorAction fCorrectionAssist;
    private HyperlinkAction fHyperlinkAction;
    private FormatAction fFormatAction;
    private RetargetTextEditorAction fContentAssist;
    private TextEditorActionContributor fSourceContributor = this.createSourceContributor();
    private SubActionBars fSourceActionBars;

    public PDEFormTextEditorContributor(String menuName) {
        super(menuName);
        if (this.supportsCorrectionAssist()) {
            this.fCorrectionAssist = new RetargetTextEditorAction(PDESourcePage.getBundleForConstructedKeys(), "CorrectionAssistProposal.");
            this.fCorrectionAssist.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        }
        if (this.supportsHyperlinking()) {
            this.fHyperlinkAction = new HyperlinkAction();
            this.fHyperlinkAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        }
        if (this.supportsFormatAction()) {
            this.fFormatAction = new FormatAction();
            this.fFormatAction.setActionDefinitionId("org.eclipse.pde.ui.edit.text.format");
        }
        if (this.supportsContentAssist()) {
            this.fContentAssist = new RetargetTextEditorAction(PDESourcePage.getBundleForConstructedKeys(), "ContentAssistProposal.");
            this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        }
    }

    public boolean supportsCorrectionAssist() {
        return false;
    }

    public boolean supportsContentAssist() {
        return false;
    }

    public boolean supportsFormatAction() {
        return false;
    }

    public boolean supportsHyperlinking() {
        return false;
    }

    @Override
    public IEditorActionBarContributor getSourceContributor() {
        return this.fSourceContributor;
    }

    @Override
    public void init(IActionBars bars) {
        super.init(bars);
        this.fSourceActionBars = new SubActionBars(bars);
        this.fSourceContributor.init((IActionBars)this.fSourceActionBars);
    }

    public void dispose() {
        this.fSourceActionBars.dispose();
        this.fSourceContributor.dispose();
        super.dispose();
    }

    protected void setSourceActionBarsActive(boolean active) {
        IActionBars rootBars = this.getActionBars();
        rootBars.clearGlobalActionHandlers();
        rootBars.updateActionBars();
        if (active) {
            this.fSourceActionBars.activate();
            Map handlers = this.fSourceActionBars.getGlobalActionHandlers();
            if (handlers != null) {
                for (String id : handlers.keySet()) {
                    rootBars.setGlobalActionHandler(id, (IAction)handlers.get(id));
                }
            }
        } else {
            this.fSourceActionBars.deactivate();
            this.registerGlobalActionHandlers();
        }
        rootBars.setGlobalActionHandler("org.eclipse.pde.ui.actions.Open", (IAction)(active ? this.fHyperlinkAction : null));
        rootBars.setGlobalActionHandler("org.eclipse.pde.ui.actions.Format", (IAction)(active ? this.fFormatAction : null));
        rootBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), this.getRevertAction());
        rootBars.updateActionBars();
    }

    private void registerGlobalActionHandlers() {
        this.registerGlobalAction(ActionFactory.DELETE.getId());
        this.registerGlobalAction(ActionFactory.UNDO.getId());
        this.registerGlobalAction(ActionFactory.REDO.getId());
        this.registerGlobalAction(ActionFactory.CUT.getId());
        this.registerGlobalAction(ActionFactory.COPY.getId());
        this.registerGlobalAction(ActionFactory.PASTE.getId());
        this.registerGlobalAction(ActionFactory.SELECT_ALL.getId());
        this.registerGlobalAction(ActionFactory.FIND.getId());
    }

    private void registerGlobalAction(String id) {
        IAction action = this.getGlobalAction(id);
        this.getActionBars().setGlobalActionHandler(id, action);
    }

    @Override
    public void setActivePage(IEditorPart newEditor) {
        if (this.fEditor == null) {
            return;
        }
        IFormPage oldPage = this.fPage;
        this.fPage = this.fEditor.getActivePageInstance();
        if (this.fPage == null) {
            return;
        }
        this.updateQuickOutlineMenuEntry();
        this.updateActions();
        if (oldPage != null && !oldPage.isEditor() && !this.fPage.isEditor()) {
            this.getActionBars().updateActionBars();
            return;
        }
        boolean isSourcePage = this.fPage instanceof PDESourcePage;
        if (isSourcePage && this.fPage.equals(oldPage)) {
            return;
        }
        this.fSourceContributor.setActiveEditor((IEditorPart)this.fPage);
        this.setSourceActionBarsActive(isSourcePage);
    }

    private void updateQuickOutlineMenuEntry() {
        IActionBars actionBars = this.getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        IMenuManager navigateMenu = menuManager.findMenuUsingPath("navigate");
        if (navigateMenu == null) {
            return;
        }
        navigateMenu.remove("org.eclipse.pde.ui.quickOutline");
        if (!(this.fPage instanceof PDEProjectionSourcePage)) {
            return;
        }
        PDEProjectionSourcePage page = (PDEProjectionSourcePage)this.fPage;
        if (!page.isQuickOutlineEnabled()) {
            return;
        }
        IAction quickOutlineAction = page.getAction("org.eclipse.pde.ui.quickOutline");
        if (quickOutlineAction == null) {
            return;
        }
        try {
            navigateMenu.insertAfter("showIn", quickOutlineAction);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected TextEditorActionContributor createSourceContributor() {
        return new PDETextEditorActionContributor();
    }

    protected HyperlinkAction getHyperlinkAction() {
        return this.fHyperlinkAction;
    }

    protected FormatAction getFormatAction() {
        return this.fFormatAction;
    }

    class PDETextEditorActionContributor
    extends TextEditorActionContributor {
        PDETextEditorActionContributor() {
        }

        public void contributeToMenu(IMenuManager mm) {
            super.contributeToMenu(mm);
            IMenuManager editMenu = mm.findMenuUsingPath("edit");
            if (editMenu != null) {
                editMenu.add((IContributionItem)new Separator("group.open"));
                editMenu.add((IContributionItem)new Separator("group.generate"));
                editMenu.add((IContributionItem)new Separator("additions"));
                if (PDEFormTextEditorContributor.this.fContentAssist != null) {
                    editMenu.prependToGroup("group.assist", (IAction)PDEFormTextEditorContributor.this.fContentAssist);
                }
            }
        }

        public void contributeToToolBar(IToolBarManager toolBarManager) {
            super.contributeToToolBar(toolBarManager);
            if (PDEFormTextEditorContributor.this.fHyperlinkAction != null) {
                toolBarManager.add((IAction)PDEFormTextEditorContributor.this.fHyperlinkAction);
            }
        }

        public void setActiveEditor(IEditorPart part) {
            ITextEditor textEditor;
            super.setActiveEditor(part);
            IActionBars actionBars = this.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(null);
            manager.setErrorMessage(null);
            ITextEditor iTextEditor = textEditor = part instanceof ITextEditor ? (ITextEditor)part : null;
            if (PDEFormTextEditorContributor.this.fCorrectionAssist != null) {
                PDEFormTextEditorContributor.this.fCorrectionAssist.setAction(this.getAction(textEditor, "QuickAssist"));
            }
            if (PDEFormTextEditorContributor.this.fHyperlinkAction != null) {
                PDEFormTextEditorContributor.this.fHyperlinkAction.setTextEditor(textEditor);
            }
            if (PDEFormTextEditorContributor.this.fFormatAction != null) {
                PDEFormTextEditorContributor.this.fFormatAction.setTextEditor(textEditor);
            }
            if (PDEFormTextEditorContributor.this.fContentAssist != null) {
                PDEFormTextEditorContributor.this.fContentAssist.setAction(this.getAction(textEditor, "ContentAssistProposal"));
            }
        }
    }
}

