/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Map;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PluginStatusDialog
extends TrayDialog {
    private boolean fShowCancelButton;
    private Map<?, ?> fInput;
    private TreeViewer treeViewer;

    public PluginStatusDialog(Shell parentShell, int style) {
        super(parentShell);
        this.setShellStyle(style);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public PluginStatusDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void showCancelButton(boolean showCancel) {
        this.fShowCancelButton = showCancel;
    }

    public void setInput(Map<?, ?> input) {
        this.fInput = input;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSectionName());
        }
        return section;
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, PDEUIMessages.PluginStatusDialog_continueButtonLabel, true);
        if (this.fShowCancelButton) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.plugin_status_dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.PluginStatusDialog_label);
        this.treeViewer = new TreeViewer(container);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setInput(this.fInput);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.getShell().setText(PDEUIMessages.PluginStatusDialog_pluginValidation);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    protected String getDialogSectionName() {
        return String.valueOf(PDEPlugin.getPluginId()) + ".PLUGIN_STATUS_DIALOG";
    }

    public void refresh(Map<?, ?> input) {
        this.fInput = input;
        this.treeViewer.setInput(input);
        this.treeViewer.refresh();
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (PluginStatusDialog.this.fInput.containsKey(parentElement)) {
                return (Object[])PluginStatusDialog.this.fInput.get(parentElement);
            }
            if (parentElement instanceof MultiStatus) {
                return ((MultiStatus)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (PluginStatusDialog.this.fInput.containsKey(element) && element instanceof BundleDescription) {
                return true;
            }
            if (element instanceof MultiStatus) {
                return ((MultiStatus)element).getChildren().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return ((Map)inputElement).keySet().toArray();
        }
    }
}

