/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.ui.shared.target.EditBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.IUContentProvider;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.pde.ui.target.ITargetLocationHandler;

public class IUFactory
implements IAdapterFactory,
ITargetLocationHandler {
    private static final Status STATUS_NO_CHANGE = new Status(0, "org.eclipse.pde.core", 101, "", null);
    private static final Status STATUS_FORCE_RELOAD = new Status(0, "org.eclipse.pde.core", 102, "", null);
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;

    public Class<?>[] getAdapterList() {
        return new Class[]{ILabelProvider.class, ITreeContentProvider.class, ITargetLocationHandler.class};
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof IUBundleContainer) {
            if (adapterType == ILabelProvider.class) {
                return (T)this.getLabelProvider();
            }
            if (adapterType == ITreeContentProvider.class) {
                return (T)this.getContentProvider();
            }
            if (adapterType == ITargetLocationHandler.class) {
                return (T)this;
            }
        } else if (adaptableObject instanceof IUContentProvider.IUWrapper) {
            if (adapterType == ILabelProvider.class) {
                return (T)this.getLabelProvider();
            }
            if (adapterType == ITargetLocationHandler.class) {
                return (T)this;
            }
        }
        return null;
    }

    @Override
    public boolean canEdit(ITargetDefinition target, TreePath path) {
        Object segment = path.getLastSegment();
        return segment instanceof IUBundleContainer || segment instanceof IUContentProvider.IUWrapper;
    }

    @Override
    public IWizard getEditWizard(ITargetDefinition target, TreePath path) {
        Object segment = path.getFirstSegment();
        if (segment instanceof IUBundleContainer) {
            return new EditBundleContainerWizard(target, (ITargetLocation)segment);
        }
        return null;
    }

    @Override
    public IStatus update(ITargetDefinition target, TreePath[] treePaths, IProgressMonitor monitor) {
        HashSet<IUBundleContainer> containers = new HashSet<IUBundleContainer>();
        HashMap<IUBundleContainer, Set> wrappersMap = new HashMap<IUBundleContainer, Set>();
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            Object lastSegment = path.getLastSegment();
            if (lastSegment instanceof IUBundleContainer) {
                containers.add((IUBundleContainer)lastSegment);
            } else if (lastSegment instanceof IUContentProvider.IUWrapper) {
                IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)lastSegment;
                wrappersMap.computeIfAbsent(wrapper.getParent(), k -> new HashSet()).add(wrapper.getIU().getId());
            }
            ++n2;
        }
        boolean changed = false;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)((containers.size() + wrappersMap.size()) * 100));
        for (IUBundleContainer iUBundleContainer : containers) {
            try {
                changed |= iUBundleContainer.update(Collections.emptySet(), (IProgressMonitor)subMonitor.split(100));
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        for (Map.Entry entry : wrappersMap.entrySet()) {
            SubMonitor split = subMonitor.split(100);
            IUBundleContainer container = (IUBundleContainer)entry.getKey();
            if (containers.contains(container)) continue;
            try {
                changed |= container.update((Set)entry.getValue(), (IProgressMonitor)split);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return changed ? Status.OK_STATUS : STATUS_NO_CHANGE;
    }

    @Override
    public boolean canRemove(ITargetDefinition target, TreePath treePath) {
        boolean isValidRoot = treePath.getFirstSegment() instanceof IUBundleContainer;
        if (treePath.getSegmentCount() == 1) {
            return isValidRoot;
        }
        return isValidRoot && treePath.getLastSegment() instanceof IUContentProvider.IUWrapper;
    }

    @Override
    public boolean canUpdate(ITargetDefinition target, TreePath treePath) {
        Object lastSegment = treePath.getLastSegment();
        return lastSegment instanceof IUBundleContainer || lastSegment instanceof IUContentProvider.IUWrapper;
    }

    @Override
    public IStatus remove(ITargetDefinition target, TreePath[] treePaths) {
        boolean forceReload = false;
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object segment = treePath.getLastSegment();
            if (segment instanceof IUBundleContainer) {
                forceReload = true;
            } else if (segment instanceof IUContentProvider.IUWrapper) {
                IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)segment;
                wrapper.getParent().removeInstallableUnit(wrapper.getIU());
            }
            ++n2;
        }
        return forceReload ? STATUS_FORCE_RELOAD : Status.OK_STATUS;
    }

    @Override
    public IStatus reload(ITargetDefinition target, ITargetLocation[] targetLocations, IProgressMonitor monitor) {
        try {
            P2TargetUtils.forceCheckTarget((ITargetDefinition)target);
            P2TargetUtils.deleteProfile((ITargetHandle)target.getHandle());
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    private ILabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new StyledBundleLabelProvider(true, false);
        }
        return this.fLabelProvider;
    }

    private ITreeContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new IUContentProvider();
        }
        return this.fContentProvider;
    }
}

