/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class ComponentLabelProvider
extends BaseLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IFontProvider {
    private final ModelEditor editor;
    public static final String NOT_RENDERED_KEY = "NOT_RENDERED_STYLER";
    public static final String NOT_VISIBLE_KEY = "NOT_VISIBLE_KEY";
    public static final String NOT_VISIBLE_AND_RENDERED_KEY = "NOT_VISIBLE_AND_RENDERED_KEY";
    private final FontDescriptor italicFontDescriptor;
    private final Messages Messages;
    private static StyledString.Styler BOTH_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = JFaceResources.getColorRegistry().get(ComponentLabelProvider.NOT_VISIBLE_AND_RENDERED_KEY);
            textStyle.strikeout = true;
        }
    };
    private static StyledString.Styler NOT_RENDERED_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = JFaceResources.getColorRegistry().get(ComponentLabelProvider.NOT_RENDERED_KEY);
            textStyle.strikeout = true;
        }
    };
    private static StyledString.Styler NOT_VISIBLE_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = JFaceResources.getColorRegistry().get(ComponentLabelProvider.NOT_VISIBLE_KEY);
        }
    };
    private final ResourceManager resourceManager;

    public ComponentLabelProvider(ModelEditor editor, Messages Messages2, FontDescriptor italicFontDescriptor) {
        this.editor = editor;
        this.Messages = Messages2;
        this.italicFontDescriptor = italicFontDescriptor;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
        super.dispose();
    }

    public StyledString getStyledText(Object element) {
        EObject o;
        AbstractComponentEditor<?> elementEditor;
        if (element instanceof EObject && (elementEditor = this.editor.getEditor((o = (EObject)element).eClass())) != null) {
            String label = elementEditor.getLabel(o);
            String detailText = elementEditor.getDetailLabel(o);
            StyledString.Styler styler = null;
            if (o instanceof MUIElement) {
                if (!((MUIElement)o).isVisible() && !((MUIElement)o).isToBeRendered()) {
                    label = String.valueOf(label) + "<" + this.Messages.ComponentLabelProvider_invisible + "/" + this.Messages.ComponentLabelProvider_notrendered + ">";
                    styler = BOTH_STYLER;
                } else if (!((MUIElement)o).isVisible()) {
                    label = String.valueOf(label) + "<" + this.Messages.ComponentLabelProvider_invisible + ">";
                    styler = NOT_VISIBLE_STYLER;
                } else if (!((MUIElement)o).isToBeRendered()) {
                    label = String.valueOf(label) + "<" + this.Messages.ComponentLabelProvider_notrendered + ">";
                    styler = NOT_RENDERED_STYLER;
                }
            }
            if (detailText == null) {
                return new StyledString(label, styler);
            }
            StyledString styledString = new StyledString(label, styler);
            styledString.append(" - " + detailText, StyledString.DECORATIONS_STYLER);
            return styledString;
        }
        return new StyledString(element.toString());
    }

    public Image getImage(Object element) {
        EObject o;
        AbstractComponentEditor<?> elementEditor;
        if (element instanceof EObject && (elementEditor = this.editor.getEditor((o = (EObject)element).eClass())) != null) {
            return elementEditor.getImage(element);
        }
        return null;
    }

    public Font getFont(Object element) {
        if (element instanceof VirtualEntry) {
            return this.resourceManager.createFont(this.italicFontDescriptor);
        }
        return null;
    }
}

