/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.importsources;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.importsources.CompositePackageImportSource;
import org.eclipse.papyrus.uml.tools.importsources.IPackageImportSource;
import org.eclipse.swt.widgets.Composite;

class PackageImportReferenceSelector
extends ReferenceSelector {
    private IPackageImportSource source;

    void setImportSource(IPackageImportSource source) {
        this.source = source;
    }

    protected Object[] getElementsToMove(Object[] selection) {
        LinkedList<? extends Object> elementsToMove = new LinkedList<Object>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IFolder || element instanceof IProject) {
                elementsToMove.addAll(this.extractFiltered((IResource)element));
            } else if (this.contentProvider.isValidValue(element)) {
                elementsToMove.add(element);
            }
            ++n2;
        }
        this.notifyCommitListeners();
        return elementsToMove.toArray();
    }

    private Collection<? extends Object> extractFiltered(IResource element) {
        FilteredChildrenResourceVisitor childrenVisitor = new FilteredChildrenResourceVisitor(this.contentProvider);
        try {
            element.accept((IResourceVisitor)childrenVisitor);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return childrenVisitor.getResult();
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        if (this.source instanceof CompositePackageImportSource) {
            this.treeViewer.expandToLevel(2);
        }
    }

    private class FilteredChildrenResourceVisitor
    implements IResourceVisitor {
        private EncapsulatedContentProvider contentProvider;
        private List<Object> elementsList = new LinkedList<Object>();

        public FilteredChildrenResourceVisitor(EncapsulatedContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                if (this.contentProvider.isValidValue((Object)resource)) {
                    boolean filtered = true;
                    ViewerFilter[] filtersArray = PackageImportReferenceSelector.this.treeViewer.getFilters();
                    int amountFilters = filtersArray.length;
                    int i = 0;
                    while (filtered && i < amountFilters) {
                        filtered = filtersArray[i].select((Viewer)PackageImportReferenceSelector.this.treeViewer, (Object)resource.getParent(), (Object)resource);
                        ++i;
                    }
                    if (filtered) {
                        this.elementsList.add(resource);
                    }
                }
                return false;
            }
            return true;
        }

        public Collection<? extends Object> getResult() {
            return this.elementsList;
        }
    }
}

